/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleScriptException;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.kotlin.dsl.execution.CompiledScript;
import org.gradle.kotlin.dsl.execution.EvalOption;
import org.gradle.kotlin.dsl.execution.EvalOptionKt;
import org.gradle.kotlin.dsl.execution.ExecutableProgram;
import org.gradle.kotlin.dsl.execution.InterpreterKt;
import org.gradle.kotlin.dsl.execution.Packaged;
import org.gradle.kotlin.dsl.execution.PartialEvaluator;
import org.gradle.kotlin.dsl.execution.Program;
import org.gradle.kotlin.dsl.execution.ProgramId;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramParser;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.execution.ResidualProgram;
import org.gradle.kotlin.dsl.execution.ResidualProgramCompiler;
import org.gradle.kotlin.dsl.execution.TemporaryScriptFilesKt;
import org.gradle.kotlin.dsl.support.GradleExtensionsKt;
import org.gradle.kotlin.dsl.support.KotlinCompilerOptions;
import org.gradle.kotlin.dsl.support.KotlinScriptHost;
import org.gradle.kotlin.dsl.support.ProjectExtensionsKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.gradle.kotlin.dsl.support.SettingsExtensionsKt;
import org.gradle.plugin.management.internal.PluginRequests;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u00039:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JR\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\b\u0002\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00180\u0017j\u0002`\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0001H\u0002J>\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u001e\u0010\u001f\u001a\u00060 R\u00020\u00002\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00180\u0017j\u0002`\u0019H\u0002JF\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002JT\u0010(\u001a\u00020)2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002J8\u00101\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u00106\u001a\u000607j\u0002`82\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020+H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u00105\u001a\u00060 R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter;", "", "host", "Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "<init>", "(Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;)V", "getHost", "()Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "eval", "", "target", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "scriptHandler", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "targetScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "baseScope", "topLevelScript", "", "options", "Ljava/util/EnumSet;", "Lorg/gradle/kotlin/dsl/execution/EvalOption;", "Lorg/gradle/kotlin/dsl/execution/EvalOptions;", "programTargetFor", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "scriptHostFor", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "programTarget", "programHostFor", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "emitSpecializedProgramFor", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "scriptHost", "programId", "Lorg/gradle/kotlin/dsl/execution/ProgramId;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "compile", "Ljava/io/File;", "scriptPath", "", "compilationClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "stage1BlocksAccessorsClassPath", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "loadClassInChildScopeOf", "classesDir", "scriptTemplateId", "accessorsClassPath", "defaultProgramHost", "startCompilerOperationFor", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Host", "FirstStageOnlyProgramHost", "ProgramHost", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpreter.kt\norg/gradle/kotlin/dsl/execution/Interpreter\n+ 2 Interpreter.kt\norg/gradle/kotlin/dsl/execution/InterpreterKt\n*L\n1#1,638:1\n598#2,5:639\n*S KotlinDebug\n*F\n+ 1 Interpreter.kt\norg/gradle/kotlin/dsl/execution/Interpreter\n*L\n323#1:639,5\n*E\n"})
public final class Interpreter {
    @NotNull
    private final Host host;
    @NotNull
    private final ProgramHost defaultProgramHost;

    public Interpreter(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.defaultProgramHost = new ProgramHost();
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public final void eval(@NotNull Object target, @NotNull ScriptSource scriptSource, @NotNull HashCode sourceHash, @NotNull ScriptHandler scriptHandler, @NotNull ClassLoaderScope targetScope, @NotNull ClassLoaderScope baseScope, boolean topLevelScript, @NotNull EnumSet<EvalOption> options) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
        Intrinsics.checkNotNullParameter((Object)scriptHandler, (String)"scriptHandler");
        Intrinsics.checkNotNullParameter((Object)targetScope, (String)"targetScope");
        Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        ProgramKind programKind = topLevelScript ? ProgramKind.TopLevel : ProgramKind.ScriptPlugin;
        ProgramTarget programTarget = this.programTargetFor(target);
        String templateId = InterpreterKt.templateIdFor(programTarget, programKind, "stage1");
        ClassLoader classLoader = baseScope.getExportClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getExportClassLoader(...)");
        ClassLoader parentClassLoader = classLoader;
        ProgramId programId = new ProgramId(templateId, sourceHash, parentClassLoader, null, null, this.host.getCompilerOptions(), 24, null);
        CompiledScript cachedProgram = this.host.cachedClassFor(programId);
        KotlinScriptHost<Object> scriptHost = this.scriptHostFor(programTarget, target, scriptSource, scriptHandler, targetScope, baseScope);
        ProgramHost programHost = this.programHostFor(options);
        if (cachedProgram != null) {
            programHost.eval(cachedProgram, scriptHost);
            return;
        }
        CompiledScript specializedProgram = this.emitSpecializedProgramFor(scriptHost, scriptSource, programId, targetScope, baseScope, programKind, programTarget);
        this.host.cache(specializedProgram, programId);
        programHost.eval(specializedProgram, scriptHost);
    }

    public static /* synthetic */ void eval$default(Interpreter interpreter, Object object, ScriptSource scriptSource, HashCode hashCode, ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope, ClassLoaderScope classLoaderScope2, boolean bl, EnumSet enumSet, int n, Object object2) {
        if ((n & 0x80) != 0) {
            enumSet = EvalOptionKt.getDefaultEvalOptions();
        }
        interpreter.eval(object, scriptSource, hashCode, scriptHandler, classLoaderScope, classLoaderScope2, bl, enumSet);
    }

    private final ProgramTarget programTargetFor(Object target) {
        ProgramTarget programTarget;
        Object object = target;
        if (object instanceof Settings) {
            programTarget = ProgramTarget.Settings;
        } else if (object instanceof Project) {
            programTarget = ProgramTarget.Project;
        } else if (object instanceof Gradle) {
            programTarget = ProgramTarget.Gradle;
        } else {
            throw new IllegalArgumentException("Unsupported target: " + target);
        }
        return programTarget;
    }

    private final KotlinScriptHost<Object> scriptHostFor(ProgramTarget programTarget, Object target, ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope) {
        return new KotlinScriptHost<Object>(target, scriptSource, scriptHandler, targetScope, baseScope, this.host.serviceRegistryFor(programTarget, target));
    }

    private final ProgramHost programHostFor(EnumSet<EvalOption> options) {
        return options.contains((Object)EvalOption.SkipBody) ? (ProgramHost)new FirstStageOnlyProgramHost() : this.defaultProgramHost;
    }

    private final CompiledScript emitSpecializedProgramFor(KotlinScriptHost<? extends Object> scriptHost, ScriptSource scriptSource, ProgramId programId, ClassLoaderScope targetScope, ClassLoaderScope baseScope, ProgramKind programKind, ProgramTarget programTarget) {
        ClassPath stage1BlocksAccessorsClassPath = WhenMappings.$EnumSwitchMapping$0[programTarget.ordinal()] == 1 ? this.host.stage1BlocksAccessorsFor(scriptHost) : ClassPath.EMPTY;
        String scriptPath = scriptHost.getFileName$kotlin_dsl();
        ClassLoaderScope classLoaderScope = targetScope.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)classLoaderScope, (String)"getParent(...)");
        ClassPath classPath = this.host.compilationClassPathOf(classLoaderScope);
        Intrinsics.checkNotNull((Object)stage1BlocksAccessorsClassPath);
        File classesDir = this.compile(scriptHost, programId, scriptPath, scriptSource, programKind, programTarget, classPath, stage1BlocksAccessorsClassPath, scriptHost.getTemporaryFileProvider$kotlin_dsl());
        return this.loadClassInChildScopeOf(baseScope, scriptPath, classesDir, programId.getTemplateId(), stage1BlocksAccessorsClassPath, scriptSource);
    }

    private final File compile(KotlinScriptHost<?> scriptHost, ProgramId programId, String scriptPath, ScriptSource scriptSource, ProgramKind programKind, ProgramTarget programTarget, ClassPath compilationClassPath, ClassPath stage1BlocksAccessorsClassPath, TemporaryFileProvider temporaryFileProvider) {
        ClassPath classPath = ClassPath.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"EMPTY");
        return this.host.cachedDirFor(scriptHost, programId, compilationClassPath, classPath, (Function1<? super File, Unit>)((Function1)arg_0 -> Interpreter.compile$lambda$2(this, scriptSource, programId, scriptPath, programKind, programTarget, compilationClassPath, temporaryFileProvider, stage1BlocksAccessorsClassPath, arg_0)));
    }

    private final CompiledScript loadClassInChildScopeOf(ClassLoaderScope baseScope, String scriptPath, File classesDir, String scriptTemplateId, ClassPath accessorsClassPath, ScriptSource scriptSource) {
        InterpreterKt.access$logClassLoadingOf(scriptTemplateId, scriptSource);
        Host host = this.host;
        String string = InterpreterKt.access$classLoaderScopeIdFor(scriptPath, scriptTemplateId);
        ClassLoaderScopeOrigin.Script script = new ClassLoaderScopeOrigin.Script(scriptSource.getFileName(), scriptSource.getLongDisplayName(), scriptSource.getShortDisplayName());
        return host.loadClassInChildScopeOf(baseScope, string, (ClassLoaderScopeOrigin)script, classesDir, "Program", accessorsClassPath);
    }

    private final AutoCloseable startCompilerOperationFor(ScriptSource scriptSource, String scriptTemplateId) {
        InterpreterKt.access$logCompilationOf(scriptTemplateId, scriptSource);
        String string = scriptSource.getShortDisplayName().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return this.host.startCompilerOperation(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit compile$lambda$2(Interpreter this$0, ScriptSource $scriptSource, ProgramId $programId, String $scriptPath, ProgramKind $programKind, ProgramTarget $programTarget, ClassPath $compilationClassPath, TemporaryFileProvider $temporaryFileProvider, ClassPath $stage1BlocksAccessorsClassPath, File cachedDir) {
        Intrinsics.checkNotNullParameter((Object)cachedDir, (String)"cachedDir");
        AutoCloseable autoCloseable = this$0.startCompilerOperationFor($scriptSource, $programId.getTemplateId());
        Throwable throwable = null;
        try {
            AutoCloseable it = autoCloseable;
            boolean bl = false;
            TextResource textResource = $scriptSource.getResource();
            Intrinsics.checkNotNull((Object)textResource);
            String sourceText = textResource.getText();
            Intrinsics.checkNotNull((Object)sourceText);
            ProgramSource programSource = new ProgramSource($scriptPath, sourceText);
            Packaged<Program> program2 = ProgramParser.INSTANCE.parse(programSource, $programKind, $programTarget);
            Packaged residualProgram2 = program2.map((Function1)new Function1<Program, ResidualProgram>((Object)new PartialEvaluator($programKind, $programTarget)){

                public final ResidualProgram invoke(Program p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((PartialEvaluator)this.receiver).reduce(p0);
                }
            });
            ScriptSource $this$withLocationAwareExceptionHandling$iv = $scriptSource;
            boolean $i$f$withLocationAwareExceptionHandling = false;
            try {
                boolean bl2 = false;
                new ResidualProgramCompiler(cachedDir, this$0.host.getCompilerOptions(), $compilationClassPath, $programId.getSourceHash(), $programKind, $programTarget, this$0.host.getImplicitImports(), InterpreterKt.getInterpreterLogger(), $temporaryFileProvider, (Function3<? super String, ? super String, ? super Function0<String>, String>)((Function3)new Function3<String, String, Function0<? extends String>, String>((Object)this$0.host){

                    public final String invoke(String p0, String p1, Function0<String> p2) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Intrinsics.checkNotNullParameter(p2, (String)"p2");
                        return ((Host)this.receiver).runCompileBuildOperation(p0, p1, p2);
                    }
                }), $stage1BlocksAccessorsClassPath, residualProgram2.getPackageName()).compile((ResidualProgram)residualProgram2.getDocument());
                Unit unit = Unit.INSTANCE;
            }
            catch (ScriptCompilationException e$iv) {
                throw new LocationAwareException((Throwable)e$iv, $this$withLocationAwareExceptionHandling$iv, e$iv.getFirstErrorLine());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$FirstStageOnlyProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter;", "<init>", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "evaluateSecondStageOf", "", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "kotlin-dsl"})
    private final class FirstStageOnlyProgramHost
    extends ProgramHost {
        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ClassPath accessorsClassPath) {
            Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkNotNullParameter((Object)accessorsClassPath, (String)"accessorsClassPath");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J@\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0011H&J\u0014\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0014\u0010\u001a\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH&J\u0014\u0010\u001b\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH&J8\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000eH&J\u001c\u0010\"\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010#\u001a\u00020$H&J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H&J\u0014\u0010(\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH&J\u0014\u0010)\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH&J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eH&J&\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001601H&J\u001c\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u0002042\n\u0010\b\u001a\u0006\u0012\u0002\b\u000305H&J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0001H\u0016R\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020\u001607X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0012\u0010:\u001a\u00020;X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006C\u00c0\u0006\u0003"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "", "cachedClassFor", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "programId", "Lorg/gradle/kotlin/dsl/execution/ProgramId;", "cache", "", "specializedProgram", "cachedDirFor", "Ljava/io/File;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "compilationClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "accessorsClassPath", "initializer", "Lkotlin/Function1;", "startCompilerOperation", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "description", "", "compilationClassPathOf", "classLoaderScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "stage1BlocksAccessorsFor", "accessorsClassPathFor", "loadClassInChildScopeOf", "childScopeId", "origin", "Lorg/gradle/initialization/ClassLoaderScopeOrigin;", "location", "className", "applyPluginsTo", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "applyBasePluginsTo", "project", "Lorg/gradle/api/internal/project/ProjectInternal;", "setupEmbeddedKotlinFor", "closeTargetScopeOf", "hashOf", "Lorg/gradle/internal/hash/HashCode;", "classPath", "runCompileBuildOperation", "scriptPath", "stage", "action", "Lkotlin/Function0;", "onScriptClassLoaded", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "Ljava/lang/Class;", "implicitImports", "", "getImplicitImports", "()Ljava/util/List;", "compilerOptions", "Lorg/gradle/kotlin/dsl/support/KotlinCompilerOptions;", "getCompilerOptions", "()Lorg/gradle/kotlin/dsl/support/KotlinCompilerOptions;", "serviceRegistryFor", "Lorg/gradle/internal/service/ServiceRegistry;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "target", "kotlin-dsl"})
    public static interface Host {
        @Nullable
        public CompiledScript cachedClassFor(@NotNull ProgramId var1);

        public void cache(@NotNull CompiledScript var1, @NotNull ProgramId var2);

        @NotNull
        public File cachedDirFor(@NotNull KotlinScriptHost<?> var1, @NotNull ProgramId var2, @NotNull ClassPath var3, @NotNull ClassPath var4, @NotNull Function1<? super File, Unit> var5);

        @NotNull
        public AutoCloseable startCompilerOperation(@NotNull String var1);

        @NotNull
        public ClassPath compilationClassPathOf(@NotNull ClassLoaderScope var1);

        @NotNull
        public ClassPath stage1BlocksAccessorsFor(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public ClassPath accessorsClassPathFor(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public CompiledScript loadClassInChildScopeOf(@NotNull ClassLoaderScope var1, @NotNull String var2, @NotNull ClassLoaderScopeOrigin var3, @NotNull File var4, @NotNull String var5, @NotNull ClassPath var6);

        public void applyPluginsTo(@NotNull KotlinScriptHost<?> var1, @NotNull PluginRequests var2);

        public void applyBasePluginsTo(@NotNull ProjectInternal var1);

        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> var1);

        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public HashCode hashOf(@NotNull ClassPath var1);

        @NotNull
        public String runCompileBuildOperation(@NotNull String var1, @NotNull String var2, @NotNull Function0<String> var3);

        public void onScriptClassLoaded(@NotNull ScriptSource var1, @NotNull Class<?> var2);

        @NotNull
        public List<String> getImplicitImports();

        @NotNull
        public KotlinCompilerOptions getCompilerOptions();

        @NotNull
        default public ServiceRegistry serviceRegistryFor(@NotNull ProgramTarget programTarget, @NotNull Object target) {
            ServiceRegistry serviceRegistry;
            Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            switch (WhenMappings.$EnumSwitchMapping$0[programTarget.ordinal()]) {
                case 1: {
                    serviceRegistry = ProjectExtensionsKt.serviceRegistryOf((Project)target);
                    break;
                }
                case 2: {
                    serviceRegistry = SettingsExtensionsKt.serviceRegistryOf((Settings)target);
                    break;
                }
                case 3: {
                    serviceRegistry = GradleExtensionsKt.serviceRegistryOf((Gradle)target);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return serviceRegistry;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            @NotNull
            public static ServiceRegistry serviceRegistryFor(@NotNull Host $this, @NotNull ProgramTarget programTarget, @NotNull Object target) {
                Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return $this.serviceRegistryFor(programTarget, target);
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProgramTarget.values().length];
                try {
                    nArray[ProgramTarget.Project.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgramTarget.Settings.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgramTarget.Gradle.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0014\u0010\u0013\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J4\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u001c2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J<\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u001f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J \u0010(\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010'\u001a\u00020\u001f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0014\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002\u00a8\u0006,"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$Host;", "<init>", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "setupEmbeddedKotlinFor", "", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "applyPluginsTo", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "applyBasePluginsTo", "project", "Lorg/gradle/api/Project;", "handleScriptException", "exception", "", "scriptClass", "Ljava/lang/Class;", "closeTargetScopeOf", "evaluateSecondStageOf", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "accessorsClassPathFor", "compileSecondStageOf", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "programId", "Lorg/gradle/kotlin/dsl/execution/ProgramId;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "eval", "compiledScript", "load", "instantiate", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram;", "specializedProgram", "kotlin-dsl"})
    @SourceDebugExtension(value={"SMAP\nInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpreter.kt\norg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost\n+ 2 Interpreter.kt\norg/gradle/kotlin/dsl/execution/InterpreterKt\n+ 3 TemporaryScriptFiles.kt\norg/gradle/kotlin/dsl/execution/TemporaryScriptFilesKt\n*L\n1#1,638:1\n613#2,9:639\n598#2,2:648\n600#2,3:662\n25#3,12:650\n*S KotlinDebug\n*F\n+ 1 Interpreter.kt\norg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost\n*L\n514#1:639,9\n478#1:648,2\n478#1:662,3\n480#1:650,12\n*E\n"})
    private class ProgramHost
    implements ExecutableProgram.Host {
        @Override
        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().setupEmbeddedKotlinFor(scriptHost);
        }

        @Override
        public void applyPluginsTo(@NotNull KotlinScriptHost<?> scriptHost, @NotNull PluginRequests pluginRequests) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)pluginRequests, (String)"pluginRequests");
            Interpreter.this.getHost().applyPluginsTo(scriptHost, pluginRequests);
        }

        @Override
        public void applyBasePluginsTo(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Interpreter.this.getHost().applyBasePluginsTo((ProjectInternal)project);
        }

        @Override
        public void handleScriptException(@NotNull Throwable exception, @NotNull Class<?> scriptClass, @NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter(scriptClass, (String)"scriptClass");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            InterpreterKt.access$locationAwareExceptionHandlingFor(exception, scriptClass, scriptHost.getScriptSource());
            throw new KotlinNothingValueException();
        }

        @Override
        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().closeTargetScopeOf(scriptHost);
        }

        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ClassPath accessorsClassPath) {
            Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkNotNullParameter((Object)accessorsClassPath, (String)"accessorsClassPath");
            ClassLoaderScope targetScope = scriptHost.getTargetScope$kotlin_dsl();
            ClassLoader classLoader = targetScope.getExportClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getExportClassLoader(...)");
            ClassLoader parentClassLoader = classLoader;
            Host host = Interpreter.this.getHost();
            ClassLoaderScope classLoaderScope = targetScope.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)classLoaderScope, (String)"getParent(...)");
            ClassPath compileClassPath = host.compilationClassPathOf(classLoaderScope);
            ProgramId programId = new ProgramId(scriptTemplateId, sourceHash, parentClassLoader, Interpreter.this.getHost().hashOf(accessorsClassPath), Interpreter.this.getHost().hashOf(compileClassPath), Interpreter.this.getHost().getCompilerOptions());
            CompiledScript cachedProgram = Interpreter.this.getHost().cachedClassFor(programId);
            if (cachedProgram != null) {
                this.eval(cachedProgram, scriptHost);
                return;
            }
            CompiledScript specializedProgram = program2.loadSecondStageFor(this, scriptHost, programId, accessorsClassPath);
            Interpreter.this.getHost().cache(specializedProgram, programId);
            this.eval(specializedProgram, scriptHost);
        }

        @Override
        @NotNull
        public ClassPath accessorsClassPathFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            return Interpreter.this.getHost().accessorsClassPathFor(scriptHost);
        }

        @Override
        @NotNull
        public CompiledScript compileSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull ProgramId programId, @NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget, @NotNull ClassPath accessorsClassPath) {
            Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
            Intrinsics.checkNotNullParameter((Object)((Object)programKind), (String)"programKind");
            Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
            Intrinsics.checkNotNullParameter((Object)accessorsClassPath, (String)"accessorsClassPath");
            String originalScriptPath = scriptHost.getFileName$kotlin_dsl();
            ClassLoaderScope targetScope = scriptHost.getTargetScope$kotlin_dsl();
            ScriptSource scriptSource = scriptHost.getScriptSource();
            ClassPath targetScopeClassPath = Interpreter.this.getHost().compilationClassPathOf(targetScope);
            ClassPath compilationClassPath = targetScopeClassPath.plus(accessorsClassPath);
            String scriptTemplateId = programId.getTemplateId();
            HashCode sourceHash = programId.getSourceHash();
            Host host = Interpreter.this.getHost();
            Intrinsics.checkNotNull((Object)compilationClassPath);
            File cacheDir2 = host.cachedDirFor(scriptHost, programId, compilationClassPath, accessorsClassPath, (Function1<? super File, Unit>)((Function1)arg_0 -> ProgramHost.compileSecondStageOf$lambda$3(Interpreter.this, scriptSource, scriptTemplateId, scriptHost, originalScriptPath, program2, compilationClassPath, sourceHash, programKind, programTarget, arg_0)));
            return Interpreter.this.loadClassInChildScopeOf(targetScope, originalScriptPath, cacheDir2, scriptTemplateId, accessorsClassPath, scriptSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void eval(@NotNull CompiledScript compiledScript, @NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter((Object)compiledScript, (String)"compiledScript");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Class<?> program2 = this.load(compiledScript, scriptHost);
            ClassLoader classLoader = program2.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            ClassLoader classLoader2 = classLoader;
            Interpreter interpreter = Interpreter.this;
            boolean $i$f$withContextClassLoader = false;
            Thread currentThread$iv = Thread.currentThread();
            ClassLoader previous$iv = currentThread$iv.getContextClassLoader();
            try {
                void classLoader$iv;
                currentThread$iv.setContextClassLoader((ClassLoader)classLoader$iv);
                boolean bl = false;
                interpreter.getHost().onScriptClassLoaded(scriptHost.getScriptSource(), program2);
                this.instantiate(program2).execute(this, scriptHost);
            }
            finally {
                currentThread$iv.setContextClassLoader(previous$iv);
            }
        }

        private final Class<?> load(CompiledScript compiledScript, KotlinScriptHost<?> scriptHost) {
            Class<?> clazz;
            try {
                clazz = compiledScript.getProgram();
            }
            catch (Exception e) {
                throw new LocationAwareException((Throwable)new GradleScriptException("Failed to load compiled script from classpath " + compiledScript.getClassPath() + '.', (Throwable)e), scriptHost.getScriptSource(), Integer.valueOf(1));
            }
            return clazz;
        }

        private final ExecutableProgram instantiate(Class<?> specializedProgram) {
            Object obj = specializedProgram.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gradle.kotlin.dsl.execution.ExecutableProgram");
            return (ExecutableProgram)obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final Unit compileSecondStageOf$lambda$3(Interpreter this$0, ScriptSource $scriptSource, String $scriptTemplateId, KotlinScriptHost $scriptHost, String $originalScriptPath, ExecutableProgram.StagedProgram $program, ClassPath $compilationClassPath, HashCode $sourceHash, ProgramKind $programKind, ProgramTarget $programTarget, File outputDir) {
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            AutoCloseable autoCloseable = this$0.startCompilerOperationFor($scriptSource, $scriptTemplateId);
            Throwable throwable = null;
            try {
                AutoCloseable it = autoCloseable;
                boolean bl = false;
                ScriptSource $this$withLocationAwareExceptionHandling$iv = $scriptSource;
                boolean $i$f$withLocationAwareExceptionHandling = false;
                try {
                    void $this$withTemporaryScriptFileFor$iv;
                    boolean bl2 = false;
                    TemporaryFileProvider temporaryFileProvider = $scriptHost.getTemporaryFileProvider$kotlin_dsl();
                    String string = $originalScriptPath;
                    String scriptText$iv = $program.getSecondStageScriptText();
                    boolean $i$f$withTemporaryScriptFileFor = false;
                    File tempDir$iv = $this$withTemporaryScriptFileFor$iv.createTemporaryDirectory("gradle-kotlin-dsl-", null, new String[0]);
                    boolean bl3 = false;
                    try {
                        Unit unit;
                        void scriptPath$iv;
                        Intrinsics.checkNotNull((Object)tempDir$iv);
                        File tempFile$iv = TemporaryScriptFilesKt.access$canonicalScriptFileFor(tempDir$iv, (String)scriptPath$iv, scriptText$iv);
                        try {
                            File scriptFile = tempFile$iv;
                            boolean bl4 = false;
                            KotlinCompilerOptions kotlinCompilerOptions = this$0.getHost().getCompilerOptions();
                            Intrinsics.checkNotNull((Object)$compilationClassPath);
                            new ResidualProgramCompiler(outputDir, kotlinCompilerOptions, $compilationClassPath, $sourceHash, $programKind, $programTarget, this$0.getHost().getImplicitImports(), InterpreterKt.getInterpreterLogger(), $scriptHost.getTemporaryFileProvider$kotlin_dsl(), (Function3)new Function3<String, String, Function0<? extends String>, String>((Object)this$0.getHost()){

                                public final String invoke(String p0, String p1, Function0<String> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((Host)this.receiver).runCompileBuildOperation(p0, p1, p2);
                                }
                            }, null, null, 3072, null).emitStage2ProgramFor(scriptFile, $originalScriptPath);
                            unit = Unit.INSTANCE;
                        }
                        finally {
                            tempFile$iv.delete();
                        }
                        Unit unit2 = unit;
                    }
                    finally {
                        tempDir$iv.delete();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (ScriptCompilationException e$iv) {
                    throw new LocationAwareException((Throwable)e$iv, $this$withLocationAwareExceptionHandling$iv, e$iv.getFirstErrorLine());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgramTarget.values().length];
            try {
                nArray[ProgramTarget.Project.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

