/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions.fat;

import org.multiverse.api.lifecycle.TxnEvent;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;
import org.multiverse.utils.Bugshaker;

public final class FatFixedLengthGammaTxn
extends GammaTxn {
    public Tranlocal head;
    public int size = 0;
    public boolean hasReads = false;
    public long localConflictCount;
    public final Listeners[] listenersArray;

    public FatFixedLengthGammaTxn(GammaStm stm) {
        this(new GammaTxnConfig(stm));
    }

    public FatFixedLengthGammaTxn(GammaTxnConfig config) {
        super(config, 4);
        this.listenersArray = new Listeners[config.maxFixedLengthTransactionSize];
        Tranlocal h = null;
        for (int k = 0; k < config.maxFixedLengthTransactionSize; ++k) {
            Tranlocal newNode = new Tranlocal();
            if (h != null) {
                h.previous = newNode;
                newNode.next = h;
            }
            h = newNode;
        }
        this.head = h;
    }

    @Override
    public final void commit() {
        if (this.status == 4) {
            return;
        }
        if (this.status != 1 && this.status != 2) {
            throw this.abortCommitOnBadStatus();
        }
        if (this.abortOnly) {
            throw this.abortCommitOnAbortOnly();
        }
        if (this.status == 1) {
            this.notifyListeners(TxnEvent.PrePrepare);
        }
        if (this.size > 0) {
            if (this.hasWrites) {
                Listeners[] listenersArray;
                BaseGammaTxnRef o;
                if (this.status == 1 && (o = this.prepareChainForCommit()) != null) {
                    throw this.abortOnReadWriteConflict(o);
                }
                if (this.commitConflict) {
                    this.config.globalConflictCounter.signalConflict();
                }
                if ((listenersArray = this.commitChain()) != null) {
                    Listeners.openAll(listenersArray, this.pool);
                }
            } else {
                this.releaseChain(true);
            }
        }
        this.status = 4;
        this.notifyListeners(TxnEvent.PostCommit);
    }

    private Listeners[] commitChain() {
        int listenersIndex = 0;
        Tranlocal node = this.head;
        do {
            BaseGammaTxnRef owner;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if ((owner = node.owner) == null) {
                return this.listenersArray;
            }
            Listeners listeners = owner.commit(node, this.pool);
            if (listeners == null) continue;
            this.listenersArray[listenersIndex] = listeners;
            ++listenersIndex;
        } while ((node = node.next) != null);
        return this.listenersArray;
    }

    @Override
    public final void prepare() {
        if (this.status == 2) {
            return;
        }
        if (this.status != 1) {
            throw this.abortPrepareOnBadStatus();
        }
        if (this.abortOnly) {
            throw this.abortPrepareOnAbortOnly();
        }
        this.notifyListeners(TxnEvent.PrePrepare);
        BaseGammaTxnRef o = this.prepareChainForCommit();
        if (o != null) {
            throw this.abortOnReadWriteConflict(o);
        }
        this.status = 2;
    }

    private BaseGammaTxnRef prepareChainForCommit() {
        if (this.skipPrepare()) {
            return null;
        }
        Tranlocal node = this.head;
        do {
            BaseGammaTxnRef owner;
            if ((owner = node.owner) == null) {
                return null;
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (owner.prepare(this, node)) continue;
            return owner;
        } while ((node = node.next) != null);
        return null;
    }

    @Override
    public final void abort() {
        if (this.status == 3) {
            return;
        }
        if (this.status == 4) {
            throw this.failAbortOnAlreadyCommitted();
        }
        this.releaseChain(false);
        this.status = 3;
        this.notifyListeners(TxnEvent.PostAbort);
    }

    private void releaseChain(boolean success) {
        Tranlocal node = this.head;
        while (node != null) {
            BaseGammaTxnRef owner = node.owner;
            if (owner == null) {
                return;
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (success) {
                owner.releaseAfterReading(node, this.pool);
            } else {
                owner.releaseAfterFailure(node, this.pool);
            }
            node = node.next;
        }
    }

    @Override
    public final Tranlocal getRefTranlocal(BaseGammaTxnRef ref) {
        Tranlocal node = this.head;
        while (node != null) {
            if (node.owner == ref) {
                return node;
            }
            if (node.owner == null) {
                return null;
            }
            node = node.next;
        }
        return null;
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortRetryOnBadStatus();
        }
        if (!this.config.isBlockingAllowed()) {
            throw this.abortRetryOnNoBlockingAllowed();
        }
        if (this.size == 0) {
            throw this.abortRetryOnNoRetryPossible();
        }
        this.retryListener.reset();
        long listenerEra = this.retryListener.getEra();
        boolean furtherRegistrationNeeded = true;
        boolean atLeastOneRegistration = false;
        Tranlocal tranlocal = this.head;
        do {
            BaseGammaTxnRef owner = tranlocal.owner;
            if (furtherRegistrationNeeded) {
                switch (owner.registerChangeListener(this.retryListener, tranlocal, this.pool, listenerEra)) {
                    case 0: {
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 1: {
                        furtherRegistrationNeeded = false;
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            owner.releaseAfterFailure(tranlocal, this.pool);
        } while ((tranlocal = tranlocal.next) != null && tranlocal.owner != null);
        this.status = 3;
        if (!atLeastOneRegistration) {
            throw this.abortRetryOnNoRetryPossible();
        }
        throw this.newRetryError();
    }

    @Override
    public final Tranlocal locate(BaseGammaTxnRef o) {
        if (this.status != 1) {
            throw this.abortLocateOnBadStatus(o);
        }
        if (o == null) {
            throw this.abortLocateOnNullArgument();
        }
        return this.getRefTranlocal(o);
    }

    @Override
    public final void hardReset() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.pool.putArrayList(this.listeners);
            this.listeners = null;
        }
        this.status = 1;
        this.hasWrites = false;
        this.size = 0;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.richmansMansConflictScan = this.config.speculativeConfiguration.get().richMansConflictScanRequired;
        this.attempt = 1;
        this.hasReads = false;
        this.abortOnly = false;
        this.commitConflict = false;
        this.evaluatingCommute = false;
    }

    @Override
    public final boolean softReset() {
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.pool.putArrayList(this.listeners);
            this.listeners = null;
        }
        this.commitConflict = false;
        this.status = 1;
        this.hasWrites = false;
        this.size = 0;
        this.hasReads = false;
        this.abortOnly = false;
        ++this.attempt;
        this.evaluatingCommute = false;
        return true;
    }

    public final void shiftInFront(Tranlocal newHead) {
        if (newHead == this.head) {
            return;
        }
        this.head.previous = newHead;
        if (newHead.next != null) {
            newHead.next.previous = newHead.previous;
        }
        newHead.previous.next = newHead.next;
        newHead.next = this.head;
        newHead.previous = null;
        this.head = newHead;
    }

    @Override
    public final boolean isReadConsistent(Tranlocal justAdded) {
        if (!this.hasReads) {
            return true;
        }
        if (this.config.readLockModeAsInt > 0) {
            return true;
        }
        if (this.config.inconsistentReadAllowed) {
            return true;
        }
        if (this.richmansMansConflictScan) {
            long currentConflictCount;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (this.localConflictCount == (currentConflictCount = this.config.globalConflictCounter.count())) {
                return true;
            }
            this.localConflictCount = currentConflictCount;
        } else if (this.size > this.config.maximumPoorMansConflictScanLength) {
            throw this.abortOnRichmanConflictScanDetected();
        }
        Tranlocal node = this.head;
        while (node != null) {
            boolean skip;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (node.owner == null) break;
            boolean bl = skip = !this.richmansMansConflictScan && node == justAdded;
            if (!skip && node.owner.hasReadConflict(node)) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    @Override
    public void initLocalConflictCounter() {
        if (this.richmansMansConflictScan && !this.hasReads) {
            this.localConflictCount = this.config.globalConflictCounter.count();
        }
    }
}

