/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.util;

import groovy.lang.Closure;
import groovyx.gpars.ReactorMessagingRunnable;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.scheduler.Pool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public abstract class PAUtils {
    public static <T> Collection<T> createCollection(Iterable<T> object) {
        ArrayList<T> collection = new ArrayList<T>();
        for (T item : object) {
            collection.add(item);
        }
        return collection;
    }

    public static <T> Collection<T> createCollection(Iterator<T> iterator) {
        ArrayList<T> collection = new ArrayList<T>();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static String[] createArray(CharSequence value) {
        String[] chars = new String[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            chars[i] = String.valueOf(value.charAt(i));
        }
        return chars;
    }

    public static <K, V> Map.Entry<K, V>[] createArray(Map<K, V> map) {
        Map.Entry[] result = new Map.Entry[map.size()];
        int i = 0;
        Iterator<Map.Entry<K, V>> i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<K, V> entry;
            result[i] = entry = i$.next();
            ++i;
        }
        return result;
    }

    public static <T> Closure<T> buildClosureForMaps(final Closure<T> cl) {
        if (cl.getMaximumNumberOfParameters() == 2) {
            return new Closure<T>(cl.getOwner()){
                private static final long serialVersionUID = -7502769124461342939L;

                public T call(Object arguments) {
                    Map.Entry entry = (Map.Entry)arguments;
                    return cl.call(new Object[]{entry.getKey(), entry.getValue()});
                }

                public T call(Object[] args) {
                    return this.call(args[0]);
                }
            };
        }
        return cl;
    }

    public static <T> Closure<T> buildClosureForMapsWithIndex(final Closure<T> cl) {
        if (cl.getMaximumNumberOfParameters() == 3) {
            return new Closure<T>(cl.getOwner()){
                private static final long serialVersionUID = 4777456744250574403L;

                public Class[] getParameterTypes() {
                    return new Class[]{Map.Entry.class, Integer.class};
                }

                public int getMaximumNumberOfParameters() {
                    return 2;
                }

                public T call(Object[] args) {
                    Map.Entry entry = (Map.Entry)args[0];
                    Integer index = (Integer)args[1];
                    return cl.call(new Object[]{entry.getKey(), entry.getValue(), index});
                }
            };
        }
        return cl;
    }

    public static <K, V> Map<K, V> buildResultMap(Collection<Map.Entry<K, V>> result) {
        HashMap<K, V> map = new HashMap<K, V>(result.size());
        for (Map.Entry<K, V> item : result) {
            map.put(item.getKey(), item.getValue());
        }
        return map;
    }

    public static Comparator<Object> createComparator(final Closure<Object> handler) {
        if (handler.getMaximumNumberOfParameters() == 2) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return (Integer)handler.call(new Object[]{o1, o2});
                }
            };
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)handler.call(o1)).compareTo(handler.call(o2));
            }
        };
    }

    public static <K, T> Closure<Object> createGroupByClosure(final Closure<K> cl, final ConcurrentMap<K, List<T>> map) {
        return new Closure<Object>(cl.getOwner(), cl.getDelegate()){
            private static final long serialVersionUID = 5495474569312257163L;

            public Object call(Object arguments) {
                Object result = cl.call(arguments);
                ArrayList<Object> localList = new ArrayList<Object>();
                localList.add(arguments);
                List myList = Collections.synchronizedList(localList);
                Collection list = map.putIfAbsent(result, myList);
                if (list != null) {
                    list.add(arguments);
                }
                return null;
            }
        };
    }

    public static <T> void evaluateArguments(final Pool pool, final Object[] args, final int current, final List<Object> soFarArgs, final DataflowVariable<Object> result, final Closure<T> original, boolean pooledThreadFlag) {
        if (current == args.length) {
            if (pooledThreadFlag) {
                try {
                    Object call = original.call(soFarArgs.toArray(new Object[soFarArgs.size()]));
                    result.leftShift(call);
                }
                catch (InvokerInvocationException e) {
                    result.bind(e.getCause());
                }
                catch (Exception all) {
                    result.bind(all);
                }
                catch (Error error) {
                    result.bind(error);
                    throw error;
                }
            } else {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result.leftShift(original.call(soFarArgs.toArray(new Object[soFarArgs.size()])));
                        }
                        catch (InvokerInvocationException e) {
                            result.bind(e.getCause());
                        }
                        catch (Exception all) {
                            result.bind(all);
                        }
                        catch (Error error) {
                            result.bind(error);
                            throw error;
                        }
                    }
                });
            }
        } else {
            Object currentArgument = args[current];
            if (currentArgument instanceof DataflowVariable) {
                DataflowVariable variable = (DataflowVariable)currentArgument;
                if (variable.isBound()) {
                    Object currentValue = null;
                    try {
                        currentValue = variable.getVal();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Interrupted while processing arguments", e);
                    }
                    if (currentValue instanceof Throwable) {
                        result.leftShift(currentValue);
                    } else {
                        soFarArgs.add(currentValue);
                        PAUtils.evaluateArguments(pool, args, current + 1, soFarArgs, result, original, pooledThreadFlag);
                    }
                } else {
                    variable.whenBound(pool, new ReactorMessagingRunnable(){

                        protected Object doRun(Object argument) {
                            if (argument instanceof Throwable) {
                                result.leftShift(argument);
                            } else {
                                soFarArgs.add(argument);
                                PAUtils.evaluateArguments(pool, args, current + 1, soFarArgs, result, original, true);
                            }
                            return null;
                        }
                    });
                }
            } else {
                soFarArgs.add(currentArgument);
                PAUtils.evaluateArguments(pool, args, current + 1, soFarArgs, result, original, pooledThreadFlag);
            }
        }
    }
}

