/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SingleOffsetReplacingOutputStream
extends FilterOutputStream {
    private final int replacementOffset;
    private final int replacementValue;
    private int currentOffset = 0;

    public SingleOffsetReplacingOutputStream(OutputStream outputStream, int replacementOffset, int replacementValue) {
        super(outputStream);
        this.replacementOffset = replacementOffset;
        this.replacementValue = replacementValue;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.currentOffset == this.replacementOffset) {
            this.out.write(this.replacementValue);
        } else {
            this.out.write(b);
        }
        ++this.currentOffset;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.offsetToReplaceIsInBufferBeingWritten(length)) {
            this.out.write(buffer, offset, this.replacementOffset - this.currentOffset);
            this.out.write(this.replacementValue);
            this.out.write(buffer, offset + (this.replacementOffset - this.currentOffset) + 1, length - (this.replacementOffset - this.currentOffset) - 1);
        } else {
            this.out.write(buffer, offset, length);
        }
        this.currentOffset += length;
    }

    private boolean offsetToReplaceIsInBufferBeingWritten(int length) {
        return this.currentOffset <= this.replacementOffset && this.currentOffset + length > this.replacementOffset;
    }
}

