/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.ArchiveManager;
import freenet.support.api.ManifestElement;
import java.util.HashMap;
import java.util.Map;

public final class ContainerSizeEstimator {
    public static final ArchiveManager.ARCHIVE_TYPE DEFAULT_ARCHIVE_TYPE = ArchiveManager.ARCHIVE_TYPE.TAR;

    private ContainerSizeEstimator() {
    }

    public static ContainerSize getSubTreeSize(HashMap<String, Object> metadata, long maxItemSize, long maxContainerSize, int maxDeep) {
        ContainerSize result = new ContainerSize();
        ContainerSizeEstimator.getSubTreeSize(metadata, result, maxItemSize, maxContainerSize, maxDeep);
        return result;
    }

    private static void getSubTreeSize(HashMap<String, Object> metadata, ContainerSize result, long maxItemSize, long maxContainerSize, int maxDeep) {
        Object me;
        Object o;
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            ContainerSize containerSize;
            o = entry.getValue();
            if (!(o instanceof ManifestElement)) continue;
            me = (ManifestElement)o;
            long itemsize = ((ManifestElement)me).getSize();
            if (itemsize > -1L) {
                containerSize = result;
                containerSize._sizeFilesNoLimit = containerSize._sizeFilesNoLimit + ContainerSizeEstimator.getContainerItemSize(((ManifestElement)me).getSize());
                containerSize = result;
                containerSize._sizeFilesNoLimit = containerSize._sizeFilesNoLimit + (long)(128 + ((ManifestElement)me).getName().length());
                if (itemsize > maxItemSize) {
                    containerSize = result;
                    containerSize._sizeFiles = containerSize._sizeFiles + 512L;
                } else {
                    containerSize = result;
                    containerSize._sizeFiles = containerSize._sizeFiles + ContainerSizeEstimator.getContainerItemSize(((ManifestElement)me).getSize());
                    containerSize = result;
                    containerSize._sizeFilesNoLimit = containerSize._sizeFilesNoLimit + (long)(128 + ((ManifestElement)me).getName().length());
                }
                if (result._sizeFiles <= maxContainerSize) continue;
                break;
            }
            containerSize = result;
            containerSize._sizeFiles = containerSize._sizeFiles + 512L;
            containerSize = result;
            containerSize._sizeFilesNoLimit = containerSize._sizeFilesNoLimit + 512L;
        }
        if (maxDeep > 0) {
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                o = entry.getValue();
                if (!(o instanceof HashMap)) continue;
                me = result;
                ((ContainerSize)me)._sizeSubTrees = ((ContainerSize)me)._sizeSubTrees + 512L;
                HashMap hm = (HashMap)o;
                ContainerSize tempResult = new ContainerSize();
                ContainerSizeEstimator.getSubTreeSize(hm, tempResult, maxItemSize, maxContainerSize - result._sizeSubTrees, maxDeep - 1);
                ContainerSize containerSize = result;
                containerSize._sizeSubTrees = containerSize._sizeSubTrees + tempResult.getSizeTotal();
                containerSize = result;
                containerSize._sizeSubTreesNoLimit = containerSize._sizeSubTreesNoLimit + tempResult.getSizeTotalNoLimit();
                if (result._sizeSubTrees <= maxContainerSize) continue;
                break;
            }
        }
    }

    public static long getContainerItemSize(long size) {
        return ContainerSizeEstimator.getContainerItemSize(DEFAULT_ARCHIVE_TYPE, size);
    }

    private static long getContainerItemSize(ArchiveManager.ARCHIVE_TYPE archiveType, long size) {
        if (archiveType == ArchiveManager.ARCHIVE_TYPE.TAR) {
            return ContainerSizeEstimator.tarItemSize(size);
        }
        throw new UnsupportedOperationException("TODO, only TAR supportet atm.");
    }

    public static long tarItemSize(long size) {
        return 512L + (size + 511L) / 512L * 512L;
    }

    public static final class ContainerSize {
        private long _sizeFiles = 0L;
        private long _sizeFilesNoLimit = 0L;
        private long _sizeSubTrees = 0L;
        private long _sizeSubTreesNoLimit = 0L;

        private ContainerSize() {
        }

        public long getSizeTotal() {
            return this._sizeFiles + this._sizeSubTrees;
        }

        public long getSizeTotalNoLimit() {
            return this._sizeFilesNoLimit + this._sizeSubTreesNoLimit;
        }

        public long getSizeFiles() {
            return this._sizeFiles;
        }

        public long getSizeFilesNoLimit() {
            return this._sizeFilesNoLimit;
        }

        public long getSizeSubTrees() {
            return this._sizeSubTrees;
        }

        public long getSizeSubTreesNoLimit() {
            return this._sizeSubTreesNoLimit;
        }
    }
}

