/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.FastRunnable;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNodeStatus;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.PeerTooOldException;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.updater.UpdateOverMandatoryManager;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.util.concurrent.TimeUnit;

public class OpennetPeerNode
extends PeerNode {
    final OpennetManager opennet;
    private long timeLastSuccess;
    private OpennetManager.ConnectionType opennetNodeAddedReason;
    private boolean wasDropped;

    public OpennetPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, OpennetManager opennet, boolean fromLocal) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        super(fs, node2, crypto, fromLocal);
        if (fromLocal) {
            SimpleFieldSet metadata = fs.subset("metadata");
            this.timeLastSuccess = metadata.getLong("timeLastSuccess", 0L);
        }
        this.opennet = opennet;
    }

    @Override
    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new OpennetPeerNodeStatus(this, noHeavy);
    }

    @Override
    public boolean isRoutingCompatible() {
        if (!this.node.isOpennetEnabled()) {
            return false;
        }
        return super.isRoutingCompatible();
    }

    @Override
    public boolean isDarknet() {
        return false;
    }

    @Override
    public boolean isOpennet() {
        return true;
    }

    @Override
    public boolean isSeed() {
        return false;
    }

    public boolean isDroppable(boolean ignoreDisconnect) {
        return this.isDroppableWithReason(ignoreDisconnect) == NOT_DROP_REASON.DROPPABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NOT_DROP_REASON isDroppableWithReason(boolean ignoreDisconnect) {
        OpennetPeerNode opennetPeerNode;
        long now = System.currentTimeMillis();
        int status = this.getPeerNodeStatus();
        long age = now - this.getPeerAddedTime();
        if (age < OpennetManager.DROP_MIN_AGE) {
            if (status == 6 ? age < OpennetManager.DROP_MIN_AGE_DISCONNECTED : status != 5) {
                return NOT_DROP_REASON.TOO_NEW_PEER;
            }
        } else {
            opennetPeerNode = this;
            synchronized (opennetPeerNode) {
                this.peerAddedTime = 0L;
                this.opennetNodeAddedReason = null;
            }
        }
        if (now - this.node.getUSM().getStartedTime() < OpennetManager.DROP_STARTUP_DELAY) {
            return NOT_DROP_REASON.TOO_LOW_UPTIME;
        }
        if (!ignoreDisconnect) {
            opennetPeerNode = this;
            synchronized (opennetPeerNode) {
                if (status == 5 && !super.neverConnected() && now - this.timeLastDisconnect < OpennetManager.DROP_DISCONNECT_DELAY && now - this.timePrevDisconnect > OpennetManager.DROP_DISCONNECT_DELAY_COOLDOWN) {
                    return NOT_DROP_REASON.RECONNECT_GRACE_PERIOD;
                }
            }
        }
        return NOT_DROP_REASON.DROPPABLE;
    }

    @Override
    public void onSuccess(boolean insert, boolean ssk) {
        if (insert || ssk) {
            return;
        }
        this.timeLastSuccess = System.currentTimeMillis();
        this.opennet.onSuccess(this);
    }

    @Override
    public void onRemove() {
        this.opennet.onRemove(this);
        super.onRemove();
    }

    @Override
    public synchronized SimpleFieldSet exportMetadataFieldSet(long now) {
        SimpleFieldSet fs = super.exportMetadataFieldSet(now);
        fs.put("timeLastSuccess", this.timeLastSuccess);
        return fs;
    }

    public final long timeLastSuccess() {
        return this.timeLastSuccess;
    }

    public static boolean validateRef(SimpleFieldSet ref) {
        return ref.getBoolean("opennet", false);
    }

    @Override
    public boolean isRealConnection() {
        return true;
    }

    @Override
    public boolean recordStatus() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OpennetPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public final boolean shouldDisconnectAndRemoveNow() {
        if (this.isConnected() && this.isUnroutableOlderVersion()) {
            return this.shouldDisconnectTooOld();
        }
        return false;
    }

    private boolean shouldDisconnectTooOld() {
        long uptime = System.currentTimeMillis() - this.timeLastConnectionCompleted();
        if (uptime < TimeUnit.SECONDS.toMillis(30L)) {
            return false;
        }
        if (uptime < TimeUnit.HOURS.toMillis(1L)) {
            return false;
        }
        NodeUpdateManager updater = this.node.getNodeUpdater();
        if (updater == null) {
            return true;
        }
        UpdateOverMandatoryManager uom = updater.getUpdateOverMandatory();
        if (uom == null) {
            return true;
        }
        if (uptime > TimeUnit.HOURS.toMillis(2L)) {
            return true;
        }
        return this.timeSinceSentUOM() >= TimeUnit.SECONDS.toMillis(60L);
    }

    @Override
    protected void onConnect() {
        super.onConnect();
        this.opennet.getCrypto().getSocket().getAddressTracker().setPresumedGuiltyAt(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L));
    }

    synchronized void setWasDropped() {
        this.wasDropped = true;
    }

    synchronized boolean wasDropped() {
        return this.wasDropped;
    }

    synchronized boolean grabWasDropped() {
        boolean ret = this.wasDropped;
        this.wasDropped = false;
        return ret;
    }

    @Override
    public synchronized void setAddedReason(OpennetManager.ConnectionType connectionType) {
        this.opennetNodeAddedReason = connectionType;
    }

    @Override
    public synchronized OpennetManager.ConnectionType getAddedReason() {
        return this.opennetNodeAddedReason;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnConnect() {
        this.node.getTicker().queueTimedJob(new FastRunnable(){

            @Override
            public void run() {
                OpennetPeerNode.this.isDroppableWithReason(false);
            }
        }, OpennetManager.DROP_MIN_AGE + 1L);
    }

    @Override
    protected boolean shouldExportPeerAddedTime() {
        return false;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnRestart(long now) {
    }

    @Override
    public void fatalTimeout() {
        if (this.node.isStopping()) {
            return;
        }
        Logger.error(this, "Disconnecting " + this + " because of fatal timeout");
        this.forceDisconnect();
    }

    @Override
    public boolean shallWeRouteAccordingToOurPeersLocation(int htl) {
        return this.node.shallWeRouteAccordingToOurPeersLocation(htl);
    }

    @Override
    boolean dontKeepFullFieldSet() {
        return true;
    }

    public OpennetManager.LinkLengthClass linkLengthClass() {
        if (!Location.isValid(this.getLocation())) {
            Logger.error(this, "No location on " + this, (Throwable)new Exception("debug"));
            return OpennetManager.LinkLengthClass.SHORT;
        }
        if (Location.distance(this, this.opennet.getNode().getLocation()) > 0.01) {
            return OpennetManager.LinkLengthClass.LONG;
        }
        return OpennetManager.LinkLengthClass.SHORT;
    }

    @Override
    public boolean isOpennetForNoderef() {
        return true;
    }

    @Override
    public boolean canAcceptAnnouncements() {
        return true;
    }

    @Override
    protected void writePeers() {
        this.node.getPeers().writePeers(true);
    }

    static enum NOT_DROP_REASON {
        DROPPABLE,
        TOO_NEW_PEER,
        TOO_LOW_UPTIME,
        RECONNECT_GRACE_PERIOD;

    }
}

