/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import java.util.regex.Pattern;

public class AddressIdentifier {
    public static final Pattern ipv4Pattern;
    public static final Pattern ipv6Pattern;
    public static final Pattern ipv6PatternWithPercentScopeID;
    public static final Pattern ipv6ISATAPPattern;

    public static AddressType getAddressType(String address) {
        return AddressIdentifier.getAddressType(address, true);
    }

    public static AddressType getAddressType(String address, boolean allowIPv6PercentScopeID) {
        if (ipv4Pattern.matcher(address).matches()) {
            return AddressType.IPv4;
        }
        if ((allowIPv6PercentScopeID ? ipv6PatternWithPercentScopeID : ipv6Pattern).matcher(address).matches()) {
            return AddressType.IPv6;
        }
        return AddressType.OTHER;
    }

    public static boolean isAnISATAPIPv6Address(String address) {
        return ipv6ISATAPPattern.matcher(address).matches();
    }

    static {
        String byteRegex = "(?>2[0-4][0-9]|25[0-5]|[01]?[0-9]?[0-9]?)";
        String ipv4AddressRegex = byteRegex + "\\.(?>" + byteRegex + "\\.)?(?>" + byteRegex + "\\.)?" + byteRegex;
        ipv4Pattern = Pattern.compile(ipv4AddressRegex);
        String wordRegex = "(?>[0-9a-f]{1,4})";
        String percentScopeIDRegex = "(?>%[0-9]{1,3})?";
        String ipv6AddressRegex = "::(?>(?>X:){0,6}X)?|X::(?>(?>X:){0,5}X)?|X:X::(?>(?>X:){0,4}X)?|X:X:X::(?>(?>X:){0,3}X)?|(?>X:){4}:(?>(?>X:){0,2}X)?|(?>X:){5}:(?>X:)?X?|(?>X:){6}:X?|(?>X:){7}(?>X|:)";
        ipv6AddressRegex = ipv6AddressRegex.replaceAll("X", wordRegex);
        String ipv6ISATAPAddressRegex = ":(?>(?>:X){1,3}:0{1,4}|:0{1,4}|):5EFE:X:X|X:(?>:0{1,4}|:(?>X:){1,2}0{1,4}|):5EFE:X:X|X:X:(?>:0{1,4}|:(?>X:)?0{1,4}|):5EFE:X:X|X:X:X:(?>X:0{1,4}|:0{1,4}|X:|):5EFE:X:X|(?>X:){4}0{1,4}:5EFE:(?>X:X|:X?|X::)";
        ipv6ISATAPAddressRegex = ipv6ISATAPAddressRegex.replaceAll("X", wordRegex);
        ipv6Pattern = Pattern.compile(ipv6AddressRegex, 2);
        ipv6PatternWithPercentScopeID = Pattern.compile("(?>" + ipv6AddressRegex + ")" + percentScopeIDRegex, 2);
        ipv6ISATAPPattern = Pattern.compile("(?>" + ipv6ISATAPAddressRegex + ")" + percentScopeIDRegex, 2);
    }

    public static enum AddressType {
        OTHER,
        IPv4,
        IPv6;

    }
}

