/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.util.ArrayList;
import java.util.List;

public class BROWSER_WARNING
implements Step {
    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        boolean incognito = request.isParameterSet("incognito");
        String ua = request.getHeader("user-agent");
        boolean isFirefox = false;
        boolean isOldFirefox = false;
        boolean showTabWarning = false;
        if (ua != null) {
            isFirefox = ua.contains("Firefox/");
            if (ua.contains("Firefox/3.6") && incognito) {
                showTabWarning = true;
            } else if (isFirefox) {
                incognito = false;
            }
            if (ua.contains("Firefox/0.") || ua.contains("Firefox/1.") || ua.contains("Firefox/2.") || ua.contains("Firefox/3.")) {
                isOldFirefox = true;
            }
        }
        boolean isRelativelySafe = isFirefox && !isOldFirefox;
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("browserWarningPageTitle"));
        String infoBoxHeader = this.infoBoxHeaderText(incognito, isRelativelySafe);
        HTMLNode infoboxContent = helper.getInfobox("infobox-normal", infoBoxHeader, contentNode, null, false);
        List<String> oldBrowserWarnings = this.oldBrowserWarnings(incognito, isOldFirefox, showTabWarning);
        if (!oldBrowserWarnings.isEmpty()) {
            HTMLNode p = infoboxContent.addChild("p");
            p.addChild("#", oldBrowserWarnings.remove(0));
            oldBrowserWarnings.forEach(s -> p.addChild("#", " " + s));
        }
        if (isRelativelySafe) {
            infoboxContent.addChild("p", incognito ? WizardL10n.l10n("browserWarningIncognitoMaybeSafe") : WizardL10n.l10n("browserWarningMaybeSafe"));
        } else {
            NodeL10n.getBase().addL10nSubstitution(infoboxContent, incognito ? "FirstTimeWizardToadlet.browserWarningIncognito" : "FirstTimeWizardToadlet.browserWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
        }
        if (incognito) {
            infoboxContent.addChild("p", WizardL10n.l10n("browserWarningIncognitoSuggestion"));
        } else {
            infoboxContent.addChild("p", WizardL10n.l10n("browserWarningSuggestion"));
        }
        infoboxContent.addChild("p", WizardL10n.l10n("browserImeWarning"));
        infoboxContent.addChild("p", WizardL10n.l10n("browserVoiceRecognitionWarning"));
        HTMLNode form = helper.addFormChild(infoboxContent.addChild("p"), ".", "continueForm");
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "back", NodeL10n.getBase().getString("Toadlet.back")});
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "next", NodeL10n.getBase().getString("Toadlet.next")});
    }

    public List<String> oldBrowserWarnings(boolean incognito, boolean isOldFirefox, boolean showTabWarning) {
        ArrayList<String> oldBrowserWarnings = new ArrayList<String>();
        if (isOldFirefox) {
            oldBrowserWarnings.add(WizardL10n.l10n("browserWarningOldFirefox"));
            if (showTabWarning) {
                oldBrowserWarnings.add(WizardL10n.l10n("browserWarningFirefoxMightHaveClobberedTabs"));
            } else if (!incognito) {
                oldBrowserWarnings.add(WizardL10n.l10n("browserWarningOldFirefoxNewerHasPrivacyMode"));
            }
        }
        return oldBrowserWarnings;
    }

    public String infoBoxHeaderText(boolean incognito, boolean isRelativelySafe) {
        if (incognito) {
            return WizardL10n.l10n("browserWarningIncognitoShort");
        }
        if (isRelativelySafe) {
            return WizardL10n.l10n("browserWarningShortRelativelySafe");
        }
        return WizardL10n.l10n("browserWarningShort");
    }

    @Override
    public String postStep(HTTPRequest request) {
        return FirstTimeWizardToadlet.WIZARD_STEP.MISC.name();
    }
}

