/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.SendPeerMessage;
import freenet.node.DarknetPeerNode;
import freenet.support.SimpleFieldSet;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class SendTextMessage
extends SendPeerMessage {
    public static final String NAME = "SendText";

    public SendTextMessage(SimpleFieldSet fs) throws MessageInvalidException {
        super(fs);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected int handleFeed(DarknetPeerNode pn) throws MessageInvalidException {
        try {
            if (this.dataLength() > 0L) {
                byte[] text = BucketTools.toByteArray(this.bucket);
                return pn.sendTextFeed(new String(text, StandardCharsets.UTF_8));
            }
            throw new MessageInvalidException(8, "Invalid data length", null, false);
        }
        catch (IOException e) {
            throw new MessageInvalidException(7, "", null, false);
        }
    }
}

