/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CommentException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.HTMLFilter;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.client.filter.TagReplacerCallback;
import freenet.client.filter.URIProcessor;
import freenet.clients.http.ExternalLinkToadlet;
import freenet.clients.http.HTTPRequestImpl;
import freenet.keys.FreenetURI;
import freenet.l10n.BaseL10n;
import freenet.l10n.NodeL10n;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.URIPreEncoder;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.api.HTTPRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.regex.Pattern;

public class GenericReadFilterCallback
implements FilterCallback,
URIProcessor {
    public static final HashSet<String> allowedProtocols = new HashSet();
    private URI baseURI;
    private URI strippedBaseURI;
    private final FoundURICallback cb;
    private final TagReplacerCallback trc;
    private final LinkFilterExceptionProvider linkFilterExceptionProvider;
    private static volatile boolean logMINOR;
    private static BaseL10n l10n;
    protected static final String UNRESERVED = "[a-zA-Z0-9\\-\\._~]";
    protected static final String PCT_ENCODED = "(?:%[0-9A-Fa-f][0-9A-Fa-f])";
    protected static final String SUB_DELIMS = "[\\!\\$&'\\(\\)\\*\\+,;=]";
    protected static final String PCHAR = "(?>[a-zA-Z0-9\\-\\._~]|(?:%[0-9A-Fa-f][0-9A-Fa-f])|[\\!\\$&'\\(\\)\\*\\+,;=]|[:@])";
    protected static final String FRAGMENT = "(?>(?>[a-zA-Z0-9\\-\\._~]|(?:%[0-9A-Fa-f][0-9A-Fa-f])|[\\!\\$&'\\(\\)\\*\\+,;=]|[:@])|\\/|\\?)*";
    private static final Pattern anchorRegex;
    static final String PLUGINS_PREFIX = "/plugins/";

    public GenericReadFilterCallback(URI uri, FoundURICallback cb, TagReplacerCallback trc, LinkFilterExceptionProvider linkFilterExceptionProvider) {
        this.baseURI = uri;
        this.cb = cb;
        this.trc = trc;
        this.linkFilterExceptionProvider = linkFilterExceptionProvider;
        this.setStrippedURI(uri.toString());
    }

    public GenericReadFilterCallback(FreenetURI uri, FoundURICallback cb, TagReplacerCallback trc, LinkFilterExceptionProvider linkFilterExceptionProvider) {
        try {
            this.baseURI = uri.toRelativeURI();
            this.setStrippedURI(this.baseURI.toString());
            this.cb = cb;
            this.trc = trc;
            this.linkFilterExceptionProvider = linkFilterExceptionProvider;
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    private void setStrippedURI(String u) {
        int idx = u.lastIndexOf(47);
        if (idx > 0) {
            u = u.substring(0, idx + 1);
            try {
                this.strippedBaseURI = new URI(u);
            }
            catch (URISyntaxException e) {
                Logger.error(this, "Can't strip base URI: " + e + " parsing " + u);
                this.strippedBaseURI = this.baseURI;
            }
        } else {
            this.strippedBaseURI = this.baseURI;
        }
    }

    @Override
    public String processURI(String u, String overrideType) throws CommentException {
        return this.processURI(u, overrideType, false, false);
    }

    @Override
    public String processURI(String u, String overrideType, boolean forBaseHref, boolean inline) throws CommentException {
        URI resolved;
        URI uri;
        if (anchorRegex.matcher(u).matches()) {
            return u;
        }
        boolean noRelative = forBaseHref;
        u = u.replaceAll(" #", " %23");
        try {
            if (logMINOR) {
                Logger.minor(this, "Processing " + u);
            }
            uri = URIPreEncoder.encodeURI(u).normalize();
            if (logMINOR) {
                Logger.minor(this, "Processing " + uri);
            }
            if (u.startsWith("/") || u.startsWith("%2f")) {
                noRelative = true;
            }
            resolved = !noRelative ? this.baseURI.resolve(uri) : uri;
            if (logMINOR) {
                Logger.minor(this, "Resolved: " + resolved);
            }
        }
        catch (URISyntaxException e1) {
            if (logMINOR) {
                Logger.minor(this, "Failed to parse URI: " + e1);
            }
            throw new CommentException(GenericReadFilterCallback.l10n("couldNotParseURIWithError", "error", e1.getMessage()));
        }
        String path = uri.getPath();
        HTTPRequestImpl req = new HTTPRequestImpl(uri, "GET");
        if (path != null) {
            if (path.equals("/") && req.isParameterSet("newbookmark") && !forBaseHref) {
                return this.processBookmark(req);
            }
            if (path.startsWith("/static/")) {
                return path;
            }
            if (this.linkFilterExceptionProvider != null && this.linkFilterExceptionProvider.isLinkExcepted(uri)) {
                return path + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
            }
        }
        String reason = GenericReadFilterCallback.l10n("deletedURI");
        URI origURI = uri;
        String host = uri.getHost();
        if (host != null && (host.equals("localhost") || host.equals("127.0.0.1")) && uri.getPort() == 8888) {
            try {
                uri = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                Logger.error(this, "URI " + uri + " looked like localhost but could not parse", (Throwable)e);
                throw new CommentException("URI looked like localhost but could not parse: " + e);
            }
            host = null;
        }
        String rpath = uri.getPath();
        if (logMINOR) {
            Logger.minor(this, "Path: \"" + path + "\" rpath: \"" + rpath + "\"");
        }
        if (host == null) {
            boolean isAbsolute = false;
            if (rpath != null) {
                if (logMINOR) {
                    Logger.minor(this, "Resolved URI (rpath absolute): \"" + rpath + "\"");
                }
                try {
                    String p = rpath;
                    while (p.startsWith("/")) {
                        p = p.substring(1);
                    }
                    FreenetURI furi = new FreenetURI(p, true);
                    isAbsolute = true;
                    if (logMINOR) {
                        Logger.minor(this, "Parsed: " + furi);
                    }
                    return this.processURI(furi, uri, overrideType, true, inline);
                }
                catch (MalformedURLException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Malformed URL (a): " + e, (Throwable)e);
                    }
                    reason = e.getMessage() != null ? GenericReadFilterCallback.l10n("malformedAbsoluteURL", "error", e.getMessage()) : GenericReadFilterCallback.l10n("couldNotParseAbsoluteFreenetURI");
                }
            }
            if (!isAbsolute && !forBaseHref) {
                rpath = resolved.getPath();
                if (rpath == null) {
                    throw new CommentException("No URI");
                }
                if (logMINOR) {
                    Logger.minor(this, "Resolved URI (rpath relative): " + rpath);
                }
                try {
                    String p = rpath;
                    while (p.startsWith("/")) {
                        p = p.substring(1);
                    }
                    FreenetURI furi = new FreenetURI(p, true);
                    if (logMINOR) {
                        Logger.minor(this, "Parsed: " + furi);
                    }
                    return this.processURI(furi, uri, overrideType, forBaseHref, inline);
                }
                catch (MalformedURLException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Malformed URL (b): " + e, (Throwable)e);
                    }
                    reason = e.getMessage() != null ? GenericReadFilterCallback.l10n("malformedRelativeURL", "error", e.getMessage()) : GenericReadFilterCallback.l10n("couldNotParseRelativeFreenetURI");
                }
            }
        }
        uri = origURI;
        if (forBaseHref) {
            throw new CommentException(GenericReadFilterCallback.l10n("bogusBaseHref"));
        }
        if (allowedProtocols.contains(uri.getScheme())) {
            return ExternalLinkToadlet.escape(uri.toString());
        }
        if (uri.getScheme() == null) {
            throw new CommentException(reason);
        }
        throw new CommentException(GenericReadFilterCallback.l10n("protocolNotEscaped", "protocol", uri.getScheme()));
    }

    @Override
    public String processURI(String u, String overrideType, String forceSchemeHostAndPort, boolean inline) throws CommentException {
        URI uri;
        String filtered;
        try {
            filtered = this.processURI(this.makeURIAbsolute(u), overrideType, true, inline);
            uri = URIPreEncoder.encodeURI(filtered).normalize();
        }
        catch (URISyntaxException e1) {
            if (logMINOR) {
                Logger.minor(this, "Failed to parse URI: " + e1);
            }
            throw new CommentException(GenericReadFilterCallback.l10n("couldNotParseURIWithError", "error", e1.getMessage()));
        }
        if (uri.getHost() == null) {
            return forceSchemeHostAndPort + filtered;
        }
        return filtered;
    }

    private String processBookmark(HTTPRequest req) throws CommentException {
        String bookmark_key = req.getParam("newbookmark");
        String bookmark_desc = req.getParam("desc");
        String bookmark_activelink = req.getParam("hasAnActivelink", "");
        try {
            FreenetURI furi = new FreenetURI(bookmark_key);
            bookmark_key = furi.toString();
            bookmark_desc = URLEncoder.encode(bookmark_desc, "UTF-8");
        }
        catch (UnsupportedEncodingException furi) {
        }
        catch (MalformedURLException e) {
            throw new CommentException("Invalid Freenet URI: " + e);
        }
        String url = "/?newbookmark=" + bookmark_key + "&desc=" + bookmark_desc;
        if (bookmark_activelink.equals("true")) {
            url = url + "&hasAnActivelink=true";
        }
        return url;
    }

    @Override
    public String makeURIAbsolute(String uri) throws URISyntaxException {
        return this.baseURI.resolve(URIPreEncoder.encodeURI(uri).normalize()).toASCIIString();
    }

    private static String l10n(String key, String pattern, String value) {
        return l10n.getString("GenericReadFilterCallback." + key, pattern, value);
    }

    private static String l10n(String key) {
        return l10n.getString("GenericReadFilterCallback." + key);
    }

    private String finishProcess(HTTPRequest req, String overrideType, String path, URI u, boolean noRelative) {
        String[] split;
        String typeOverride = req.getParam("type", null);
        if (overrideType != null) {
            typeOverride = overrideType;
        }
        if (typeOverride != null && (split = HTMLFilter.splitType(typeOverride))[1] != null) {
            String charset = split[1];
            if (charset != null) {
                try {
                    charset = URLDecoder.decode(charset, false);
                }
                catch (URLEncodedFormatException e) {
                    charset = null;
                }
            }
            if (charset != null && charset.indexOf(38) != -1) {
                charset = null;
            }
            if (charset != null && !Charset.isSupported(charset)) {
                charset = null;
            }
            typeOverride = charset != null ? split[0] + "; charset=" + charset : split[0];
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (this.strippedBaseURI.getScheme() != null && !noRelative) {
                sb.append(this.strippedBaseURI.getScheme());
                sb.append("://");
                sb.append(this.strippedBaseURI.getAuthority());
                assert (path.startsWith("/"));
            }
            sb.append(path);
            if (typeOverride != null) {
                sb.append("?type=");
                sb.append(freenet.support.URLEncoder.encode(typeOverride, "", false, "="));
            }
            if (u.getFragment() != null) {
                sb.append('#');
                sb.append(u.getRawFragment());
            }
            URI uri = new URI(sb.toString());
            if (!noRelative) {
                uri = this.strippedBaseURI.relativize(uri);
            }
            if (logMINOR) {
                Logger.minor(this, "Returning " + uri.toASCIIString() + " from " + path + " from baseURI=" + this.baseURI + " stripped base uri=" + this.strippedBaseURI.toString());
            }
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            Logger.error(this, "Could not parse own URI: path=" + path + ", typeOverride=" + typeOverride + ", frag=" + u.getFragment() + " : " + e, (Throwable)e);
            String p = path;
            if (typeOverride != null) {
                p = p + "?type=" + typeOverride;
            }
            if (u.getFragment() != null) {
                try {
                    p = p + URLEncoder.encode(u.getFragment(), "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
            }
            return p;
        }
    }

    private String processURI(FreenetURI furi, URI uri, String overrideType, boolean noRelative, boolean inline) {
        HTTPRequestImpl req = new HTTPRequestImpl(uri, "GET");
        if (this.cb != null) {
            this.cb.foundURI(furi);
        }
        if (this.cb != null) {
            this.cb.foundURI(furi, inline);
        }
        return this.finishProcess(req, overrideType, '/' + furi.toString(false, false), uri, noRelative);
    }

    @Override
    public String onBaseHref(String baseHref) {
        String ret;
        try {
            ret = this.processURI(baseHref, null, true, false);
        }
        catch (CommentException e1) {
            Logger.error(this, "Failed to parse base href: " + baseHref + " -> " + e1.getMessage());
            ret = null;
        }
        if (ret == null) {
            Logger.error(this, "onBaseHref() failed: cannot sanitize " + baseHref);
            return null;
        }
        try {
            this.baseURI = new URI(ret);
            this.setStrippedURI(ret);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        return this.baseURI.toASCIIString();
    }

    @Override
    public void onText(String s, String type) {
        if (this.cb != null) {
            this.cb.onText(s, type, this.baseURI);
        }
    }

    @Override
    public String processForm(String method, String action) throws CommentException {
        if (action == null) {
            return null;
        }
        if (method == null) {
            method = "GET";
        }
        if (!(method = method.toUpperCase()).equals("POST") && !method.equals("GET")) {
            return null;
        }
        if (action.equals("/library/")) {
            return action;
        }
        try {
            URI uri = URIPreEncoder.encodeURI(action);
            if (uri.getScheme() != null || uri.getHost() != null || uri.getPort() != -1 || uri.getUserInfo() != null) {
                throw new CommentException(GenericReadFilterCallback.l10n("invalidFormURI"));
            }
            String path = uri.getPath();
            if (path.startsWith(PLUGINS_PREFIX)) {
                String after = path.substring(PLUGINS_PREFIX.length());
                if (after.contains("../")) {
                    throw new CommentException(GenericReadFilterCallback.l10n("invalidFormURIAttemptToEscape"));
                }
                if (after.matches("[A-Za-z0-9\\.]+")) {
                    return uri.toASCIIString();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new CommentException(GenericReadFilterCallback.l10n("couldNotParseFormURIWithError", "error", e.getLocalizedMessage()));
        }
        return null;
    }

    @Override
    public String processTag(HTMLFilter.ParsedTag pt) {
        if (this.trc != null) {
            return this.trc.processTag(pt, this);
        }
        return null;
    }

    @Override
    public void onFinished() {
        if (this.cb != null) {
            this.cb.onFinishedPage();
        }
    }

    static void setBaseL10n(BaseL10n l10n) {
        GenericReadFilterCallback.l10n = l10n;
    }

    static {
        allowedProtocols.add("http");
        allowedProtocols.add("https");
        allowedProtocols.add("ftp");
        allowedProtocols.add("mailto");
        allowedProtocols.add("nntp");
        allowedProtocols.add("news");
        allowedProtocols.add("snews");
        allowedProtocols.add("about");
        allowedProtocols.add("irc");
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        l10n = NodeL10n.getBase();
        anchorRegex = Pattern.compile("^#(?>(?>[a-zA-Z0-9\\-\\._~]|(?:%[0-9A-Fa-f][0-9A-Fa-f])|[\\!\\$&'\\(\\)\\*\\+,;=]|[:@])|\\/|\\?)*$");
    }
}

