/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.node.RequestClient;

public class FetchWaiter
implements ClientGetCallback {
    private FetchResult result;
    private FetchException error;
    private boolean finished;
    private final RequestClient client;

    public FetchWaiter(RequestClient client) {
        this.client = client;
    }

    @Override
    public synchronized void onSuccess(FetchResult result, ClientGetter state) {
        if (this.finished) {
            return;
        }
        this.result = result;
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public synchronized void onFailure(FetchException e, ClientGetter state) {
        if (this.finished) {
            return;
        }
        this.error = e;
        this.finished = true;
        this.notifyAll();
    }

    public synchronized FetchResult waitForCompletion() throws FetchException {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }

    @Override
    public void onResume(ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestClient getRequestClient() {
        return this.client;
    }
}

