/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.BlockCipher;
import freenet.crypt.ECDSA;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.AddressTracker;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.IncomingPacketFilterImpl;
import freenet.io.comm.Peer;
import freenet.io.comm.UdpSocketHandler;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.DarknetPeerNode;
import freenet.node.FNPPacketMangler;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeIPPortDetector;
import freenet.node.NodeInitException;
import freenet.node.PeerNode;
import freenet.node.Version;
import freenet.support.Base64;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;

public class NodeCrypto {
    private static volatile boolean logMINOR;
    public static final int IDENTITY_LENGTH = 32;
    final Node node;
    @Deprecated
    final boolean isOpennet;
    final RandomSource random;
    @Deprecated
    final UdpSocketHandler socket;
    @Deprecated
    public FNPPacketMangler packetMangler;
    @Deprecated
    final int portNumber;
    @Deprecated
    byte[] myIdentity;
    @Deprecated
    byte[] identityHash;
    @Deprecated
    byte[] identityHashHash;
    byte[] clientNonce;
    private ECDSA ecdsaP256;
    @Deprecated
    byte[] ecdsaPubKeyHash;
    @Deprecated
    InsertableClientSSK myARK;
    @Deprecated
    long myARKNumber;
    @Deprecated
    final NodeCryptoConfig config;
    @Deprecated
    final NodeIPPortDetector detector;
    @Deprecated
    final BlockCipher anonSetupCipher;
    private String mySignedReference = null;
    private String myReferenceECDSASignature = null;
    private volatile Object referenceSync = new Object();

    public NodeCrypto(Node node, boolean isOpennet, NodeCryptoConfig config, long startupTime, boolean enableARKs) throws NodeInitException {
        this.node = node;
        this.config = config;
        this.random = node.getRandom();
        this.isOpennet = isOpennet;
        config.starting(this);
        try {
            int port = config.getPort();
            FreenetInetAddress bindto = config.getBindTo();
            UdpSocketHandler u = null;
            if (port > 65535) {
                throw new NodeInitException(10, "Impossible port number: " + port);
            }
            if (port == -1) {
                for (int i = 0; i < 200000; ++i) {
                    int portNo = 1024 + this.random.nextInt(64511);
                    try {
                        u = new UdpSocketHandler(portNo, bindto.getAddress(), node, startupTime, this.getTitle(portNo), node.getCollector());
                        port = u.getPortNumber();
                        break;
                    }
                    catch (Exception e) {
                        Logger.normal(this, "Could not use port: " + bindto + ':' + portNo + ": " + e, (Throwable)e);
                        System.err.println("Could not use port: " + bindto + ':' + portNo + ": " + e);
                        e.printStackTrace();
                        continue;
                    }
                }
                if (u == null) {
                    throw new NodeInitException(11, "Could not find an available UDP port number for FNP (none specified)");
                }
            } else {
                try {
                    u = new UdpSocketHandler(port, bindto.getAddress(), node, startupTime, this.getTitle(port), node.getCollector());
                }
                catch (Exception e) {
                    Logger.error(this, "Caught " + e, (Throwable)e);
                    System.err.println(e);
                    e.printStackTrace();
                    throw new NodeInitException(10, "Could not bind to port: " + port + " (node already running?)");
                }
            }
            this.socket = u;
            Logger.normal(this, "FNP port created on " + bindto + ':' + port);
            System.out.println("FNP port created on " + bindto + ':' + port);
            this.portNumber = port;
            config.setPort(port);
            this.socket.setDropProbability(config.getDropProbability());
            this.packetMangler = new FNPPacketMangler(node, this, this.socket);
            this.detector = new NodeIPPortDetector(node, node.getIpDetector(), this, enableARKs);
            this.anonSetupCipher = new Rijndael(256, 256);
        }
        catch (NodeInitException e) {
            config.stopping(this);
            throw e;
        }
        catch (RuntimeException e) {
            config.stopping(this);
            throw e;
        }
        catch (Error e) {
            config.stopping(this);
            throw e;
        }
        catch (UnsupportedCipherException e) {
            config.stopping(this);
            throw new Error(e);
        }
        finally {
            config.maybeStarted(this);
        }
    }

    private String getTitle(int port) {
        return "UDP " + (this.isOpennet ? "Opennet " : "Darknet ") + "port " + port;
    }

    public void readCrypto(SimpleFieldSet fs) throws IOException {
        String identity = fs.get("identity");
        if (identity == null) {
            throw new IOException();
        }
        try {
            this.myIdentity = Base64.decode(identity);
        }
        catch (IllegalBase64Exception e2) {
            throw new IOException();
        }
        this.identityHash = SHA256.digest(this.myIdentity);
        this.anonSetupCipher.initialize(this.identityHash);
        this.identityHashHash = SHA256.digest(this.identityHash);
        try {
            SimpleFieldSet ecdsaSFS = fs.subset("ecdsa");
            if (ecdsaSFS != null) {
                this.ecdsaP256 = new ECDSA(ecdsaSFS.subset(ECDSA.Curves.P256.name()), ECDSA.Curves.P256);
            }
        }
        catch (FSParseException e) {
            Logger.error(this, "Caught " + e, (Throwable)e);
            throw new IOException(e.toString());
        }
        if (this.ecdsaP256 == null) {
            Logger.normal(this, "No ecdsa.P256 field found in noderef: let's generate a new key");
            this.ecdsaP256 = new ECDSA(ECDSA.Curves.P256);
        }
        this.ecdsaPubKeyHash = SHA256.digest(this.ecdsaP256.getPublicKey().getEncoded());
        InsertableClientSSK ark = null;
        String s = fs.get("ark.number");
        String privARK = fs.get("ark.privURI");
        try {
            if (privARK != null) {
                FreenetURI uri = new FreenetURI(privARK);
                ark = InsertableClientSSK.create(uri);
                if (s == null) {
                    ark = null;
                    this.myARKNumber = 0L;
                } else {
                    try {
                        this.myARKNumber = Long.parseLong(s);
                    }
                    catch (NumberFormatException e) {
                        this.myARKNumber = 0L;
                        ark = null;
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            Logger.minor(this, "Caught " + e, (Throwable)e);
            ark = null;
        }
        if (ark == null) {
            ark = InsertableClientSSK.createRandom(this.random, "ark");
            this.myARKNumber = 0L;
        }
        this.myARK = ark;
        String cn = fs.get("clientNonce");
        if (cn != null) {
            try {
                this.clientNonce = Base64.decode(cn);
            }
            catch (IllegalBase64Exception e) {
                throw new IOException("Invalid clientNonce field: " + e);
            }
        } else {
            this.clientNonce = new byte[32];
            this.node.getRandom().nextBytes(this.clientNonce);
        }
    }

    public void initCrypto() {
        this.ecdsaP256 = new ECDSA(ECDSA.Curves.P256);
        this.ecdsaPubKeyHash = SHA256.digest(this.ecdsaP256.getPublicKey().getEncoded());
        this.myARK = InsertableClientSSK.createRandom(this.random, "ark");
        this.myARKNumber = 0L;
        this.clientNonce = new byte[32];
        this.node.getRandom().nextBytes(this.clientNonce);
        this.myIdentity = new byte[32];
        this.node.getRandom().nextBytes(this.myIdentity);
        this.identityHash = SHA256.digest(this.myIdentity);
        this.identityHashHash = SHA256.digest(this.identityHash);
        this.anonSetupCipher.initialize(this.identityHash);
    }

    public void start() {
        this.socket.calculateMaxPacketSize();
        this.socket.setLowLevelFilter(new IncomingPacketFilterImpl(this.packetMangler, this.node, this));
        this.packetMangler.start();
        this.socket.start();
    }

    public SimpleFieldSet exportPrivateFieldSet() {
        SimpleFieldSet fs = this.exportPublicFieldSet(false, false, false);
        this.addPrivateFields(fs);
        return fs;
    }

    public SimpleFieldSet exportPublicFieldSet() {
        return this.exportPublicFieldSet(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFieldSet exportPublicFieldSet(boolean forSetup, boolean forAnonInitiator, boolean forARK) {
        Peer[] ips;
        SimpleFieldSet fs = this.exportPublicCryptoFieldSet(forSetup || forARK, forAnonInitiator);
        if (!forAnonInitiator && !forSetup && (ips = this.detector.detectPrimaryPeers()) != null) {
            for (Peer ip : ips) {
                fs.putAppend("physical.udp", ip.toString());
            }
        }
        if (!(forARK || forSetup || forAnonInitiator)) {
            fs.put("location", this.node.getLocationManager().getLocation());
        }
        fs.putSingle("version", Version.getVersionString());
        if (!forAnonInitiator) {
            fs.putSingle("lastGoodVersion", Version.getLastGoodVersionString());
        }
        if (Node.isTestnetEnabled()) {
            fs.put("testnet", true);
        }
        if (!(this.isOpennet || forSetup || forARK)) {
            fs.putSingle("myName", this.node.getMyName());
        }
        if (!forAnonInitiator) {
            fs.put("opennet", this.isOpennet);
            Object object = this.referenceSync;
            synchronized (object) {
                if (this.myReferenceECDSASignature == null || this.mySignedReference == null || !this.mySignedReference.equals(fs.toOrderedString())) {
                    this.mySignedReference = fs.toOrderedString();
                    try {
                        this.myReferenceECDSASignature = this.ecdsaSignRef(this.mySignedReference);
                        fs.putSingle("sigP256", this.myReferenceECDSASignature);
                        this.mySignedReference = fs.toOrderedString();
                    }
                    catch (NodeInitException e) {
                        this.node.exit(e.exitCode);
                    }
                }
            }
        }
        if (logMINOR) {
            Logger.minor(this, "My reference: " + fs.toOrderedString());
        }
        return fs;
    }

    SimpleFieldSet exportPublicCryptoFieldSet(boolean forSetup, boolean forAnonInitiator) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        int[] negTypes = this.packetMangler.supportedNegTypes(true);
        if (!forSetup) {
            fs.put("ecdsa", this.ecdsaP256.asFieldSet(false));
            fs.putSingle("identity", Base64.encode(this.myIdentity));
        }
        if (!forAnonInitiator) {
            fs.put("auth.negTypes", negTypes);
            if (!forSetup) {
                fs.put("ark.number", this.myARKNumber);
                fs.putSingle("ark.pubURI", this.myARK.getURI().toString(false, false));
            }
        }
        return fs;
    }

    private String ecdsaSignRef(String mySignedReference) throws NodeInitException {
        if (logMINOR) {
            Logger.minor(this, "Signing reference:\n" + mySignedReference);
        }
        byte[] ref = mySignedReference.getBytes(StandardCharsets.UTF_8);
        byte[] sig = this.ecdsaP256.sign(new byte[][]{ref});
        if (logMINOR && !ECDSA.verify(ECDSA.Curves.P256, this.getECDSAP256Pubkey(), sig, new byte[][]{ref})) {
            throw new NodeInitException(1023, mySignedReference);
        }
        return Base64.encode(sig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] myCompressedRef(boolean setup, boolean heavySetup, boolean forARK) {
        SimpleFieldSet fs = this.exportPublicFieldSet(setup, heavySetup, forARK);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream gis = new DeflaterOutputStream(baos);
        try {
            fs.writeTo(gis);
        }
        catch (IOException e) {
            Logger.error(this, "IOE :" + e.getMessage(), (Throwable)e);
        }
        finally {
            Closer.close(gis);
            Closer.close(baos);
        }
        byte[] buf = baos.toByteArray();
        if (buf.length >= 4096) {
            throw new IllegalStateException("We are attempting to send a " + buf.length + " bytes big reference!");
        }
        byte[] obuf = new byte[buf.length + 1];
        int offset = 0;
        obuf[offset++] = 1;
        System.arraycopy(buf, 0, obuf, offset, buf.length);
        if (logMINOR) {
            Logger.minor(this, "myCompressedRef(" + setup + "," + heavySetup + ") returning " + obuf.length + " bytes");
        }
        return obuf;
    }

    public byte[] myCompressedSetupRef() {
        return this.myCompressedRef(true, false, false);
    }

    public byte[] myCompressedHeavySetupRef() {
        return this.myCompressedRef(false, true, false);
    }

    public byte[] myCompressedFullRef() {
        return this.myCompressedRef(false, false, false);
    }

    void addPrivateFields(SimpleFieldSet fs) {
        fs.removeSubset("ecdsa");
        fs.put("ecdsa", this.ecdsaP256.asFieldSet(true));
        fs.putSingle("ark.privURI", this.myARK.getInsertURI().toString(false, false));
        fs.putSingle("clientNonce", Base64.encode(this.clientNonce));
    }

    byte[] ecdsaSign(byte[] ... data) {
        return this.ecdsaP256.signToNetworkFormat(data);
    }

    public ECPublicKey getECDSAP256Pubkey() {
        return this.ecdsaP256.getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetDropProbability(int val) {
        NodeCrypto nodeCrypto = this;
        synchronized (nodeCrypto) {
            if (this.socket == null) {
                return;
            }
        }
        this.socket.setDropProbability(val);
    }

    public void stop() {
        this.config.stopping(this);
        this.socket.close();
    }

    public PeerNode[] getPeerNodes() {
        if (this.node.getPeers() == null) {
            return null;
        }
        if (this.isOpennet) {
            return this.node.getPeers().getOpennetAndSeedServerPeers();
        }
        return this.node.getPeers().getDarknetPeers();
    }

    public boolean allowConnection(PeerNode pn, FreenetInetAddress addr) {
        if (this.config.oneConnectionPerAddress() && this.node.getPeers().anyConnectedPeerHasAddress(addr, pn) && !this.detector.includes(addr) && addr.isRealInternetAddress(false, false, false)) {
            Logger.normal(this, "Not sending handshake packets to " + addr + " for " + pn + " : Same IP address as another node");
            return false;
        }
        return true;
    }

    public void maybeBootConnection(PeerNode peerNode, FreenetInetAddress address) {
        if (this.detector.includes(address)) {
            return;
        }
        if (!address.isRealInternetAddress(false, false, false)) {
            return;
        }
        ArrayList<PeerNode> possibleMatches = this.node.getPeers().getAllConnectedByAddress(address, true);
        if (possibleMatches == null) {
            return;
        }
        for (PeerNode pn : possibleMatches) {
            if (pn == peerNode || pn.equals(peerNode) || !pn.crypto.config.oneConnectionPerAddress()) continue;
            if (pn instanceof DarknetPeerNode) {
                if (!(peerNode instanceof DarknetPeerNode)) continue;
                Logger.error(this, "Dropping peer " + pn + " because don't want connection due to others on the same IP address!");
                System.out.println("Disconnecting permanently from your friend \"" + ((DarknetPeerNode)pn).getName() + "\" because your friend \"" + ((DarknetPeerNode)peerNode).getName() + "\" is using the same IP address " + address + "!");
            }
            this.node.getPeers().disconnectAndRemove(pn, true, true, pn.isOpennet());
        }
    }

    public BlockCipher getAnonSetupCipher() {
        return this.anonSetupCipher;
    }

    public PeerNode[] getAnonSetupPeerNodes() {
        ArrayList<PeerNode> v = new ArrayList<PeerNode>();
        for (PeerNode pn : this.node.getPeers().myPeers()) {
            if (!pn.handshakeUnknownInitiator() || pn.getOutgoingMangler() != this.packetMangler) continue;
            v.add(pn);
        }
        return v.toArray(new PeerNode[v.size()]);
    }

    void setPortForwardingBroken() {
        this.socket.getAddressTracker().setBroken();
    }

    public byte[] getIdentity(int negType) {
        return this.ecdsaPubKeyHash;
    }

    public boolean definitelyPortForwarded() {
        return this.socket.getDetectedConnectivityStatus() == AddressTracker.Status.DEFINITELY_PORT_FORWARDED;
    }

    public AddressTracker.Status getDetectedConnectivityStatus() {
        return this.socket.getDetectedConnectivityStatus();
    }

    public FreenetInetAddress getBindTo() {
        return this.config.getBindTo();
    }

    public boolean wantAnonAuth() {
        return this.node.wantAnonAuth(this.isOpennet);
    }

    public boolean wantAnonAuthChangeIP() {
        return this.node.wantAnonAuthChangeIP(this.isOpennet);
    }

    public FNPPacketMangler getPacketMangler() {
        return this.packetMangler;
    }

    public boolean isOpennet() {
        return this.isOpennet;
    }

    public UdpSocketHandler getSocket() {
        return this.socket;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public byte[] getMyIdentity() {
        return this.myIdentity;
    }

    public byte[] getIdentityHash() {
        return this.identityHash;
    }

    public byte[] getIdentityHashHash() {
        return this.identityHashHash;
    }

    public byte[] getEcdsaPubKeyHash() {
        return this.ecdsaPubKeyHash;
    }

    public InsertableClientSSK getMyARK() {
        return this.myARK;
    }

    public long getMyARKNumber() {
        return this.myARKNumber;
    }

    public void setMyARKNumber(long myARKNumber) {
        this.myARKNumber = myARKNumber;
    }

    public NodeCryptoConfig getConfig() {
        return this.config;
    }

    public NodeIPPortDetector getDetector() {
        return this.detector;
    }

    static {
        Logger.registerClass(NodeCrypto.class);
    }
}

