/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.AEADVerificationFailedException;
import freenet.crypt.BlockCiphers;
import freenet.crypt.OCBBlockCipher_v149;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class AEADInputStream
extends FilterInputStream {
    private static final int MAC_SIZE_BITS = 128;
    private final AEADBlockCipher cipher;
    private boolean finished;
    private final byte[] excess;
    private int excessEnd;
    private int excessPtr;

    public AEADInputStream(InputStream is, byte[] key, BlockCipher hashCipher, BlockCipher mainCipher) throws IOException {
        super(is);
        byte[] nonce = new byte[mainCipher.getBlockSize()];
        new DataInputStream(is).readFully(nonce);
        this.cipher = new OCBBlockCipher_v149(hashCipher, mainCipher);
        KeyParameter keyParam = new KeyParameter(key);
        AEADParameters params = new AEADParameters(keyParam, 128, nonce);
        this.cipher.init(false, (CipherParameters)params);
        this.excess = new byte[mainCipher.getBlockSize()];
        this.excessEnd = 0;
        this.excessPtr = 0;
    }

    public final int getIVSize() {
        return this.cipher.getUnderlyingCipher().getBlockSize() / 8;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int length = this.read(buf, 0, 1);
        if (length > 0) {
            return Byte.toUnsignedInt(buf[0]);
        }
        return -1;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        int read;
        byte[] temp;
        int decryptedBytes;
        if (length < 0) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        if (this.excessEnd != 0 && (length = Math.min(length, this.excessEnd - this.excessPtr)) > 0) {
            System.arraycopy(this.excess, this.excessPtr, buf, offset, length);
            this.excessPtr += length;
            if (this.excessEnd == this.excessPtr) {
                this.excessEnd = 0;
                this.excessPtr = 0;
            }
            return length;
        }
        if (this.finished) {
            return -1;
        }
        do {
            if ((read = this.in.read(temp = new byte[length])) == 0) {
                return read;
            }
            if (read < 0) {
                try {
                    this.excessEnd = this.cipher.doFinal(this.excess, 0);
                }
                catch (InvalidCipherTextException e) {
                    throw new AEADVerificationFailedException();
                }
                this.finished = true;
                if (this.excessEnd > 0) {
                    return this.read(buf, offset, length);
                }
                return -1;
            }
            if (read <= 0) {
                return read;
            }
            assert (read <= length);
            int outLength = this.cipher.getUpdateOutputSize(read);
            if (outLength <= length) continue;
            byte[] outputTemp = new byte[outLength];
            int decryptedBytes2 = this.cipher.processBytes(temp, 0, read, outputTemp, 0);
            assert (decryptedBytes2 == outLength);
            System.arraycopy(outputTemp, 0, buf, offset, length);
            this.excessEnd = outLength - length;
            assert (this.excessEnd < this.excess.length);
            System.arraycopy(outputTemp, length, this.excess, 0, this.excessEnd);
            return length;
        } while ((decryptedBytes = this.cipher.processBytes(temp, 0, read, buf, offset)) <= 0);
        return decryptedBytes;
    }

    @Override
    public int available() throws IOException {
        int excess = this.excessEnd - this.excessPtr;
        if (excess > 0) {
            return excess;
        }
        if (this.finished) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = 0L;
        byte[] temp = new byte[this.excess.length];
        while (n > 0L) {
            int read;
            int excessLeft = this.excessEnd - this.excessPtr;
            if (excessLeft > 0) {
                if (n < (long)excessLeft) {
                    this.excessPtr += (int)n;
                    return n;
                }
                n -= (long)excessLeft;
                skipped += (long)excessLeft;
                this.excessEnd = 0;
                this.excessPtr = 0;
                continue;
            }
            if (n < (long)temp.length) {
                read = this.read(temp, 0, (int)n);
                if (read <= 0) {
                    return skipped;
                }
                skipped += (long)read;
                n -= (long)read;
                continue;
            }
            read = this.read(temp);
            if (read <= 0) {
                return skipped;
            }
            skipped += (long)read;
            n -= (long)read;
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.skip(Long.MAX_VALUE);
        }
        this.in.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    public static AEADInputStream createAES(InputStream is, byte[] key) throws IOException {
        BlockCipher mainCipher = BlockCiphers.aes();
        BlockCipher hashCipher = BlockCiphers.aes();
        return new AEADInputStream(is, key, hashCipher, mainCipher);
    }
}

