/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.geoip;

import freenet.clients.http.StaticToadlet;
import freenet.clients.http.geoip.Cache;
import freenet.clients.http.geoip.IPConverterParseException;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class IPConverter {
    private static final String START = "##start##";
    final int MAX_ENTRIES = 100;
    private final HashMap<Integer, Country> cache = new LinkedHashMap<Integer, Country>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Country> eldest) {
            return this.size() > 100;
        }
    };
    private SoftReference<Cache> fullCache;
    private static IPConverter instance;
    private File dbFile;
    private boolean dbFileCorrupt;
    private static final char[] base85;
    private static final int base;
    private static final byte[] base85inv;

    private IPConverter(File dbFile) {
        this.dbFile = dbFile;
    }

    public static IPConverter getInstance(File file) {
        if (instance == null) {
            instance = new IPConverter(file);
        } else if (!instance.getDBFile().equals(file)) {
            instance = new IPConverter(file);
        }
        return instance;
    }

    private Cache readRanges() {
        try {
            String line;
            RandomAccessFile raf = new RandomAccessFile(this.dbFile, "r");
            while (!(line = raf.readLine()).startsWith(START)) {
            }
            line = line.substring(START.length());
            int size = line.length() / 7;
            short[] codes = new short[size];
            int[] ips = new int[size];
            int i = 0;
            int offset = 0;
            while (i < size) {
                String code = line.substring(offset, offset + 2);
                String ipcode = line.substring(offset + 2, offset + 7);
                long ip = this.decodeBase85(ipcode.getBytes(StandardCharsets.ISO_8859_1));
                try {
                    Country country = Country.valueOf(code);
                    codes[i] = (short)country.ordinal();
                }
                catch (IllegalArgumentException e) {
                    Logger.error(this, "Country not in list: " + code);
                    codes[i] = -1;
                }
                ips[i] = (int)ip;
                ++i;
                offset += 7;
            }
            raf.close();
            return new Cache(codes, ips);
        }
        catch (FileNotFoundException e) {
            Logger.warning(this, "Database file not found!", (Throwable)e);
        }
        catch (IOException e) {
            Logger.error(this, e.getMessage());
        }
        catch (IPConverterParseException e) {
            Logger.error(this, "IP to country datbase file is corrupt: " + e, (Throwable)e);
            this.dbFileCorrupt = true;
        }
        return null;
    }

    public long ip2num(String ip) {
        String[] split = ip.split("\\.");
        if (split.length != 4) {
            throw new NumberFormatException();
        }
        long num = 0L;
        long coef = 0x1000000L;
        for (int i = 0; i < split.length; ++i) {
            long modulo = Integer.parseInt(split[i]) % 256;
            num += modulo * coef;
            coef >>= 8;
        }
        return num;
    }

    public Country locateIP(String ip) {
        long longip;
        if (ip == null) {
            return null;
        }
        try {
            longip = this.ip2num(ip);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.locateIP(longip);
    }

    public Country locateIP(byte[] ip) {
        if (ip == null) {
            return null;
        }
        if (ip.length == 16) {
            if (ip[0] == 32 && ip[1] == 2) {
                ip = Arrays.copyOfRange(ip, 2, 6);
            } else if (ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] == 0 && ip[4] == 0 && ip[5] == 0 && ip[6] == 0 && ip[7] == 0 && ip[8] == 0 && ip[9] == 0 && ip[10] == 0 && ip[11] == 0) {
                ip = Arrays.copyOfRange(ip, 12, 16);
            } else if (ip[0] == 32 && ip[1] == 1 && ip[2] == 0 && ip[3] == 0) {
                ip = Arrays.copyOfRange(ip, 12, 16);
                ip[0] = ~ip[0];
                ip[1] = ~ip[1];
                ip[2] = ~ip[2];
                ip[3] = ~ip[3];
            }
        }
        if (ip.length != 4) {
            return null;
        }
        long longip = (long)(ip[0] << 24) & 0xFF000000L | (long)(ip[1] << 16) & 0xFF0000L | (long)(ip[2] << 8) & 0xFF00L | (long)ip[3] & 0xFFL;
        return this.locateIP(longip);
    }

    private Country locateIP(long longip) {
        int mid;
        Country cached = this.cache.get((int)longip);
        if (cached != null) {
            return cached;
        }
        Cache memCache = this.getCache();
        if (memCache == null) {
            return null;
        }
        int[] ips = memCache.getIps();
        short[] codes = memCache.getCodes();
        int start = 0;
        int last = ips.length - 1;
        while ((mid = (last - start) / 2) > 0) {
            int midpos = mid + start;
            long midip = (long)ips[midpos] & 0xFFFFFFFFL;
            if (longip >= midip) {
                last = midpos;
                continue;
            }
            start = midpos;
        }
        short countryOrdinal = codes[last];
        if (countryOrdinal < 0) {
            return null;
        }
        Country country = Country.values[countryOrdinal];
        this.cache.put((int)longip, country);
        return country;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache() {
        Cache memCache = null;
        Class<IPConverter> clazz = IPConverter.class;
        synchronized (IPConverter.class) {
            if (this.fullCache != null) {
                memCache = this.fullCache.get();
            }
            if (memCache == null) {
                if (this.dbFileCorrupt) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                memCache = this.readRanges();
                this.fullCache = new SoftReference<Cache>(memCache);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return memCache;
        }
    }

    private long decodeBase85(byte[] code) throws IPConverterParseException {
        long result = 0L;
        if (code.length != 5) {
            throw new IPConverterParseException();
        }
        for (int i = 0; i < code.length; ++i) {
            if (code[i] < 32 || base85inv[code[i] - 32] < 0) {
                throw new IPConverterParseException();
            }
            result = result * (long)base + (long)base85inv[code[i] - 32];
        }
        return result;
    }

    File getDBFile() {
        return this.dbFile;
    }

    static {
        base85 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', ',', ';', '\'', '\"', '`', '<', '>', '{', '}', '[', ']', '=', '+', '-', '~', '*', '@', '#', '%', '$', '&', '!', '?'};
        base = base85.length;
        base85inv = new byte[96];
        Arrays.fill(base85inv, (byte)-1);
        for (int i = 0; i < base85.length; ++i) {
            assert (base85[i] >= ' ' && base85[i] < '\u0080');
            IPConverter.base85inv[IPConverter.base85[i] - 32] = (byte)i;
        }
    }

    public static enum Country {
        L0("localhost"),
        I0("IntraNet"),
        A1("Anonymous Proxy"),
        A2("Satellite Provider"),
        AP("AP Asia/Pacific Region"),
        AF("AFGHANISTAN"),
        AX("ALAND ISLANDS"),
        AL("ALBANIA"),
        AN("NETHERLANDS ANTILLES"),
        DZ("ALGERIA"),
        AS("AMERICAN SAMOA"),
        AD("ANDORRA"),
        AO("ANGOLA"),
        AI("ANGUILLA"),
        AQ("ANTARCTICA"),
        AG("ANTIGUA AND BARBUDA"),
        AR("ARGENTINA"),
        AM("ARMENIA"),
        AW("ARUBA"),
        AU("AUSTRALIA"),
        AT("AUSTRIA"),
        AZ("AZERBAIJAN"),
        BS("BAHAMAS"),
        BH("BAHRAIN "),
        BD("BANGLADESH "),
        BB("BARBADOS "),
        BY("BELARUS "),
        BE("BELGIUM "),
        BZ("BELIZE "),
        BJ("BENIN "),
        BM("BERMUDA "),
        BT("BHUTAN "),
        BO("BOLIVIA, PLURINATIONAL STATE OF "),
        BQ("BONAIRE, SAINT EUSTATIUS AND SABA "),
        BA("BOSNIA AND HERZEGOVINA "),
        BW("BOTSWANA "),
        BV("BOUVET ISLAND "),
        BR("BRAZIL "),
        IO("BRITISH INDIAN OCEAN TERRITORY "),
        BN("BRUNEI DARUSSALAM "),
        BG("BULGARIA "),
        BF("BURKINA FASO "),
        BI("BURUNDI "),
        KH("CAMBODIA "),
        CM("CAMEROON "),
        CA("CANADA "),
        CV("CAPE VERDE "),
        KY("CAYMAN ISLANDS "),
        CF("CENTRAL AFRICAN REPUBLIC "),
        TD("CHAD "),
        CL("CHILE "),
        CN("CHINA "),
        CX("CHRISTMAS ISLAND "),
        CC("COCOS (KEELING) ISLANDS "),
        CO("COLOMBIA "),
        KM("COMOROS "),
        CG("CONGO "),
        CD("CONGO, THE DEMOCRATIC REPUBLIC OF THE "),
        CK("COOK ISLANDS "),
        CR("COSTA RICA "),
        CI("COTE D'IVOIRE "),
        HR("CROATIA "),
        CU("CUBA "),
        CW("CURACAO "),
        CY("CYPRUS "),
        CZ("CZECH REPUBLIC "),
        DK("DENMARK "),
        DJ("DJIBOUTI "),
        DM("DOMINICA "),
        DO("DOMINICAN REPUBLIC "),
        EC("ECUADOR "),
        EG("EGYPT "),
        SV("EL SALVADOR "),
        GQ("EQUATORIAL GUINEA "),
        ER("ERITREA "),
        EE("ESTONIA "),
        ET("ETHIOPIA "),
        FK("FALKLAND ISLANDS (MALVINAS) "),
        FO("FAROE ISLANDS "),
        FJ("FIJI "),
        FI("FINLAND "),
        FR("FRANCE "),
        GF("FRENCH GUIANA "),
        PF("FRENCH POLYNESIA "),
        TF("FRENCH SOUTHERN TERRITORIES "),
        GA("GABON "),
        GM("GAMBIA "),
        GE("GEORGIA "),
        DE("GERMANY "),
        GH("GHANA "),
        GI("GIBRALTAR "),
        GR("GREECE "),
        GL("GREENLAND "),
        GD("GRENADA "),
        GP("GUADELOUPE "),
        GU("GUAM "),
        GT("GUATEMALA "),
        GG("GUERNSEY "),
        GN("GUINEA "),
        GW("GUINEA-BISSAU "),
        GY("GUYANA "),
        HT("HAITI "),
        HM("HEARD ISLAND AND MCDONALD ISLANDS "),
        VA("HOLY SEE (VATICAN CITY STATE) "),
        HN("HONDURAS "),
        HK("HONG KONG "),
        HU("HUNGARY "),
        IS("ICELAND "),
        IN("INDIA "),
        ID("INDONESIA "),
        IR("IRAN, ISLAMIC REPUBLIC OF "),
        IQ("IRAQ "),
        IE("IRELAND "),
        IM("ISLE OF MAN "),
        IL("ISRAEL "),
        IT("ITALY "),
        JM("JAMAICA "),
        JP("JAPAN "),
        JE("JERSEY "),
        JO("JORDAN "),
        KZ("KAZAKHSTAN "),
        KE("KENYA "),
        KI("KIRIBATI "),
        KP("KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF "),
        KR("KOREA, REPUBLIC OF "),
        KW("KUWAIT "),
        KG("KYRGYZSTAN "),
        LA("LAO PEOPLE'S DEMOCRATIC REPUBLIC "),
        LV("LATVIA "),
        LB("LEBANON "),
        LS("LESOTHO "),
        LR("LIBERIA "),
        LY("LIBYAN ARAB JAMAHIRIYA "),
        LI("LIECHTENSTEIN "),
        LT("LITHUANIA "),
        LU("LUXEMBOURG "),
        MO("MACAO "),
        MK("MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF "),
        MG("MADAGASCAR "),
        MW("MALAWI "),
        MY("MALAYSIA "),
        MV("MALDIVES "),
        ML("MALI "),
        MT("MALTA "),
        MH("MARSHALL ISLANDS "),
        MQ("MARTINIQUE "),
        MR("MAURITANIA "),
        MU("MAURITIUS "),
        YT("MAYOTTE "),
        MX("MEXICO "),
        FM("MICRONESIA, FEDERATED STATES OF "),
        MD("MOLDOVA, REPUBLIC OF "),
        MC("MONACO "),
        MN("MONGOLIA "),
        ME("MONTENEGRO "),
        MS("MONTSERRAT "),
        MA("MOROCCO "),
        MZ("MOZAMBIQUE "),
        MM("MYANMAR "),
        NA("NAMIBIA "),
        NR("NAURU "),
        NP("NEPAL "),
        NL("NETHERLANDS "),
        NC("NEW CALEDONIA "),
        NZ("NEW ZEALAND "),
        NI("NICARAGUA "),
        NE("NIGER "),
        NG("NIGERIA "),
        NU("NIUE "),
        NF("NORFOLK ISLAND "),
        MP("NORTHERN MARIANA ISLANDS "),
        NO("NORWAY "),
        OM("OMAN "),
        PK("PAKISTAN "),
        PW("PALAU "),
        PS("PALESTINIAN TERRITORY, OCCUPIED "),
        PA("PANAMA "),
        PG("PAPUA NEW GUINEA "),
        PY("PARAGUAY "),
        PE("PERU "),
        PH("PHILIPPINES "),
        PN("PITCAIRN "),
        PL("POLAND "),
        PT("PORTUGAL "),
        PR("PUERTO RICO "),
        QA("QATAR "),
        RE("REUNION "),
        RO("ROMANIA "),
        RU("RUSSIAN FEDERATION "),
        RW("RWANDA "),
        BL("SAINT BARTHELEMY "),
        SH("SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA "),
        KN("SAINT KITTS AND NEVIS "),
        LC("SAINT LUCIA "),
        MF("SAINT MARTIN (FRENCH PART) "),
        PM("SAINT PIERRE AND MIQUELON "),
        VC("SAINT VINCENT AND THE GRENADINES "),
        WS("SAMOA "),
        SM("SAN MARINO "),
        ST("SAO TOME AND PRINCIPE "),
        SA("SAUDI ARABIA "),
        SN("SENEGAL "),
        RS("SERBIA "),
        SC("SEYCHELLES "),
        SL("SIERRA LEONE "),
        SG("SINGAPORE "),
        SX("SINT MAARTEN (DUTCH PART) "),
        SK("SLOVAKIA "),
        SI("SLOVENIA "),
        SB("SOLOMON ISLANDS "),
        SO("SOMALIA "),
        ZA("SOUTH AFRICA "),
        GS("SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS "),
        SS("SOUTH SUDAN"),
        ES("SPAIN "),
        LK("SRI LANKA "),
        SD("SUDAN "),
        SR("SURINAME "),
        SJ("SVALBARD AND JAN MAYEN "),
        SZ("SWAZILAND "),
        SE("SWEDEN "),
        CH("SWITZERLAND "),
        SY("SYRIAN ARAB REPUBLIC "),
        TW("TAIWAN, PROVINCE OF CHINA "),
        TJ("TAJIKISTAN "),
        TZ("TANZANIA, UNITED REPUBLIC OF "),
        TH("THAILAND "),
        TL("TIMOR-LESTE "),
        TG("TOGO "),
        TK("TOKELAU "),
        TO("TONGA "),
        TT("TRINIDAD AND TOBAGO "),
        TN("TUNISIA "),
        TR("TURKEY "),
        TM("TURKMENISTAN "),
        TC("TURKS AND CAICOS ISLANDS "),
        TV("TUVALU "),
        UG("UGANDA "),
        UA("UKRAINE "),
        AE("UNITED ARAB EMIRATES "),
        GB("UNITED KINGDOM "),
        US("UNITED STATES "),
        UM("UNITED STATES MINOR OUTLYING ISLANDS "),
        UY("URUGUAY "),
        UZ("UZBEKISTAN "),
        VU("VANUATU "),
        VE("VENEZUELA, BOLIVARIAN REPUBLIC OF "),
        VN("VIET NAM "),
        VG("VIRGIN ISLANDS, BRITISH "),
        VI("VIRGIN ISLANDS, U.S. "),
        WF("WALLIS AND FUTUNA "),
        EH("WESTERN SAHARA "),
        YE("YEMEN "),
        ZM("ZAMBIA "),
        ZW("ZIMBABWE "),
        ZZ("NA"),
        EU("European Union");

        private String name;
        private boolean hasFlag;
        private boolean checkedHasFlag;
        private static final Country[] values;

        private Country(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void renderFlagIcon(HTMLNode parent) {
            String flagPath = this.getFlagIconPath();
            if (flagPath != null) {
                parent.addChild("img", new String[]{"src", "class", "title"}, new String[]{"/static/" + flagPath, "flag", this.getName()});
            }
        }

        public boolean hasFlagIcon() {
            return this.getFlagIconPath() != null;
        }

        private String flagIconPath() {
            return "icon/flags/" + this.toString().toLowerCase() + ".png";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFlagIconPath() {
            String flagPath = this.flagIconPath();
            Country country = this;
            synchronized (country) {
                if (!this.checkedHasFlag) {
                    this.hasFlag = StaticToadlet.haveFile(flagPath);
                    this.checkedHasFlag = true;
                }
                return this.hasFlag ? flagPath : null;
            }
        }

        static {
            values = Country.values();
        }
    }
}

