/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.client.async.PersistenceDisabledException;
import freenet.clients.fcp.DownloadRequestStatus;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.UploadDirRequestStatus;
import freenet.clients.fcp.UploadFileRequestStatus;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.SubConfig;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.BlockTransmitter;
import freenet.l10n.BaseL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.PeerManager;
import freenet.node.PeerNodeStatus;
import freenet.node.RequestTracker;
import freenet.node.Version;
import freenet.node.diagnostics.ThreadDiagnostics;
import freenet.node.diagnostics.threads.NodeThreadInfo;
import freenet.node.diagnostics.threads.NodeThreadSnapshot;
import freenet.node.stats.DataStoreInstanceType;
import freenet.node.stats.DataStoreStats;
import freenet.node.stats.StatsNotAvailableException;
import freenet.node.stats.StoreAccessStats;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginManager;
import freenet.support.BandwidthStatsContainer;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DiagnosticToadlet
extends Toadlet {
    private final Node node;
    private final NodeClientCore core;
    private final NodeStats stats;
    private final PeerManager peers;
    private final NumberFormat thousandPoint = NumberFormat.getInstance();
    private final FCPServer fcp;
    private final DecimalFormat fix1p4 = new DecimalFormat("0.0000");
    private final DecimalFormat fix3p1pct = new DecimalFormat("##0.0%");
    public static final String TOADLET_URL = "/diagnostic/";
    private final BaseL10n baseL10n;

    protected DiagnosticToadlet(Node n, NodeClientCore core, FCPServer fcp, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
        this.fcp = fcp;
        this.stats = this.node.getNodeStats();
        this.peers = this.node.getPeers();
        this.baseL10n = new BaseL10n("freenet/l10n/", "freenet.l10n.${lang}.properties", new File(".").getPath() + File.separator + "freenet.l10n.${lang}.override.properties", BaseL10n.LANGUAGE.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        this.node.getClientCore().getBandwidthStatsPutter().updateData(this.node);
        SubConfig nodeConfig = this.node.getConfig().get("node");
        StringBuilder textBuilder = new StringBuilder();
        DiagnosticToadlet diagnosticToadlet = this;
        synchronized (diagnosticToadlet) {
            OpennetManager om;
            textBuilder.append("Freenet Version:\n");
            textBuilder.append(this.baseL10n.getString("WelcomeToadlet.version", new String[]{"fullVersion", "build", "rev"}, new String[]{Version.publicVersion(), Integer.toString(Version.buildNumber()), Version.cvsRevision()})).append("\n");
            textBuilder.append(this.baseL10n.getString("WelcomeToadlet.extVersion", new String[]{"build", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), NodeStarter.extRevisionNumber}));
            textBuilder.append("\n");
            textBuilder.append("System Information:\n");
            Runtime rt = Runtime.getRuntime();
            long freeMemory = rt.freeMemory();
            long totalMemory = rt.totalMemory();
            long maxMemory = rt.maxMemory();
            long usedJavaMem = totalMemory - freeMemory;
            long allocatedJavaMem = totalMemory;
            long maxJavaMem = maxMemory;
            int availableCpus = rt.availableProcessors();
            int threadCount = this.stats.getActiveThreadCount();
            textBuilder.append(this.l10n("usedMemory", "memory", SizeUtil.formatSize(usedJavaMem, true))).append("\n");
            textBuilder.append(this.l10n("allocMemory", "memory", SizeUtil.formatSize(allocatedJavaMem, true))).append("\n");
            textBuilder.append(this.l10n("maxMemory", "memory", SizeUtil.formatSize(maxJavaMem, true))).append("\n");
            textBuilder.append(this.l10n("threads", new String[]{"running", "max"}, new String[]{this.thousandPoint.format(threadCount), Integer.toString(this.stats.getThreadLimit())})).append("\n");
            textBuilder.append(this.l10n("cpus", "count", Integer.toString(availableCpus))).append("\n");
            textBuilder.append(this.l10n("javaVersion", "version", System.getProperty("java.version"))).append("\n");
            textBuilder.append(this.l10n("jvmVendor", "vendor", System.getProperty("java.vendor"))).append("\n");
            textBuilder.append(this.l10n("jvmName", "name", System.getProperty("java.vm.name"))).append("\n");
            textBuilder.append(this.l10n("jvmVersion", "version", System.getProperty("java.vm.version"))).append("\n");
            textBuilder.append(this.l10n("osName", "name", System.getProperty("os.name"))).append("\n");
            textBuilder.append(this.l10n("osVersion", "version", System.getProperty("os.version"))).append("\n");
            textBuilder.append(this.l10n("osArch", "arch", System.getProperty("os.arch"))).append("\n");
            textBuilder.append("\n");
            textBuilder.append("Store Size:\n");
            Map<DataStoreInstanceType, DataStoreStats> storeStats = this.node.getDataStoreStats();
            for (Map.Entry<DataStoreInstanceType, DataStoreStats> entry : storeStats.entrySet()) {
                StoreAccessStats totalAccess;
                DataStoreInstanceType instance = entry.getKey();
                DataStoreStats stats = entry.getValue();
                StoreAccessStats sessionAccess = stats.getSessionAccessStats();
                try {
                    totalAccess = stats.getTotalAccessStats();
                }
                catch (StatsNotAvailableException e) {
                    totalAccess = null;
                }
                textBuilder.append(this.l10n(instance.store.name())).append(": (").append(this.l10n(instance.key.name())).append(")\n");
                textBuilder.append("  ").append(this.l10n("keys")).append(": ").append(this.thousandPoint.format(stats.keys())).append("\n");
                textBuilder.append("  ").append(this.l10n("capacity")).append(": ").append(this.thousandPoint.format(stats.capacity())).append("\n");
                textBuilder.append("  ").append(this.l10n("datasize")).append(": ").append(SizeUtil.formatSize(stats.dataSize())).append("\n");
                textBuilder.append("  ").append(this.l10n("utilization")).append(": ").append(this.fix3p1pct.format(stats.utilization())).append("\n");
                textBuilder.append("  ").append(this.l10n("readRequests")).append(": ").append(this.thousandPoint.format(sessionAccess.readRequests()) + (totalAccess == null ? "" : " (" + this.thousandPoint.format(totalAccess.readRequests()) + ")")).append("\n");
                textBuilder.append("  ").append(this.l10n("successfulReads")).append(": ").append(this.thousandPoint.format(sessionAccess.successfulReads()) + (totalAccess == null ? "" : " (" + this.thousandPoint.format(totalAccess.successfulReads()) + ")")).append("\n");
                try {
                    textBuilder.append(this.fix1p4.format(sessionAccess.successRate())).append("%");
                    if (totalAccess != null) {
                        try {
                            textBuilder.append(" (").append(this.fix1p4.format(totalAccess.successRate())).append("%)");
                        }
                        catch (StatsNotAvailableException e) {
                            // empty catch block
                        }
                    }
                    textBuilder.append("\n");
                }
                catch (StatsNotAvailableException e) {}
            }
            textBuilder.append("\n");
            textBuilder.append("Activity:\n");
            RequestTracker tracker = this.node.getTracker();
            int numLocalCHKInserts = tracker.getNumLocalCHKInserts();
            int numRemoteCHKInserts = tracker.getNumRemoteCHKInserts();
            int numLocalSSKInserts = tracker.getNumLocalSSKInserts();
            int numRemoteSSKInserts = tracker.getNumRemoteSSKInserts();
            int numLocalCHKRequests = tracker.getNumLocalCHKRequests();
            int numRemoteCHKRequests = tracker.getNumRemoteCHKRequests();
            int numLocalSSKRequests = tracker.getNumLocalSSKRequests();
            int numRemoteSSKRequests = tracker.getNumRemoteSSKRequests();
            int numTransferringRequests = tracker.getNumTransferringRequestSenders();
            int numTransferringRequestHandlers = tracker.getNumTransferringRequestHandlers();
            int numCHKOfferReplys = tracker.getNumCHKOfferReplies();
            int numSSKOfferReplys = tracker.getNumSSKOfferReplies();
            int numCHKRequests = numLocalCHKRequests + numRemoteCHKRequests;
            int numSSKRequests = numLocalSSKRequests + numRemoteSSKRequests;
            int numCHKInserts = numLocalCHKInserts + numRemoteCHKInserts;
            int numSSKInserts = numLocalSSKInserts + numRemoteSSKInserts;
            if (numTransferringRequests == 0 && numCHKRequests == 0 && numSSKRequests == 0 && numCHKInserts == 0 && numSSKInserts == 0 && numTransferringRequestHandlers == 0 && numCHKOfferReplys == 0 && numSSKOfferReplys == 0) {
                textBuilder.append(this.l10n("noRequests")).append("\n");
            } else {
                if (numCHKInserts > 0 || numSSKInserts > 0) {
                    textBuilder.append(this.l10n("activityInserts", new String[]{"CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numCHKInserts), Integer.toString(numSSKInserts), Integer.toString(numLocalCHKInserts) + "/" + Integer.toString(numLocalSSKInserts)}) + "\n");
                }
                if (numCHKRequests > 0 || numSSKRequests > 0) {
                    textBuilder.append(this.l10n("activityRequests", new String[]{"CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numCHKRequests), Integer.toString(numSSKRequests), Integer.toString(numLocalCHKRequests) + "/" + Integer.toString(numLocalSSKRequests)}) + "\n");
                }
                if (numTransferringRequests > 0 || numTransferringRequestHandlers > 0) {
                    textBuilder.append(this.l10n("transferringRequests", new String[]{"senders", "receivers", "turtles"}, new String[]{Integer.toString(numTransferringRequests), Integer.toString(numTransferringRequestHandlers), "0"}) + "\n");
                }
                if (numCHKOfferReplys > 0 || numSSKOfferReplys > 0) {
                    textBuilder.append(this.l10n("offerReplys", new String[]{"chk", "ssk"}, new String[]{Integer.toString(numCHKOfferReplys), Integer.toString(numSSKOfferReplys)}) + "\n");
                }
                textBuilder.append(this.l10n("runningBlockTransfers", new String[]{"sends", "receives"}, new String[]{Integer.toString(BlockTransmitter.getRunningSends()), Integer.toString(BlockReceiver.getRunningReceives())}) + "\n");
            }
            textBuilder.append("\n");
            textBuilder.append("Peer Statistics:\n");
            PeerNodeStatus[] peerNodeStatuses = this.peers.getPeerNodeStatuses(true);
            Arrays.sort(peerNodeStatuses, new Comparator<PeerNodeStatus>(){

                @Override
                public int compare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
                    int statusDifference = firstNode.getStatusValue() - secondNode.getStatusValue();
                    if (statusDifference != 0) {
                        return statusDifference;
                    }
                    return 0;
                }
            });
            int numberOfConnected = this.getPeerStatusCount(peerNodeStatuses, 1);
            int numberOfRoutingBackedOff = this.getPeerStatusCount(peerNodeStatuses, 2);
            int numberOfTooNew = this.getPeerStatusCount(peerNodeStatuses, 3);
            int numberOfTooOld = this.getPeerStatusCount(peerNodeStatuses, 4);
            int numberOfDisconnected = this.getPeerStatusCount(peerNodeStatuses, 5);
            int numberOfNeverConnected = this.getPeerStatusCount(peerNodeStatuses, 6);
            int numberOfDisabled = this.getPeerStatusCount(peerNodeStatuses, 7);
            int numberOfBursting = this.getPeerStatusCount(peerNodeStatuses, 8);
            int numberOfListening = this.getPeerStatusCount(peerNodeStatuses, 9);
            int numberOfListenOnly = this.getPeerStatusCount(peerNodeStatuses, 10);
            int numberOfSeedServers = this.getCountSeedServers(peerNodeStatuses);
            int numberOfSeedClients = this.getCountSeedClients(peerNodeStatuses);
            int numberOfRoutingDisabled = this.getPeerStatusCount(peerNodeStatuses, 14);
            int numberOfClockProblem = this.getPeerStatusCount(peerNodeStatuses, 11);
            int numberOfConnError = this.getPeerStatusCount(peerNodeStatuses, 12);
            int numberOfDisconnecting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 13);
            int numberOfNoLoadStats = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 15);
            if (numberOfConnected > 0) {
                textBuilder.append(this.l10nDark("connectedShort")).append(": ").append(numberOfConnected).append("\n");
            }
            if (numberOfRoutingBackedOff > 0) {
                textBuilder.append(this.l10nDark("backedOffShort")).append(": ").append(numberOfRoutingBackedOff).append("\n");
            }
            if (numberOfTooNew > 0) {
                textBuilder.append(this.l10nDark("tooNewShort")).append(": ").append(numberOfTooNew).append("\n");
            }
            if (numberOfTooOld > 0) {
                textBuilder.append(this.l10nDark("tooOldShort")).append(": ").append(numberOfTooOld).append("\n");
            }
            if (numberOfDisconnected > 0) {
                textBuilder.append(this.l10nDark("notConnectedShort")).append(": ").append(numberOfDisconnected).append("\n");
            }
            if (numberOfNeverConnected > 0) {
                textBuilder.append(this.l10nDark("neverConnectedShort")).append(": ").append(numberOfNeverConnected).append("\n");
            }
            if (numberOfDisabled > 0) {
                textBuilder.append(this.l10nDark("disabledShort")).append(": ").append(numberOfDisabled).append("\n");
            }
            if (numberOfBursting > 0) {
                textBuilder.append(this.l10nDark("burstingShort")).append(": ").append(numberOfBursting).append("\n");
            }
            if (numberOfListening > 0) {
                textBuilder.append(this.l10nDark("listeningShort")).append(": ").append(numberOfListening).append("\n");
            }
            if (numberOfListenOnly > 0) {
                textBuilder.append(this.l10nDark("listenOnlyShort")).append(": ").append(numberOfListenOnly).append("\n");
            }
            if (numberOfClockProblem > 0) {
                textBuilder.append(this.l10nDark("clockProblemShort")).append(": ").append(numberOfClockProblem).append("\n");
            }
            if (numberOfConnError > 0) {
                textBuilder.append(this.l10nDark("connErrorShort")).append(": ").append(numberOfConnError).append("\n");
            }
            if (numberOfDisconnecting > 0) {
                textBuilder.append(this.l10nDark("disconnectingShort")).append(": ").append(numberOfDisconnecting).append("\n");
            }
            if (numberOfSeedServers > 0) {
                textBuilder.append(this.l10nDark("seedServersShort")).append(": ").append(numberOfSeedServers).append("\n");
            }
            if (numberOfSeedClients > 0) {
                textBuilder.append(this.l10nDark("seedClientsShort")).append(": ").append(numberOfSeedClients).append("\n");
            }
            if (numberOfRoutingDisabled > 0) {
                textBuilder.append(this.l10nDark("routingDisabledShort")).append(": ").append(numberOfRoutingDisabled).append("\n");
            }
            if (numberOfNoLoadStats > 0) {
                textBuilder.append(this.l10nDark("noLoadStatsShort")).append(": ").append(numberOfNoLoadStats).append("\n");
            }
            if ((om = this.node.getOpennet()) != null) {
                textBuilder.append(this.l10n("maxTotalPeers") + ": " + om.getNumberOfConnectedPeersToAimIncludingDarknet()).append("\n");
                textBuilder.append(this.l10n("maxOpennetPeers") + ": " + om.getNumberOfConnectedPeersToAim()).append("\n");
            }
            textBuilder.append("\n");
            textBuilder.append("Bandwidth:\n");
            long[] total = this.node.getCollector().getTotalIO();
            if (total[0] == 0L || total[1] == 0L) {
                textBuilder.append("bandwidth error\n");
            } else {
                long now = System.currentTimeMillis();
                long nodeUptimeSeconds = (now - this.node.getStartupTime()) / 1000L;
                long total_output_rate = total[0] / nodeUptimeSeconds;
                long total_input_rate = total[1] / nodeUptimeSeconds;
                long totalPayload = this.node.getTotalPayloadSent();
                long total_payload_rate = totalPayload / nodeUptimeSeconds;
                if (this.node.getClientCore() == null) {
                    throw new NullPointerException();
                }
                BandwidthStatsContainer stats = this.node.getClientCore().getBandwidthStatsPutter().getLatestBWData();
                if (stats == null) {
                    throw new NullPointerException();
                }
                long overall_total_out = stats.totalBytesOut;
                long overall_total_in = stats.totalBytesIn;
                int percent = (int)(100L * totalPayload / total[0]);
                long[] rate = this.node.getNodeStats().getNodeIOStats();
                long delta = (rate[5] - rate[2]) / 1000L;
                if (delta > 0L) {
                    long output_rate = (rate[3] - rate[0]) / delta;
                    long input_rate = (rate[4] - rate[1]) / delta;
                    int outputBandwidthLimit = nodeConfig.getInt("outputBandwidthLimit");
                    int inputBandwidthLimit = nodeConfig.getInt("inputBandwidthLimit");
                    if (inputBandwidthLimit == -1) {
                        inputBandwidthLimit = outputBandwidthLimit * 4;
                    }
                    textBuilder.append(this.l10n("inputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(input_rate, true), SizeUtil.formatSize(inputBandwidthLimit, true)})).append("\n");
                    textBuilder.append(this.l10n("outputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(output_rate, true), SizeUtil.formatSize(outputBandwidthLimit, true)})).append("\n");
                }
                textBuilder.append(this.l10n("totalInputSession", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[1], true), SizeUtil.formatSize(total_input_rate, true)})).append("\n");
                textBuilder.append(this.l10n("totalOutputSession", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[0], true), SizeUtil.formatSize(total_output_rate, true)})).append("\n");
                textBuilder.append(this.l10n("payloadOutput", new String[]{"total", "rate", "percent"}, new String[]{SizeUtil.formatSize(totalPayload, true), SizeUtil.formatSize(total_payload_rate, true), Integer.toString(percent)})).append("\n");
                textBuilder.append(this.l10n("totalInput", new String[]{"total"}, new String[]{SizeUtil.formatSize(overall_total_in, true)})).append("\n");
                textBuilder.append(this.l10n("totalOutput", new String[]{"total"}, new String[]{SizeUtil.formatSize(overall_total_out, true)})).append("\n");
                long totalBytesSentCHKRequests = this.node.getNodeStats().getCHKRequestTotalBytesSent();
                long totalBytesSentSSKRequests = this.node.getNodeStats().getSSKRequestTotalBytesSent();
                long totalBytesSentCHKInserts = this.node.getNodeStats().getCHKInsertTotalBytesSent();
                long totalBytesSentSSKInserts = this.node.getNodeStats().getSSKInsertTotalBytesSent();
                long totalBytesSentOfferedKeys = this.node.getNodeStats().getOfferedKeysTotalBytesSent();
                long totalBytesSendOffers = this.node.getNodeStats().getOffersSentBytesSent();
                long totalBytesSentSwapOutput = this.node.getNodeStats().getSwappingTotalBytesSent();
                long totalBytesSentAuth = this.node.getNodeStats().getTotalAuthBytesSent();
                long totalBytesSentAckOnly = this.node.getNodeStats().getNotificationOnlyPacketsSentBytes();
                long totalBytesSentResends = this.node.getNodeStats().getResendBytesSent();
                long totalBytesSentUOM = this.node.getNodeStats().getUOMBytesSent();
                long totalBytesSentAnnounce = this.node.getNodeStats().getAnnounceBytesSent();
                long totalBytesSentAnnouncePayload = this.node.getNodeStats().getAnnounceBytesPayloadSent();
                long totalBytesSentRoutingStatus = this.node.getNodeStats().getRoutingStatusBytes();
                long totalBytesSentNetworkColoring = this.node.getNodeStats().getNetworkColoringSentBytes();
                long totalBytesSentPing = this.node.getNodeStats().getPingSentBytes();
                long totalBytesSentProbeRequest = this.node.getNodeStats().getProbeRequestSentBytes();
                long totalBytesSentRouted = this.node.getNodeStats().getRoutedMessageSentBytes();
                long totalBytesSentDisconn = this.node.getNodeStats().getDisconnBytesSent();
                long totalBytesSentInitial = this.node.getNodeStats().getInitialMessagesBytesSent();
                long totalBytesSentChangedIP = this.node.getNodeStats().getChangedIPBytesSent();
                long totalBytesSentNodeToNode = this.node.getNodeStats().getNodeToNodeBytesSent();
                long totalBytesSentAllocationNotices = this.node.getNodeStats().getAllocationNoticesBytesSent();
                long totalBytesSentFOAF = this.node.getNodeStats().getFOAFBytesSent();
                long totalBytesSentRemaining = total[0] - (totalPayload + totalBytesSentCHKRequests + totalBytesSentSSKRequests + totalBytesSentCHKInserts + totalBytesSentSSKInserts + totalBytesSentOfferedKeys + totalBytesSendOffers + totalBytesSentSwapOutput + totalBytesSentAuth + totalBytesSentAckOnly + totalBytesSentResends + totalBytesSentUOM + totalBytesSentAnnounce + totalBytesSentRoutingStatus + totalBytesSentNetworkColoring + totalBytesSentPing + totalBytesSentProbeRequest + totalBytesSentRouted + totalBytesSentDisconn + totalBytesSentInitial + totalBytesSentChangedIP + totalBytesSentNodeToNode + totalBytesSentAllocationNotices + totalBytesSentFOAF);
                textBuilder.append(this.l10n("requestOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKRequests, true), SizeUtil.formatSize(totalBytesSentSSKRequests, true)})).append("\n");
                textBuilder.append(this.l10n("insertOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKInserts, true), SizeUtil.formatSize(totalBytesSentSSKInserts, true)})).append("\n");
                textBuilder.append(this.l10n("offeredKeyOutput", new String[]{"total", "offered"}, new String[]{SizeUtil.formatSize(totalBytesSentOfferedKeys, true), SizeUtil.formatSize(totalBytesSendOffers, true)})).append("\n");
                textBuilder.append(this.l10n("swapOutput", "total", SizeUtil.formatSize(totalBytesSentSwapOutput, true))).append("\n");
                textBuilder.append(this.l10n("authBytes", "total", SizeUtil.formatSize(totalBytesSentAuth, true))).append("\n");
                textBuilder.append(this.l10n("ackOnlyBytes", "total", SizeUtil.formatSize(totalBytesSentAckOnly, true))).append("\n");
                textBuilder.append(this.l10n("resendBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentResends, true), Long.toString(100L * totalBytesSentResends / Math.max(1L, total[0]))})).append("\n");
                textBuilder.append(this.l10n("uomBytes", "total", SizeUtil.formatSize(totalBytesSentUOM, true))).append("\n");
                textBuilder.append(this.l10n("announceBytes", new String[]{"total", "payload"}, new String[]{SizeUtil.formatSize(totalBytesSentAnnounce, true), SizeUtil.formatSize(totalBytesSentAnnouncePayload, true)})).append("\n");
                textBuilder.append(this.l10n("adminBytes", new String[]{"routingStatus", "disconn", "initial", "changedIP"}, new String[]{SizeUtil.formatSize(totalBytesSentRoutingStatus, true), SizeUtil.formatSize(totalBytesSentDisconn, true), SizeUtil.formatSize(totalBytesSentInitial, true), SizeUtil.formatSize(totalBytesSentChangedIP, true)})).append("\n");
                textBuilder.append(this.l10n("debuggingBytes", new String[]{"netColoring", "ping", "probe", "routed"}, new String[]{SizeUtil.formatSize(totalBytesSentNetworkColoring, true), SizeUtil.formatSize(totalBytesSentPing, true), SizeUtil.formatSize(totalBytesSentProbeRequest, true), SizeUtil.formatSize(totalBytesSentRouted, true)})).append("\n");
                textBuilder.append(this.l10n("nodeToNodeBytes", "total", SizeUtil.formatSize(totalBytesSentNodeToNode, true))).append("\n");
                textBuilder.append(this.l10n("loadAllocationNoticesBytes", "total", SizeUtil.formatSize(totalBytesSentAllocationNotices, true))).append("\n");
                textBuilder.append(this.l10n("foafBytes", "total", SizeUtil.formatSize(totalBytesSentFOAF, true))).append("\n");
                textBuilder.append(this.l10n("unaccountedBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentRemaining, true), Integer.toString((int)(totalBytesSentRemaining * 100L / total[0]))})).append("\n");
                double sentOverheadPerSecond = this.node.getNodeStats().getSentOverheadPerSecond();
                textBuilder.append(this.l10n("totalOverhead", new String[]{"rate", "percent"}, new String[]{SizeUtil.formatSize((long)sentOverheadPerSecond), Integer.toString((int)(100.0 * sentOverheadPerSecond / (double)total_output_rate))})).append("\n");
            }
            textBuilder.append("\n");
            textBuilder.append("Plugins:\n");
            PluginManager pm = this.node.getPluginManager();
            if (!pm.getPlugins().isEmpty()) {
                textBuilder.append(this.baseL10n.getString("PluginToadlet.pluginListTitle")).append("\n");
                for (PluginInfoWrapper pi : pm.getPlugins()) {
                    long ver = pi.getPluginLongVersion();
                    if (ver != -1L) {
                        textBuilder.append(pi.getFilename()).append(" (").append(pi.getPluginClassName()).append(") - ").append(pi.getPluginVersion() + " (" + ver + ")").append(" ").append(pi.getThreadName()).append("\n");
                        continue;
                    }
                    textBuilder.append(pi.getFilename()).append(" (").append(pi.getPluginClassName()).append(") - ").append(pi.getPluginVersion()).append(" ").append(pi.getThreadName()).append("\n");
                }
            }
            textBuilder.append("\n");
            textBuilder.append("Queue:\n");
            try {
                RequestStatus[] reqs = this.fcp.getGlobalRequests();
                if (reqs.length < 1) {
                    textBuilder.append(this.baseL10n.getString("QueueToadlet.globalQueueIsEmpty")).append("\n");
                } else {
                    long totalQueuedDownload = 0L;
                    long totalQueuedUpload = 0L;
                    for (RequestStatus req : reqs) {
                        if (req instanceof DownloadRequestStatus) {
                            ++totalQueuedDownload;
                            continue;
                        }
                        if (req instanceof UploadFileRequestStatus) {
                            ++totalQueuedUpload;
                            continue;
                        }
                        if (!(req instanceof UploadDirRequestStatus)) continue;
                        ++totalQueuedUpload;
                    }
                    textBuilder.append("Downloads Queued: ").append(totalQueuedDownload).append(" (").append(totalQueuedDownload).append(")\n");
                    textBuilder.append("Uploads Queued: ").append(totalQueuedUpload).append(" (").append(totalQueuedUpload).append(")\n");
                }
            }
            catch (PersistenceDisabledException e) {
                textBuilder.append("DatabaseDisabledException\n");
            }
            textBuilder.append("\n");
            if (this.node.isNodeDiagnosticsEnabled()) {
                textBuilder.append((CharSequence)this.threadsStats());
                textBuilder.append("\n");
            }
        }
        this.writeTextReply(ctx, 200, "OK", textBuilder.toString());
    }

    private StringBuilder threadsStats() {
        StringBuilder sb = new StringBuilder();
        ThreadDiagnostics threadDiagnostics = this.node.getNodeDiagnostics().getThreadDiagnostics();
        NodeThreadSnapshot threadSnapshot = threadDiagnostics.getThreadSnapshot();
        double wallTime = TimeUnit.MILLISECONDS.toNanos(threadSnapshot.getInterval());
        List<NodeThreadInfo> threads = threadSnapshot.getThreads();
        threads.sort(Comparator.comparing(NodeThreadInfo::getCpuTime).reversed());
        sb.append(String.format("Threads (%d):%n", threads.size()));
        sb.append(String.format("%10s %15s %-90s %5s %10s %-20s %-5s%n", "Thread ID", "Job ID", "Name", "Prio.", "Group", "Status", "% CPU"));
        for (NodeThreadInfo thread : threads) {
            String line = String.format("%10s %15s %-90s %5s %10s %-20s %.2f%n", thread.getId(), thread.getJobId(), thread.getName().substring(0, Math.min(90, thread.getName().length())), thread.getPrio(), thread.getGroupName().substring(0, Math.min(10, thread.getGroupName().length())), thread.getState(), (double)thread.getCpuTime() / wallTime * 100.0);
            sb.append(line);
        }
        return sb;
    }

    private int getPeerStatusCount(PeerNodeStatus[] peerNodeStatuses, int status) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.recordStatus() || peerNodeStatus.getStatusValue() != status) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedServers(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.isSeedServer()) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedClients(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.isSeedClient()) continue;
            ++count;
        }
        return count;
    }

    private String l10n(String key) {
        return this.baseL10n.getString("StatisticsToadlet." + key);
    }

    private String l10nDark(String key) {
        return this.baseL10n.getString("DarknetConnectionsToadlet." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return this.baseL10n.getString("StatisticsToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return this.baseL10n.getString("StatisticsToadlet." + key, patterns, values);
    }

    @Override
    public String path() {
        return TOADLET_URL;
    }
}

