/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.AddPeer;
import freenet.clients.fcp.ClientGetMessage;
import freenet.clients.fcp.ClientHelloMessage;
import freenet.clients.fcp.ClientPutComplexDirMessage;
import freenet.clients.fcp.ClientPutDiskDirMessage;
import freenet.clients.fcp.ClientPutMessage;
import freenet.clients.fcp.DisconnectMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPPluginClientMessage;
import freenet.clients.fcp.FilterMessage;
import freenet.clients.fcp.GenerateSSKMessage;
import freenet.clients.fcp.GetConfig;
import freenet.clients.fcp.GetNode;
import freenet.clients.fcp.GetPluginInfo;
import freenet.clients.fcp.GetRequestStatusMessage;
import freenet.clients.fcp.ListPeerMessage;
import freenet.clients.fcp.ListPeerNotesMessage;
import freenet.clients.fcp.ListPeersMessage;
import freenet.clients.fcp.ListPersistentRequestsMessage;
import freenet.clients.fcp.LoadPlugin;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.ModifyConfig;
import freenet.clients.fcp.ModifyPeer;
import freenet.clients.fcp.ModifyPeerNote;
import freenet.clients.fcp.ModifyPersistentRequest;
import freenet.clients.fcp.ProbeRequest;
import freenet.clients.fcp.ReloadPlugin;
import freenet.clients.fcp.RemovePeer;
import freenet.clients.fcp.RemovePersistentRequest;
import freenet.clients.fcp.RemovePlugin;
import freenet.clients.fcp.SendBookmarkMessage;
import freenet.clients.fcp.SendTextMessage;
import freenet.clients.fcp.SendURIMessage;
import freenet.clients.fcp.ShutdownMessage;
import freenet.clients.fcp.SubscribeUSKMessage;
import freenet.clients.fcp.TestDDARequestMessage;
import freenet.clients.fcp.TestDDAResponseMessage;
import freenet.clients.fcp.UnsubscribeUSKMessage;
import freenet.clients.fcp.WatchFeedsMessage;
import freenet.clients.fcp.WatchGlobal;
import freenet.node.Node;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.io.PersistentTempBucketFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public abstract class FCPMessage {
    public static final String BUILD = "Build";
    public static final String CODE = "Code";
    public static final String HTL = "HopsToLive";
    public static final String IDENTIFIER = "Identifier";
    public static final String LINK_LENGTHS = "LinkLengths";
    public static final String LOCAL = "Local";
    public static final String LOCATION = "Location";
    public static final String OUTPUT_BANDWIDTH = "OutputBandwidth";
    public static final String PROBE_IDENTIFIER = "ProbeIdentifier";
    public static final String STORE_SIZE = "StoreSize";
    public static final String TYPE = "Type";
    public static final String UPTIME_PERCENT = "UptimePercent";
    public static final String BULK_CHK_REQUEST_REJECTS = "Rejects.Bulk.Request.CHK";
    public static final String BULK_SSK_REQUEST_REJECTS = "Rejects.Bulk.Request.SSK";
    public static final String BULK_CHK_INSERT_REJECTS = "Rejects.Bulk.Insert.CHK";
    public static final String BULK_SSK_INSERT_REJECTS = "Rejects.Bulk.Insert.SSK";
    public static final String OUTPUT_BANDWIDTH_CLASS = "OutputBandwidthClass";
    public static final String OVERALL_BULK_OUTPUT_CAPACITY_USAGE = "OverallBulkOutputCapacityUsage";
    private static volatile boolean logDEBUG;

    public void send(OutputStream os) throws IOException {
        SimpleFieldSet sfs = this.getFieldSet();
        if (sfs == null) {
            Logger.warning(this, "Not sending message " + this);
            return;
        }
        sfs.setEndMarker(this.getEndString());
        String msg = sfs.toString();
        os.write((this.getName() + '\n').getBytes(StandardCharsets.UTF_8));
        os.write(msg.getBytes(StandardCharsets.UTF_8));
        if (logDEBUG) {
            Logger.debug(this, "Outgoing FCP message:\n" + this.getName() + '\n' + sfs.toString());
            Logger.debug(this, "Being handled by " + this);
        }
    }

    String getEndString() {
        return "EndMessage";
    }

    public abstract SimpleFieldSet getFieldSet();

    public abstract String getName();

    public static FCPMessage create(String name, SimpleFieldSet fs, BucketFactory bfTemp, PersistentTempBucketFactory bfPersistent) throws MessageInvalidException {
        if (name.equals("AddPeer")) {
            return new AddPeer(fs);
        }
        if (name.equals("ClientGet")) {
            return new ClientGetMessage(fs);
        }
        if (name.equals("ClientHello")) {
            return new ClientHelloMessage(fs);
        }
        if (name.equals("ClientPutComplexDir")) {
            return new ClientPutComplexDirMessage(fs, bfTemp, bfPersistent);
        }
        if (name.equals("ClientPutDiskDir")) {
            return new ClientPutDiskDirMessage(fs);
        }
        if (name.equals("ClientPut")) {
            return new ClientPutMessage(fs);
        }
        if (name.equals("SendBookmark")) {
            return new SendBookmarkMessage(fs);
        }
        if (name.equals("SendURI")) {
            return new SendURIMessage(fs);
        }
        if (name.equals("SendText")) {
            return new SendTextMessage(fs);
        }
        if (name.equals("Disconnect")) {
            return new DisconnectMessage(fs);
        }
        if (name.equals("FCPPluginMessage")) {
            return new FCPPluginClientMessage(fs);
        }
        if (name.equals("GenerateSSK")) {
            return new GenerateSSKMessage(fs);
        }
        if (name.equals("GetConfig")) {
            return new GetConfig(fs);
        }
        if (name.equals("GetNode")) {
            return new GetNode(fs);
        }
        if (name.equals("GetPluginInfo")) {
            return new GetPluginInfo(fs);
        }
        if (name.equals("GetRequestStatus")) {
            return new GetRequestStatusMessage(fs);
        }
        if (name.equals("ListPeer")) {
            return new ListPeerMessage(fs);
        }
        if (name.equals("ListPeers")) {
            return new ListPeersMessage(fs);
        }
        if (name.equals("ListPeerNotes")) {
            return new ListPeerNotesMessage(fs);
        }
        if (name.equals("ListPersistentRequests")) {
            return new ListPersistentRequestsMessage(fs);
        }
        if (name.equals("LoadPlugin")) {
            return new LoadPlugin(fs);
        }
        if (name.equals("ModifyConfig")) {
            return new ModifyConfig(fs);
        }
        if (name.equals("ModifyPeer")) {
            return new ModifyPeer(fs);
        }
        if (name.equals("ModifyPeerNote")) {
            return new ModifyPeerNote(fs);
        }
        if (name.equals("ModifyPersistentRequest")) {
            return new ModifyPersistentRequest(fs);
        }
        if (name.equals("ReloadPlugin")) {
            return new ReloadPlugin(fs);
        }
        if (name.equals("RemovePeer")) {
            return new RemovePeer(fs);
        }
        if (name.equals("RemoveRequest") || name.equals("RemovePersistentRequest")) {
            return new RemovePersistentRequest(fs);
        }
        if (name.equals("RemovePlugin")) {
            return new RemovePlugin(fs);
        }
        if (name.equals("Shutdown")) {
            return new ShutdownMessage();
        }
        if (name.equals("WatchFeeds")) {
            return new WatchFeedsMessage(fs);
        }
        if (name.equals("SubscribeUSK")) {
            return new SubscribeUSKMessage(fs);
        }
        if (name.equals("WatchFeeds")) {
            return new WatchFeedsMessage(fs);
        }
        if (name.equals("UnsubscribeUSK")) {
            return new UnsubscribeUSKMessage(fs);
        }
        if (name.equals("TestDDARequest")) {
            return new TestDDARequestMessage(fs);
        }
        if (name.equals("TestDDAResponse")) {
            return new TestDDAResponseMessage(fs);
        }
        if (name.equals("WatchGlobal")) {
            return new WatchGlobal(fs);
        }
        if (name.equals("ProbeRequest")) {
            return new ProbeRequest(fs);
        }
        if (name.equals("Filter")) {
            return new FilterMessage(fs, bfTemp);
        }
        if (name.equals("Void")) {
            return null;
        }
        throw new MessageInvalidException(7, "Unknown message name " + name, null, false);
    }

    public static FCPMessage create(String name, SimpleFieldSet fs) throws MessageInvalidException {
        return FCPMessage.create(name, fs, null, null);
    }

    public static FCPMessage withListRequestIdentifier(final FCPMessage fcpMessage, final String listRequestIdentifier) {
        if (listRequestIdentifier == null || fcpMessage == null) {
            return fcpMessage;
        }
        return new FCPMessage(){

            @Override
            public void send(OutputStream os) throws IOException {
                fcpMessage.send(os);
            }

            @Override
            String getEndString() {
                return fcpMessage.getEndString();
            }

            @Override
            public SimpleFieldSet getFieldSet() {
                SimpleFieldSet fieldSet = fcpMessage.getFieldSet();
                fieldSet.putOverwrite("ListRequestIdentifier", listRequestIdentifier);
                return fieldSet;
            }

            @Override
            public String getName() {
                return fcpMessage.getName();
            }

            @Override
            public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
                fcpMessage.run(handler, node);
            }
        };
    }

    public abstract void run(FCPConnectionHandler var1, Node var2) throws MessageInvalidException;

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

