/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveManager;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientLayerPersister;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.DownloadCache;
import freenet.client.async.HealingQueue;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.USKManager;
import freenet.client.events.SimpleEventProducer;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.clients.fcp.PersistentRequestRoot;
import freenet.config.Config;
import freenet.crypt.MasterSecret;
import freenet.crypt.RandomSource;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarterGroup;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.DummyJobRunner;
import freenet.support.Executor;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.Ticker;
import freenet.support.api.BucketFactory;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.compress.RealCompressor;
import freenet.support.io.FileRandomAccessBufferFactory;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.NativeThread;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempBucketFactory;
import freenet.support.io.TempBucketFactory;
import java.util.Random;

public class ClientContext {
    private transient ClientRequestScheduler sskFetchSchedulerBulk;
    private transient ClientRequestScheduler chkFetchSchedulerBulk;
    private transient ClientRequestScheduler sskInsertSchedulerBulk;
    private transient ClientRequestScheduler chkInsertSchedulerBulk;
    private transient ClientRequestScheduler sskFetchSchedulerRT;
    private transient ClientRequestScheduler chkFetchSchedulerRT;
    private transient ClientRequestScheduler sskInsertSchedulerRT;
    private transient ClientRequestScheduler chkInsertSchedulerRT;
    private transient UserAlertManager alerts;
    @Deprecated
    public final transient Executor mainExecutor;
    public final transient PersistentJobRunner jobRunner;
    public final transient RandomSource random;
    public final transient ArchiveManager archiveManager;
    public final transient PersistentTempBucketFactory persistentBucketFactory;
    public transient PersistentFileTracker persistentFileTracker;
    public final transient TempBucketFactory tempBucketFactory;
    public final transient LockableRandomAccessBufferFactory tempRAFFactory;
    public final transient LockableRandomAccessBufferFactory persistentRAFFactory;
    public final transient HealingQueue healingQueue;
    public final transient USKManager uskManager;
    public final transient Random fastWeakRandom;
    public final transient long bootID;
    public final transient Ticker ticker;
    public final transient FilenameGenerator fg;
    public final transient FilenameGenerator persistentFG;
    public final transient RealCompressor rc;
    public final transient DatastoreChecker checker;
    public transient DownloadCache downloadCache;
    public final transient MemoryLimitedJobRunner memoryLimitedJobRunner;
    public final transient PersistentRequestRoot persistentRoot;
    private transient FetchContext defaultPersistentFetchContext;
    private transient InsertContext defaultPersistentInsertContext;
    public final transient MasterSecret cryptoSecretTransient;
    private transient MasterSecret cryptoSecretPersistent;
    private transient FileRandomAccessBufferFactory fileRAFTransient;
    private transient FileRandomAccessBufferFactory fileRAFPersistent;
    public final transient LinkFilterExceptionProvider linkFilterExceptionProvider;
    public PersistentJobRunner dummyJobRunner;
    private final transient Config config;

    public ClientContext(long bootID, ClientLayerPersister jobRunner, Executor mainExecutor, ArchiveManager archiveManager, PersistentTempBucketFactory ptbf, TempBucketFactory tbf, PersistentFileTracker tracker, HealingQueue hq, USKManager uskManager, RandomSource strongRandom, Random fastWeakRandom, Ticker ticker, MemoryLimitedJobRunner memoryLimitedJobRunner, FilenameGenerator fg, FilenameGenerator persistentFG, LockableRandomAccessBufferFactory rafFactory, LockableRandomAccessBufferFactory persistentRAFFactory, FileRandomAccessBufferFactory fileRAFTransient, FileRandomAccessBufferFactory fileRAFPersistent, RealCompressor rc, DatastoreChecker checker, PersistentRequestRoot persistentRoot, MasterSecret cryptoSecretTransient, LinkFilterExceptionProvider linkFilterExceptionProvider, FetchContext defaultPersistentFetchContext, InsertContext defaultPersistentInsertContext, Config config) {
        this.bootID = bootID;
        this.jobRunner = jobRunner;
        this.mainExecutor = mainExecutor;
        this.random = strongRandom;
        this.archiveManager = archiveManager;
        this.persistentBucketFactory = ptbf;
        this.persistentFileTracker = ptbf;
        this.tempBucketFactory = tbf;
        this.healingQueue = hq;
        this.uskManager = uskManager;
        this.fastWeakRandom = fastWeakRandom;
        this.ticker = ticker;
        this.fg = fg;
        this.persistentFG = persistentFG;
        this.persistentRAFFactory = persistentRAFFactory;
        this.fileRAFPersistent = fileRAFPersistent;
        this.fileRAFTransient = fileRAFTransient;
        this.rc = rc;
        this.checker = checker;
        this.linkFilterExceptionProvider = linkFilterExceptionProvider;
        this.memoryLimitedJobRunner = memoryLimitedJobRunner;
        this.tempRAFFactory = rafFactory;
        this.persistentRoot = persistentRoot;
        this.dummyJobRunner = new DummyJobRunner(mainExecutor, this);
        this.defaultPersistentFetchContext = defaultPersistentFetchContext;
        this.defaultPersistentInsertContext = defaultPersistentInsertContext;
        this.cryptoSecretTransient = cryptoSecretTransient;
        this.config = config;
    }

    public void init(RequestStarterGroup starters, UserAlertManager alerts) {
        this.sskFetchSchedulerBulk = starters.sskFetchSchedulerBulk;
        this.chkFetchSchedulerBulk = starters.chkFetchSchedulerBulk;
        this.sskInsertSchedulerBulk = starters.sskPutSchedulerBulk;
        this.chkInsertSchedulerBulk = starters.chkPutSchedulerBulk;
        this.sskFetchSchedulerRT = starters.sskFetchSchedulerRT;
        this.chkFetchSchedulerRT = starters.chkFetchSchedulerRT;
        this.sskInsertSchedulerRT = starters.sskPutSchedulerRT;
        this.chkInsertSchedulerRT = starters.chkPutSchedulerRT;
        this.alerts = alerts;
    }

    public synchronized void setPersistentMasterSecret(MasterSecret secret) {
        this.cryptoSecretPersistent = secret;
    }

    public synchronized MasterSecret getPersistentMasterSecret() {
        return this.cryptoSecretPersistent;
    }

    public ClientRequestScheduler getSskFetchScheduler(boolean realTime) {
        return realTime ? this.sskFetchSchedulerRT : this.sskFetchSchedulerBulk;
    }

    public ClientRequestScheduler getChkFetchScheduler(boolean realTime) {
        return realTime ? this.chkFetchSchedulerRT : this.chkFetchSchedulerBulk;
    }

    public ClientRequestScheduler getSskInsertScheduler(boolean realTime) {
        return realTime ? this.sskInsertSchedulerRT : this.sskInsertSchedulerBulk;
    }

    public ClientRequestScheduler getChkInsertScheduler(boolean realTime) {
        return realTime ? this.chkInsertSchedulerRT : this.chkInsertSchedulerBulk;
    }

    public void start(final ClientPutter inserter) throws InsertException, PersistenceDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    try {
                        inserter.start(false, context);
                    }
                    catch (InsertException e) {
                        inserter.client.onFailure(e, inserter);
                    }
                    return true;
                }
            }, NativeThread.NORM_PRIORITY);
        } else {
            inserter.start(false, this);
        }
    }

    public void start(final ClientGetter getter) throws FetchException, PersistenceDisabledException {
        if (getter.persistent()) {
            this.jobRunner.queue(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    try {
                        getter.start(context);
                    }
                    catch (FetchException e) {
                        getter.clientCallback.onFailure(e, getter);
                    }
                    return true;
                }
            }, NativeThread.NORM_PRIORITY);
        } else {
            getter.start(this);
        }
    }

    public void start(final BaseManifestPutter inserter) throws InsertException, PersistenceDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    try {
                        inserter.start(context);
                    }
                    catch (InsertException e) {
                        inserter.cb.onFailure(e, inserter);
                    }
                    return true;
                }
            }, NativeThread.NORM_PRIORITY);
        } else {
            inserter.start(this);
        }
    }

    public BucketFactory getBucketFactory(boolean persistent) {
        if (persistent) {
            return this.persistentBucketFactory;
        }
        return this.tempBucketFactory;
    }

    public RequestScheduler getFetchScheduler(boolean ssk, boolean realTime) {
        if (ssk) {
            return realTime ? this.sskFetchSchedulerRT : this.sskFetchSchedulerBulk;
        }
        return realTime ? this.chkFetchSchedulerRT : this.chkFetchSchedulerBulk;
    }

    public void postUserAlert(final UserAlert alert) {
        if (this.alerts == null) {
            this.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    ClientContext.this.alerts.register(alert);
                }
            }, "Post alert", 0L, false, false);
        } else {
            this.alerts.register(alert);
        }
    }

    public void setDownloadCache(DownloadCache cache) {
        this.downloadCache = cache;
    }

    public FetchContext getDefaultPersistentFetchContext() {
        return new FetchContext(this.defaultPersistentFetchContext, 0);
    }

    public InsertContext getDefaultPersistentInsertContext() {
        return new InsertContext(this.defaultPersistentInsertContext, new SimpleEventProducer());
    }

    public PersistentJobRunner getJobRunner(boolean persistent) {
        return persistent ? this.jobRunner : this.dummyJobRunner;
    }

    public FileRandomAccessBufferFactory getFileRandomAccessBufferFactory(boolean persistent) {
        return persistent ? this.fileRAFPersistent : this.fileRAFTransient;
    }

    public LockableRandomAccessBufferFactory getRandomAccessBufferFactory(boolean persistent) {
        return persistent ? this.persistentRAFFactory : this.tempBucketFactory;
    }

    public Config getConfig() {
        return this.config;
    }

    public Executor getMainExecutor() {
        return this.mainExecutor;
    }
}

