/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.FetchException;
import freenet.client.InsertException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FailureCodeTracker
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public final boolean insert;
    private int total;
    private HashMap<Integer, Integer> map;
    private int MAGIC = -1241142776;
    private int VERSION = 1;

    public FailureCodeTracker(boolean insert) {
        this.insert = insert;
    }

    public FailureCodeTracker(boolean isInsert, SimpleFieldSet fs) {
        this.insert = isInsert;
        Iterator<String> i = fs.directSubsetNameIterator();
        while (i.hasNext()) {
            String name = i.next();
            SimpleFieldSet f = fs.subset(name);
            int num = Integer.parseInt(name);
            int count = Integer.parseInt(f.get("Count"));
            if (count < 0) {
                throw new IllegalArgumentException("Count < 0");
            }
            this.map.put(num, count);
            this.total += count;
        }
    }

    protected FailureCodeTracker() {
        this.insert = false;
    }

    public void inc(FetchException.FetchExceptionMode k) {
        if (this.insert) {
            throw new IllegalStateException();
        }
        this.inc(k.code);
    }

    public void inc(InsertException.InsertExceptionMode k) {
        if (!this.insert) {
            throw new IllegalStateException();
        }
        this.inc(k.code);
    }

    public synchronized void inc(int k) {
        Integer key;
        Integer i;
        if (k == 0) {
            Logger.error(this, "Can't increment 0, not a valid failure mode", (Throwable)new Exception("error"));
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((i = this.map.get(key = Integer.valueOf(k))) == null) {
            this.map.put(key, 1);
        } else {
            this.map.put(key, i + 1);
        }
        ++this.total;
    }

    public void inc(FetchException.FetchExceptionMode k, int val) {
        if (this.insert) {
            throw new IllegalStateException();
        }
        this.inc(k.code, val);
    }

    public void inc(InsertException.InsertExceptionMode k, int val) {
        if (!this.insert) {
            throw new IllegalStateException();
        }
        this.inc(k.code, val);
    }

    public synchronized void inc(Integer k, int val) {
        Integer key;
        Integer i;
        if (k == 0) {
            Logger.error(this, "Can't increment 0, not a valid failure mode", (Throwable)new Exception("error"));
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((i = this.map.get(key = k)) == null) {
            this.map.put(key, 1);
        } else {
            this.map.put(key, i + val);
        }
        this.total += val;
    }

    public synchronized String toVerboseString() {
        if (this.map == null) {
            return super.toString() + ":empty";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> e : this.map.entrySet()) {
            Integer x = e.getKey();
            Integer val = e.getValue();
            String s = this.getMessage(x);
            sb.append(val);
            sb.append('\t');
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getMessage(Integer x) {
        return this.insert ? InsertException.getMessage(InsertException.InsertExceptionMode.getByCode(x)) : FetchException.getMessage(FetchException.FetchExceptionMode.getByCode(x));
    }

    public synchronized String toString() {
        if (this.map == null) {
            return super.toString() + ":empty";
        }
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(':');
        if (this.map.isEmpty()) {
            sb.append("empty");
        } else if (this.map.size() == 1) {
            sb.append("one:");
            Integer code = (Integer)this.map.keySet().toArray()[0];
            sb.append(code);
            sb.append('=');
            sb.append(this.map.get(code));
        } else if (this.map.size() < 10) {
            boolean needComma = false;
            for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
                if (needComma) {
                    sb.append(',');
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
                needComma = true;
            }
        } else {
            sb.append(this.map.size());
        }
        return sb.toString();
    }

    public synchronized FailureCodeTracker merge(FailureCodeTracker source) {
        if (source.map == null) {
            return this;
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        for (Map.Entry<Integer, Integer> e : source.map.entrySet()) {
            Integer k = e.getKey();
            Integer item = e.getValue();
            this.inc(k, (int)item);
        }
        return this;
    }

    public void merge(FetchException e) {
        if (this.insert) {
            throw new IllegalStateException("Merging a FetchException in an insert!");
        }
        if (e.errorCodes != null) {
            this.merge(e.errorCodes);
        }
        this.inc(e.mode.code);
    }

    public synchronized int totalCount() {
        return this.total;
    }

    public synchronized SimpleFieldSet toFieldSet(boolean verbose) {
        SimpleFieldSet sfs = new SimpleFieldSet(false);
        if (this.map != null) {
            for (Map.Entry<Integer, Integer> e : this.map.entrySet()) {
                Integer k = e.getKey();
                Integer item = e.getValue();
                int code = k;
                if (verbose) {
                    sfs.putSingle(Integer.toString(code) + ".Description", this.getMessage(code));
                }
                sfs.put(Integer.toString(code) + ".Count", item);
            }
        }
        return sfs;
    }

    public synchronized boolean isOneCodeOnly() {
        if (this.map == null) {
            return true;
        }
        return this.map.size() == 1;
    }

    public FetchException.FetchExceptionMode getFirstCodeFetch() {
        if (this.insert) {
            throw new IllegalStateException();
        }
        return FetchException.FetchExceptionMode.getByCode(this.getFirstCode());
    }

    public InsertException.InsertExceptionMode getFirstCodeInsert() {
        if (!this.insert) {
            throw new IllegalStateException();
        }
        return InsertException.InsertExceptionMode.getByCode(this.getFirstCode());
    }

    public synchronized int getFirstCode() {
        return (Integer)this.map.keySet().toArray()[0];
    }

    public synchronized boolean isFatal(boolean insert) {
        if (this.map == null) {
            return false;
        }
        for (Map.Entry<Integer, Integer> e : this.map.entrySet()) {
            Integer code = e.getKey();
            if (e.getValue() == 0 || !(insert ? InsertException.isFatal(InsertException.InsertExceptionMode.getByCode(code)) : FetchException.isFatal(FetchException.FetchExceptionMode.getByCode(code)))) continue;
            return true;
        }
        return false;
    }

    public void merge(InsertException e) {
        if (!this.insert) {
            throw new IllegalArgumentException("This is not an insert yet merge(" + e + ") called!");
        }
        if (e.errorCodes != null) {
            this.merge(e.errorCodes);
        }
        this.inc(e.getMode());
    }

    public synchronized boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public FailureCodeTracker clone() {
        FailureCodeTracker tracker = new FailureCodeTracker(this.insert);
        tracker.merge(this);
        return tracker;
    }

    public synchronized boolean isDataFound() {
        if (!this.insert) {
            throw new IllegalStateException();
        }
        for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
            if (entry.getValue() <= 0 || !FetchException.isDataFound(FetchException.FetchExceptionMode.getByCode(entry.getKey()), null)) continue;
            return true;
        }
        return false;
    }

    public static int getFixedLength(boolean insert) {
        int upperLimit = insert ? 1024 : 1024;
        return 12 + 4 * upperLimit;
    }

    public synchronized void writeFixedLengthTo(DataOutputStream dos) throws IOException {
        int upperLimit = this.insert ? 1024 : 1024;
        dos.writeInt(this.MAGIC);
        dos.writeInt(this.VERSION);
        dos.writeInt(upperLimit);
        for (int i = 0; i < upperLimit; ++i) {
            dos.writeInt(this.getErrorCount(i));
        }
    }

    public synchronized int getErrorCount(int mode) {
        if (this.map == null) {
            return 0;
        }
        Integer item = this.map.get(mode);
        return item == null ? 0 : item;
    }

    public synchronized int getErrorCount(InsertException.InsertExceptionMode mode) {
        if (!this.insert) {
            throw new IllegalStateException();
        }
        return this.getErrorCount(mode.code);
    }

    public synchronized int getErrorCount(FetchException.FetchExceptionMode mode) {
        if (this.insert) {
            throw new IllegalStateException();
        }
        return this.getErrorCount(mode.code);
    }

    public FailureCodeTracker(boolean insert, DataInputStream dis) throws IOException, StorageFormatException {
        int upperLimit;
        this.insert = insert;
        if (dis.readInt() != this.MAGIC) {
            throw new StorageFormatException("Bad magic for FailureCodeTracker");
        }
        if (dis.readInt() != this.VERSION) {
            throw new StorageFormatException("Bad version for FailureCodeTracker");
        }
        int n = upperLimit = insert ? 1024 : 1024;
        if (dis.readInt() != upperLimit) {
            throw new StorageFormatException("Bad upper limit for FailureCodeTracker");
        }
        for (int i = 0; i < upperLimit; ++i) {
            int x = dis.readInt();
            if (x < 0) {
                throw new StorageFormatException("Negative error counts");
            }
            if (x == 0) continue;
            if (this.map == null) {
                this.map = new HashMap();
            }
            this.total += x;
            this.map.put(i, x);
        }
    }
}

