/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.node.Location;
import freenet.support.SimpleFieldSet;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.RunningAverage;
import java.util.function.UnaryOperator;

public final class DecayingKeyspaceAverage
implements RunningAverage,
Cloneable {
    private final BootstrappingDecayingRunningAverage avg;

    public DecayingKeyspaceAverage(double defaultValue, int maxReports, SimpleFieldSet fs) {
        this.avg = new BootstrappingDecayingRunningAverage(defaultValue, -0.5, 1.5, maxReports, fs);
    }

    public DecayingKeyspaceAverage(DecayingKeyspaceAverage other) {
        this.avg = other.avg.clone();
    }

    @Override
    public DecayingKeyspaceAverage clone() {
        return new DecayingKeyspaceAverage(this);
    }

    @Override
    public double currentValue() {
        return this.avg.currentValue();
    }

    @Override
    public void report(double d) {
        this.avg.report(this.locationUpdateFunction(d));
    }

    @Override
    public double valueIfReported(double d) {
        return this.avg.valueIfReported(this.locationUpdateFunction(d));
    }

    @Override
    public long countReports() {
        return this.avg.countReports();
    }

    @Override
    public void report(long d) {
        throw new IllegalArgumentException("KeyspaceAverage does not like longs");
    }

    public void changeMaxReports(int maxReports) {
        this.avg.changeMaxReports(maxReports);
    }

    public SimpleFieldSet exportFieldSet(boolean shortLived) {
        return this.avg.exportFieldSet(shortLived);
    }

    private UnaryOperator<BootstrappingDecayingRunningAverage.Data> locationUpdateFunction(double d) {
        if (!Location.isValid(d)) {
            throw new IllegalArgumentException("Not a valid normalized key: " + d);
        }
        return data -> {
            double currentValue = data.currentValue();
            double change = Location.change(currentValue, d);
            return this.normalize(data.updated(currentValue + change));
        };
    }

    private BootstrappingDecayingRunningAverage.Data normalize(BootstrappingDecayingRunningAverage.Data data) {
        return data.withCurrentValue(Location.normalize(data.currentValue()));
    }
}

