/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.node.NodeStats;
import freenet.support.Fields;
import freenet.support.LRUCache;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;

public class InetAddressIpv6FirstComparator
implements Comparator<InetAddress> {
    public LRUCache<Integer, Boolean> reachabilityCache = new LRUCache(1000, 300000L);
    private final Comparator<InetAddress> innerComparator = this.prefer(Objects::nonNull).thenComparing(this.preferNot(InetAddress::isAnyLocalAddress)).thenComparing(this.preferNot(InetAddress::isLoopbackAddress)).thenComparing(this.preferNot(InetAddress::isLinkLocalAddress)).thenComparing(this.prefer(this::isReachableSiteLocalAddress)).thenComparing(this.prefer(Inet6Address.class::isInstance)).thenComparingInt(Objects::hashCode).thenComparing(InetAddress::getAddress, Fields::compareBytes);
    public static final InetAddressIpv6FirstComparator COMPARATOR = new InetAddressIpv6FirstComparator();

    private boolean isReachableSiteLocalAddress(InetAddress inetAddress) {
        return inetAddress.isSiteLocalAddress() && this.isReachable(inetAddress);
    }

    @Override
    public int compare(InetAddress arg0, InetAddress arg1) {
        if (Objects.equals(arg0, arg1)) {
            return 0;
        }
        return this.innerComparator.compare(arg0, arg1);
    }

    private boolean isReachable(InetAddress inetAddress) {
        int hashCode = inetAddress.hashCode();
        Boolean reachable = this.reachabilityCache.get(hashCode);
        if (reachable == null) {
            try {
                reachable = inetAddress.isReachable((int)NodeStats.DEFAULT_MAX_PING_TIME);
            }
            catch (IOException e) {
                reachable = false;
            }
            this.reachabilityCache.put(hashCode, reachable);
        }
        return reachable;
    }

    private Comparator<InetAddress> prefer(Predicate<InetAddress> pred) {
        return (arg0, arg1) -> Boolean.compare(!pred.test((InetAddress)arg0), !pred.test((InetAddress)arg1));
    }

    private Comparator<InetAddress> preferNot(Predicate<InetAddress> pred) {
        return this.prefer(pred).reversed();
    }
}

