/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;

public class URIPreEncoder {
    public static final String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-!.~'()*,;:$&+=?/@%#";

    public static String encode(String s) {
        StringBuilder output = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (allowedChars.indexOf(c) >= 0) {
                output.append(c);
                continue;
            }
            String tmp = String.valueOf(c);
            for (byte u : tmp.getBytes(StandardCharsets.UTF_8)) {
                int x = u & 0xFF;
                output.append('%');
                if (x < 16) {
                    output.append('0');
                }
                output.append(Integer.toHexString(x));
            }
        }
        return output.toString();
    }

    public static URI encodeURI(String s) throws URISyntaxException {
        return new URI(URIPreEncoder.encode(s));
    }
}

