/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.BinaryBloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.NullBloomFilter;
import freenet.support.math.MersenneTwister;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BloomFilter {
    protected ByteBuffer filter;
    protected final int k;
    protected final int length;
    protected transient ReadWriteLock lock = new ReentrantReadWriteLock();
    protected BloomFilter forkedFilter;
    protected boolean needRebuild;

    public void init() {
        this.lock = new ReentrantReadWriteLock();
    }

    public static BloomFilter createFilter(int length, int k, boolean counting) {
        if (length == 0) {
            return new NullBloomFilter(length, k);
        }
        if (counting) {
            return new CountingBloomFilter(length, k);
        }
        return new BinaryBloomFilter(length, k);
    }

    public static BloomFilter createFilter(File file, int length, int k, boolean counting) throws IOException {
        if (length == 0) {
            return new NullBloomFilter(length, k);
        }
        if (counting) {
            return new CountingBloomFilter(file, length, k);
        }
        return new BinaryBloomFilter(file, length, k);
    }

    protected BloomFilter(int length, int k) {
        if (length < 0) {
            throw new IllegalArgumentException("Filter must have postitive or zero length");
        }
        if (k < 0) {
            throw new IllegalArgumentException("Filter must have postitive or zero hashes");
        }
        if (length % 8 != 0) {
            length -= length % 8;
        }
        if (length == 0) {
            k = 0;
        }
        this.length = length;
        this.k = k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKey(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                this.setBit(hashes.nextInt(this.length));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.forkedFilter != null) {
            this.forkedFilter.addKey(key);
        }
    }

    public void addKeyForked(byte[] key) {
        if (this.forkedFilter != null) {
            this.forkedFilter.addKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFilter(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                if (this.getBit(hashes.nextInt(this.length))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                this.unsetBit(hashes.nextInt(this.length));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.forkedFilter != null) {
            this.forkedFilter.removeKey(key);
        }
    }

    protected abstract boolean getBit(int var1);

    protected abstract void setBit(int var1);

    protected abstract void unsetBit(int var1);

    public void unsetAll() {
        int x = this.filter.limit();
        for (int i = 0; i < x; ++i) {
            this.filter.put(i, (byte)0);
        }
    }

    protected Random getHashes(byte[] key) {
        return MersenneTwister.createUnsynchronized(key);
    }

    public abstract void fork(int var1);

    public void merge() {
        this.lock.writeLock().lock();
        try {
            if (this.forkedFilter == null) {
                return;
            }
            Lock forkedLock = this.forkedFilter.lock.writeLock();
            forkedLock.lock();
            try {
                this.filter.position(0);
                this.forkedFilter.filter.position(0);
                this.filter.put(this.forkedFilter.filter);
                this.filter.position(0);
                this.forkedFilter.close();
                this.forkedFilter = null;
            }
            finally {
                forkedLock.unlock();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void discard() {
        this.lock.writeLock().lock();
        try {
            if (this.forkedFilter == null) {
                return;
            }
            this.forkedFilter.close();
            this.forkedFilter = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static int optimialK(int filterLength, long maxKey) {
        if (filterLength == 0) {
            return 0;
        }
        long k = Math.round(Math.log(2.0) * (double)filterLength / (double)maxKey);
        if (k > 64L) {
            k = 64L;
        }
        if (k < 1L) {
            k = 1L;
        }
        return (int)k;
    }

    public int getK() {
        return this.k;
    }

    public boolean needRebuild() {
        boolean _needRebuild = this.needRebuild;
        this.needRebuild = false;
        return _needRebuild;
    }

    public void force() {
        if (this.filter instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.filter).force();
        }
    }

    public void close() {
        if (this.filter != null) {
            this.force();
        }
        this.filter = null;
        this.forkedFilter = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getSizeBytes() {
        return this.filter.capacity();
    }

    public int getLength() {
        return this.length;
    }

    public int getFilledCount() {
        int x = 0;
        for (int i = 0; i < this.length; ++i) {
            if (!this.getBit(i)) continue;
            ++x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyTo(byte[] buf, int offset) {
        this.lock.readLock().lock();
        try {
            int capacity = this.filter.capacity();
            System.arraycopy(this.filter.array(), this.filter.arrayOffset(), buf, offset, capacity);
            int n = capacity;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void writeTo(OutputStream cos) throws IOException {
        cos.write(this.filter.array(), this.filter.arrayOffset(), this.filter.capacity());
    }
}

