/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;

public class MeaningfulNodeNameUserAlert
extends AbstractUserAlert {
    private final Node node;

    public MeaningfulNodeNameUserAlert(Node n) {
        super(true, null, null, null, null, (short)2, true, NodeL10n.getBase().getString("UserAlert.hide"), true, null);
        this.node = n;
    }

    @Override
    public String getTitle() {
        return this.l10n("noNodeNickTitle");
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("MeaningfulNodeNameUserAlert." + key);
    }

    @Override
    public String getText() {
        return this.l10n("noNodeNick");
    }

    @Override
    public String getShortText() {
        return this.l10n("noNodeNickShort");
    }

    @Override
    public HTMLNode getHTMLText() {
        SubConfig sc = this.node.getConfig().get("node");
        Option<?> o = sc.getOption("name");
        HTMLNode alertNode = new HTMLNode("div");
        HTMLNode textNode = alertNode.addChild("div");
        textNode.addChild("#", this.l10n("noNodeNick"));
        HTMLNode formNode = alertNode.addChild("form", new String[]{"action", "method"}, new String[]{"/config/" + sc.getPrefix(), "post"});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.node.getClientCore().getFormPassword()});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "subconfig", sc.getPrefix()});
        HTMLNode listNode = formNode.addChild("ul", "class", "config");
        HTMLNode itemNode = listNode.addChild("li");
        itemNode.addChild("span", new String[]{"class", "title", "style"}, new String[]{"configshortdesc", NodeL10n.getBase().getString("ConfigToadlet.defaultIs", new String[]{"default"}, new String[]{o.getDefault()}), "cursor: help;"}).addChild(o.getShortDescNode());
        itemNode.addChild("input", new String[]{"type", "class", "alt", "name", "value"}, new String[]{"text", "config", o.getShortDesc(), "node.name", o.getValueDisplayString()});
        itemNode.addChild("span", "class", "configlongdesc").addChild(o.getLongDescNode());
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", NodeL10n.getBase().getString("UserAlert.apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", NodeL10n.getBase().getString("UserAlert.reset")});
        return alertNode;
    }

    @Override
    public boolean isValid() {
        return this.node.getPeers().anyDarknetPeers();
    }
}

