/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FeedMessage;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.io.FilenameGenerator;
import java.io.File;

public class DiskSpaceUserAlert
implements UserAlert {
    final NodeClientCore core;
    private Status status;
    private long lastCheckedStatus;
    static final int UPDATE_TIME = 100;

    Status evaluate() {
        long shortTermLimit = this.core.getMinDiskFreeShortTerm();
        long longTermLimit = this.core.getMinDiskFreeLongTerm();
        File tempDir = this.core.getTempFilenameGenerator().getDir();
        if (tempDir.getUsableSpace() < shortTermLimit) {
            return Status.TRANSIENT;
        }
        FilenameGenerator fg = this.core.getPersistentFilenameGenerator();
        if (fg != null) {
            File persistentTempDir = fg.getDir();
            long space = persistentTempDir.getUsableSpace();
            if (space < shortTermLimit) {
                return Status.PERSISTENT_COMPLETION;
            }
            if (space < longTermLimit) {
                return Status.PERSISTENT;
            }
        }
        return Status.OK;
    }

    public DiskSpaceUserAlert(NodeClientCore core) {
        this.core = core;
    }

    @Override
    public boolean userCanDismiss() {
        return true;
    }

    @Override
    public String getTitle() {
        return DiskSpaceUserAlert.l10n("title");
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("DiskSpaceUserAlert." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("DiskSpaceUserAlert." + key, pattern, value);
    }

    @Override
    public String getText() {
        Status status = this.getStatus();
        StringBuffer sb = new StringBuffer();
        sb.append(DiskSpaceUserAlert.l10n("notEnoughSpaceIn", "where", this.getWhere(status).toString()));
        sb.append(" ");
        sb.append(status.getExplanation());
        sb.append(" ");
        sb.append(DiskSpaceUserAlert.l10n("action"));
        return sb.toString();
    }

    private File getWhere(Status status) {
        FilenameGenerator fg;
        if ((status == Status.PERSISTENT || status == Status.PERSISTENT_COMPLETION) && (fg = this.core.getPersistentFilenameGenerator()) != null) {
            return fg.getDir();
        }
        return this.core.getTempFilenameGenerator().getDir();
    }

    private synchronized Status getStatus() {
        long now = System.currentTimeMillis();
        if (this.status != null && now - this.lastCheckedStatus <= 100L) {
            return this.status;
        }
        try {
            this.status = this.evaluate();
            this.lastCheckedStatus = now;
            return this.status;
        }
        catch (Throwable t) {
            Logger.error(this, "Unable to check disk space: " + t, t);
            return Status.OK;
        }
    }

    @Override
    public HTMLNode getHTMLText() {
        return new HTMLNode("#", this.getText());
    }

    @Override
    public String getShortText() {
        return this.getTitle();
    }

    @Override
    public short getPriorityClass() {
        return 0;
    }

    @Override
    public boolean isValid() {
        Status status = this.getStatus();
        return status != Status.OK;
    }

    @Override
    public void isValid(boolean validity) {
    }

    @Override
    public String dismissButtonText() {
        return NodeL10n.getBase().getString("UserAlert.hide");
    }

    @Override
    public boolean shouldUnregisterOnDismiss() {
        return true;
    }

    @Override
    public void onDismiss() {
    }

    @Override
    public String anchor() {
        return "not-enough-disk-space";
    }

    @Override
    public boolean isEventNotification() {
        return false;
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new FeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime());
    }

    @Override
    public synchronized long getUpdatedTime() {
        return this.lastCheckedStatus;
    }

    static enum Status {
        OK,
        PERSISTENT,
        TRANSIENT,
        PERSISTENT_COMPLETION;


        public String getExplanation() {
            return DiskSpaceUserAlert.l10n("explanation." + this.toString());
        }
    }
}

