/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.diagnostics.threads;

import freenet.node.NodeStats;
import freenet.node.diagnostics.ThreadDiagnostics;
import freenet.node.diagnostics.threads.NodeThreadInfo;
import freenet.node.diagnostics.threads.NodeThreadSnapshot;
import freenet.support.PooledExecutor;
import freenet.support.Ticker;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class DefaultThreadDiagnostics
implements Runnable,
ThreadDiagnostics {
    private final String name;
    private final int monitorInterval;
    private final NodeStats nodeStats;
    private final Ticker ticker;
    private static final int DEFAULT_MONITOR_INTERVAL = 1000;
    private static final String DEFAULT_MONITOR_THREAD_NAME = "NodeDiagnostics: thread monitor";
    private final AtomicReference<NodeThreadSnapshot> nodeThreadSnapshot = new AtomicReference<NodeThreadSnapshot>(new NodeThreadSnapshot(new ArrayList<NodeThreadInfo>(), 1000));
    private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private final Map<Long, ThreadSnapshot> threadSnapshot = new HashMap<Long, ThreadSnapshot>();

    public DefaultThreadDiagnostics(NodeStats nodeStats, Ticker ticker, String name, int monitorInterval) {
        this.nodeStats = nodeStats;
        this.ticker = ticker;
        this.name = name;
        this.monitorInterval = monitorInterval;
    }

    public DefaultThreadDiagnostics(NodeStats nodeStats, Ticker ticker) {
        this(nodeStats, ticker, DEFAULT_MONITOR_THREAD_NAME, 1000);
    }

    @Override
    public NodeThreadSnapshot getThreadSnapshot() {
        return this.nodeThreadSnapshot.get();
    }

    private void scheduleNext(int interval) {
        this.ticker.queueTimedJob(this, this.name, interval, false, true);
    }

    public void start() {
        this.scheduleNext(0);
    }

    public void stop() {
        this.ticker.removeQueuedJob(this);
    }

    private void scheduleNext() {
        this.scheduleNext(this.monitorInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCpuTimeDelta(Thread thread) {
        long jobId;
        long current;
        String name;
        Thread thread2 = thread;
        synchronized (thread2) {
            name = thread.getName();
            current = this.threadMxBean.getThreadCpuTime(thread.getId());
            jobId = this.getJobId(thread);
        }
        ThreadSnapshot snapshot = this.threadSnapshot.get(jobId);
        long cpuUsage = current - (snapshot != null ? snapshot.getCpu() : 0L);
        this.threadSnapshot.put(jobId, new ThreadSnapshot(current, name));
        return cpuUsage;
    }

    private long getJobId(Thread thread) {
        long jobId = thread.getId();
        if (thread instanceof PooledExecutor.MyThread) {
            jobId = ((PooledExecutor.MyThread)thread).getJobId();
        }
        return jobId;
    }

    private void purgeInactiveThreads(List<NodeThreadInfo> threads) {
        List activeThreads = threads.stream().map(NodeThreadInfo::getJobId).collect(Collectors.toList());
        this.threadSnapshot.keySet().removeIf(key -> !activeThreads.contains(key));
    }

    private String getJobName(Thread thread) {
        ThreadSnapshot ts = this.threadSnapshot.get(this.getJobId(thread));
        return ts != null ? ts.getName() : thread.getName();
    }

    @Override
    public void run() {
        List<NodeThreadInfo> threads = Arrays.stream(this.nodeStats.getThreads()).filter(Objects::nonNull).filter(thread -> thread.getThreadGroup() != null).filter(thread -> this.getJobId((Thread)thread) != 0L).map(thread -> new NodeThreadInfo(thread.getId(), this.getJobId((Thread)thread), this.getCpuTimeDelta((Thread)thread), this.getJobName((Thread)thread), thread.getPriority(), thread.getThreadGroup().getName(), thread.getState().toString())).collect(Collectors.toList());
        this.nodeThreadSnapshot.set(new NodeThreadSnapshot(threads, this.monitorInterval));
        this.purgeInactiveThreads(threads);
        this.scheduleNext();
    }

    private static class ThreadSnapshot {
        private final long cpu;
        private final String name;

        public ThreadSnapshot(long cpu, String name) {
            this.cpu = cpu;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getCpu() {
            return this.cpu;
        }
    }
}

