/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class NodePinger
implements Runnable {
    private static volatile boolean logMINOR;
    private final Node node;
    private volatile double meanPing = 0.0;
    public static final double CRAZY_MAX_PING_TIME;
    final CapacityChecker capacityInputRealtime = new CapacityChecker(true, true);
    final CapacityChecker capacityInputBulk = new CapacityChecker(true, false);
    final CapacityChecker capacityOutputRealtime = new CapacityChecker(false, true);
    final CapacityChecker capacityOutputBulk = new CapacityChecker(false, false);

    NodePinger(Node n) {
        this.node = n;
    }

    void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PeerNode[] peers = null;
            PeerManager peerManager = this.node.getPeers();
            synchronized (peerManager) {
                peers = this.node.getPeers().connectedPeers();
            }
            if (peers == null || peers.length == 0) {
                return;
            }
            this.recalculateMean(peers);
            this.capacityInputRealtime.calculate(peers);
            this.capacityInputBulk.calculate(peers);
            this.capacityOutputRealtime.calculate(peers);
            this.capacityOutputBulk.calculate(peers);
        }
        finally {
            this.node.getTicker().queueTimedJob(this, 200L);
        }
    }

    private void recalculateMean(PeerNode[] peers) {
        if (peers.length == 0) {
            return;
        }
        this.meanPing = this.calculateMedianPing(peers);
        if (logMINOR) {
            Logger.minor(this, "Median ping: " + this.meanPing);
        }
    }

    private double calculateMedianPing(PeerNode[] peers) {
        double[] allPeers = new double[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            PeerNode peer = peers[i];
            allPeers[i] = peer.averagePingTime();
        }
        Arrays.sort(allPeers);
        return allPeers[peers.length / 2];
    }

    public double averagePingTime() {
        return this.meanPing;
    }

    public double capacityThreshold(boolean isRealtime, boolean isInput) {
        return this.capacityChecker(isRealtime, isInput).getThreshold();
    }

    private CapacityChecker capacityChecker(boolean isRealtime, boolean isInput) {
        if (isRealtime) {
            return isInput ? this.capacityInputRealtime : this.capacityOutputRealtime;
        }
        return isInput ? this.capacityInputBulk : this.capacityOutputBulk;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        CRAZY_MAX_PING_TIME = 365.25 * (double)TimeUnit.DAYS.toMillis(1L);
    }

    class CapacityChecker {
        final boolean isInput;
        final boolean isRealtime;
        private double min;
        private double median;
        private double firstQuartile;
        private double lastQuartile;
        private double max;

        CapacityChecker(boolean input, boolean realtime) {
            this.isInput = input;
            this.isRealtime = realtime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void calculate(PeerNode[] peers) {
            double[] allPeers = new double[peers.length];
            int x = 0;
            for (PeerNode peer : peers) {
                NodeStats.PeerLoadStats stats = peer.outputLoadTracker(this.isRealtime).getLastIncomingLoadStats();
                if (stats == null) continue;
                allPeers[x++] = stats.peerLimit(this.isInput);
            }
            if (x != peers.length) {
                allPeers = Arrays.copyOf(allPeers, x);
            }
            Arrays.sort(allPeers);
            if (x == 0) {
                return;
            }
            CapacityChecker capacityChecker = this;
            synchronized (capacityChecker) {
                this.min = allPeers[0];
                this.median = allPeers[x / 2];
                this.firstQuartile = allPeers[x / 4];
                this.lastQuartile = allPeers[x * 3 / 4];
                this.max = allPeers[x - 1];
                if (logMINOR) {
                    Logger.minor(this, "Quartiles for peer capacities: " + (this.isInput ? "input " : "output ") + (this.isRealtime ? "realtime: " : "bulk: ") + Arrays.toString(this.getQuartiles()));
                }
            }
        }

        synchronized double[] getQuartiles() {
            return new double[]{this.min, this.firstQuartile, this.median, this.lastQuartile, this.max};
        }

        synchronized double getThreshold() {
            return Math.min(this.median / 2.0, this.firstQuartile);
        }
    }
}

