/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.node.PrioRunnable;
import freenet.support.BitArray;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.util.concurrent.TimeUnit;

public class BulkTransmitter {
    static final long TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    static final long FINAL_ACK_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    final AllSentCallback allSentCallback;
    final PartiallyReceivedBulk prb;
    final PeerContext peer;
    final long uid;
    final BitArray blocksNotSentButPresent;
    private boolean cancelled;
    final long peerBootID;
    private boolean sentCancel;
    private boolean finished;
    final boolean noWait;
    private long finishTime = -1L;
    private String cancelReason;
    private final ByteCounter ctr;
    private final boolean realTime;
    private static long transfersCompleted;
    private static long transfersSucceeded;
    private static volatile boolean logMINOR;
    private int inFlightPackets = 0;
    private int unsentPackets = 0;
    private boolean failedPacket = false;
    private boolean allQueued = false;
    private boolean calledAllSent = false;

    public BulkTransmitter(PartiallyReceivedBulk prb, PeerContext peer, long uid, boolean noWait, ByteCounter ctr, boolean realTime) throws DisconnectedException {
        this(prb, peer, uid, noWait, ctr, realTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkTransmitter(PartiallyReceivedBulk prb, PeerContext peer, long uid, boolean noWait, ByteCounter ctr, boolean realTime, AllSentCallback cb) throws DisconnectedException {
        this.prb = prb;
        this.peer = peer;
        this.uid = uid;
        this.noWait = noWait;
        this.ctr = ctr;
        this.realTime = realTime;
        this.allSentCallback = cb;
        if (ctr == null) {
            throw new NullPointerException();
        }
        this.peerBootID = peer.getBootID();
        PartiallyReceivedBulk partiallyReceivedBulk = prb;
        synchronized (partiallyReceivedBulk) {
            this.blocksNotSentButPresent = prb.cloneBlocksReceived();
            prb.add(this);
        }
        try {
            prb.usm.addAsyncFilter(MessageFilter.create().setNoTimeout().setSource(peer).setType(DMT.FNPBulkReceiveAborted).setField("uid", uid), new AsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    BulkTransmitter.this.cancel("Other side sent FNPBulkReceiveAborted");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean shouldTimeout() {
                    BulkTransmitter bulkTransmitter = BulkTransmitter.this;
                    synchronized (bulkTransmitter) {
                        if (BulkTransmitter.this.cancelled || BulkTransmitter.this.finished) {
                            return true;
                        }
                    }
                    return BulkTransmitter.this.prb.isAborted();
                }

                @Override
                public void onTimeout() {
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                }
            }, ctr);
            prb.usm.addAsyncFilter(MessageFilter.create().setNoTimeout().setSource(peer).setType(DMT.FNPBulkReceivedAll).setField("uid", uid), new AsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    BulkTransmitter.this.setAllQueued();
                    BulkTransmitter.this.completed();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean shouldTimeout() {
                    BulkTransmitter bulkTransmitter = BulkTransmitter.this;
                    synchronized (bulkTransmitter) {
                        if (BulkTransmitter.this.cancelled) {
                            return true;
                        }
                        if (BulkTransmitter.this.finished) {
                            return System.currentTimeMillis() - BulkTransmitter.this.finishTime > FINAL_ACK_TIMEOUT;
                        }
                    }
                    return BulkTransmitter.this.prb.isAborted();
                }

                @Override
                public void onTimeout() {
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                }
            }, ctr);
        }
        catch (DisconnectedException e) {
            this.cancel("Disconnected");
            throw e;
        }
    }

    synchronized void blockReceived(int block) {
        this.blocksNotSentButPresent.setBit(block, true);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAborted() {
        this.sendAbortedMessage();
        BulkTransmitter bulkTransmitter = this;
        synchronized (bulkTransmitter) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAbortedMessage() {
        BulkTransmitter bulkTransmitter = this;
        synchronized (bulkTransmitter) {
            if (this.sentCancel) {
                return;
            }
            this.sentCancel = true;
        }
        try {
            this.peer.sendAsync(DMT.createFNPBulkSendAborted(this.uid), null, this.ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String reason) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this);
        }
        this.sendAbortedMessage();
        Object object = this;
        synchronized (object) {
            if (this.cancelled || this.finished) {
                return;
            }
            this.cancelled = true;
            this.cancelReason = reason;
            this.notifyAll();
        }
        this.prb.remove(this);
        object = BulkTransmitter.class;
        synchronized (BulkTransmitter.class) {
            ++transfersCompleted;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.setAllQueued();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed() {
        Object object = this;
        synchronized (object) {
            if (this.cancelled || this.finished) {
                return;
            }
            this.finished = true;
            this.finishTime = System.currentTimeMillis();
            this.notifyAll();
        }
        this.prb.remove(this);
        object = BulkTransmitter.class;
        synchronized (BulkTransmitter.class) {
            ++transfersCompleted;
            ++transfersSucceeded;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (logMINOR) {
                Logger.minor(this, "Completed transfer successfully " + this);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send() throws DisconnectedException {
        long lastSentPacket = System.currentTimeMillis();
        block23: while (true) {
            int blockNo;
            int max = Math.min(Integer.MAX_VALUE, this.prb.blocks);
            max = Math.min(max, this.peer.getThrottleWindowSize());
            if ((max = Math.min(max, 100)) < 1) {
                max = 1;
            }
            if (this.prb.isAborted()) {
                if (logMINOR) {
                    Logger.minor(this, "Aborted " + this);
                }
                return false;
            }
            if (this.peer.getBootID() != this.peerBootID) {
                BulkTransmitter bulkTransmitter = this;
                synchronized (bulkTransmitter) {
                    this.cancelled = true;
                    this.notifyAll();
                }
                this.prb.remove(this);
                if (logMINOR) {
                    Logger.minor(this, "Failed to send " + this.uid + ": peer restarted: " + this.peer);
                }
                throw new DisconnectedException();
            }
            BulkTransmitter bulkTransmitter = this;
            synchronized (bulkTransmitter) {
                if (this.finished) {
                    return true;
                }
                if (this.cancelled) {
                    return false;
                }
                blockNo = this.blocksNotSentButPresent.firstOne();
            }
            if (blockNo < 0) {
                this.setAllQueued();
                if (this.noWait && this.prb.hasWholeFile()) {
                    this.completed();
                    return true;
                }
                bulkTransmitter = this;
                synchronized (bulkTransmitter) {
                    while (true) {
                        if (this.failedPacket) {
                            this.cancel("Packet send failed");
                            return false;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for packets: remaining: " + this.inFlightPackets);
                        }
                        if (this.inFlightPackets == 0) break;
                        try {
                            this.wait();
                            if (this.failedPacket) {
                                this.cancel("Packet send failed");
                                return false;
                            }
                            if (this.inFlightPackets == 0) break;
                            continue block23;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    try {
                        this.wait(TimeUnit.SECONDS.toMillis(60L));
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                long end = System.currentTimeMillis();
                if (end - lastSentPacket <= TIMEOUT) continue;
                Logger.error(this, "Send timed out on " + this);
                this.cancel("Timeout awaiting BulkReceivedAll");
                return false;
            }
            byte[] buf = this.prb.getBlockData(blockNo);
            if (buf == null) {
                if (logMINOR) {
                    Logger.minor(this, "Block " + blockNo + " is null, presumably the send is cancelled: " + this);
                }
                return false;
            }
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sending packet " + blockNo);
                }
                Message msg = DMT.createFNPBulkPacketSend(this.uid, blockNo, buf, this.realTime);
                UnsentPacketTag tag = new UnsentPacketTag();
                this.peer.sendAsync(msg, tag, this.ctr);
                BulkTransmitter bulkTransmitter2 = this;
                synchronized (bulkTransmitter2) {
                    while (this.inFlightPackets >= max && !this.failedPacket) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                bulkTransmitter2 = this;
                synchronized (bulkTransmitter2) {
                    this.blocksNotSentButPresent.setBit(blockNo, false);
                }
                lastSentPacket = System.currentTimeMillis();
            }
            catch (NotConnectedException e) {
                this.cancel("Disconnected");
                if (logMINOR) {
                    Logger.minor(this, "Cancelled: not connected " + this);
                }
                throw new DisconnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllQueued() {
        if (this.allSentCallback != null) {
            boolean callAllSent = false;
            boolean anyFailed = false;
            BulkTransmitter bulkTransmitter = this;
            synchronized (bulkTransmitter) {
                this.allQueued = true;
                if (this.unsentPackets == 0 && !this.calledAllSent) {
                    if (logMINOR) {
                        Logger.minor(this, "Calling all sent callback on " + this);
                    }
                    callAllSent = true;
                    this.calledAllSent = true;
                    anyFailed = this.failedPacket;
                } else if (!this.calledAllSent && logMINOR) {
                    Logger.minor(this, "Still waiting for " + this.unsentPackets);
                }
            }
            if (callAllSent) {
                this.callAllSentCallbackInner(anyFailed);
            }
        }
    }

    private void callAllSentCallbackInner(final boolean anyFailed) {
        this.prb.usm.getExecutor().execute(new PrioRunnable(){

            @Override
            public void run() {
                BulkTransmitter.this.allSentCallback.allSent(BulkTransmitter.this, anyFailed);
            }

            @Override
            public int getPriority() {
                return NativeThread.HIGH_PRIORITY;
            }
        });
    }

    public String toString() {
        return "BulkTransmitter:" + this.uid + ":" + this.peer.shortToString();
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public static synchronized long[] transferSuccess() {
        return new long[]{transfersCompleted, transfersSucceeded};
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class UnsentPacketTag
    implements AsyncMessageCallback {
        private boolean finished;
        private boolean sent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UnsentPacketTag() {
            BulkTransmitter bulkTransmitter2 = BulkTransmitter.this;
            synchronized (bulkTransmitter2) {
                BulkTransmitter.this.inFlightPackets++;
                BulkTransmitter.this.unsentPackets++;
            }
        }

        @Override
        public void acknowledged() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(boolean failed) {
            Object object = this;
            synchronized (object) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                this.notifyAll();
            }
            if (!failed) {
                BulkTransmitter.this.ctr.sentPayload(BulkTransmitter.this.prb.blockSize);
            }
            object = BulkTransmitter.this;
            synchronized (object) {
                if (failed) {
                    BulkTransmitter.this.failedPacket = true;
                    BulkTransmitter.this.notifyAll();
                    if (logMINOR) {
                        Logger.minor(this, "Packet failed for " + BulkTransmitter.this);
                    }
                } else {
                    BulkTransmitter.this.inFlightPackets--;
                    BulkTransmitter.this.notifyAll();
                    if (logMINOR) {
                        Logger.minor(this, "Packet sent " + BulkTransmitter.this + " remaining in flight: " + BulkTransmitter.this.inFlightPackets);
                    }
                }
            }
            this.sent(true);
        }

        @Override
        public void disconnected() {
            this.complete(true);
        }

        @Override
        public void fatalError() {
            this.complete(true);
        }

        @Override
        public void sent() {
            this.sent(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sent(boolean ignoreFinished) {
            boolean anyFailed;
            if (BulkTransmitter.this.allSentCallback == null) {
                return;
            }
            UnsentPacketTag unsentPacketTag = this;
            synchronized (unsentPacketTag) {
                if (this.finished && !ignoreFinished) {
                    return;
                }
                if (this.sent) {
                    return;
                }
                this.sent = true;
                this.notifyAll();
            }
            BulkTransmitter bulkTransmitter = BulkTransmitter.this;
            synchronized (bulkTransmitter) {
                BulkTransmitter.this.unsentPackets--;
                if (BulkTransmitter.this.unsentPackets > 0) {
                    return;
                }
                if (!BulkTransmitter.this.allQueued) {
                    return;
                }
                if (BulkTransmitter.this.calledAllSent) {
                    return;
                }
                BulkTransmitter.this.calledAllSent = true;
                anyFailed = BulkTransmitter.this.failedPacket;
            }
            if (logMINOR) {
                Logger.minor(this, "Calling all sent callback on " + this);
            }
            BulkTransmitter.this.callAllSentCallbackInner(anyFailed);
        }
    }

    public static interface AllSentCallback {
        public void allSent(BulkTransmitter var1, boolean var2);
    }
}

