/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.crypt.EntropySource;
import freenet.io.comm.IncomingPacketFilter;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.node.FNPPacketMangler;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.concurrent.atomic.AtomicLong;

public class IncomingPacketFilterImpl
implements IncomingPacketFilter {
    private static volatile boolean logMINOR;
    private FNPPacketMangler mangler;
    private NodeCrypto crypto;
    private Node node;
    private final EntropySource fnpTimingSource;
    private static final AtomicLong successfullyDecodedPackets;
    private static final AtomicLong failedDecodePackets;

    public IncomingPacketFilterImpl(FNPPacketMangler mangler, Node node, NodeCrypto crypto) {
        this.mangler = mangler;
        this.node = node;
        this.crypto = crypto;
        this.fnpTimingSource = new EntropySource();
    }

    @Override
    public boolean isDisconnected(PeerContext context) {
        if (context == null) {
            return false;
        }
        return !context.isConnected();
    }

    public static long[] getDecodedPackets() {
        if (!logMINOR) {
            return null;
        }
        long decoded = successfullyDecodedPackets.get();
        long failed = failedDecodePackets.get();
        return new long[]{decoded, decoded + failed};
    }

    @Override
    public IncomingPacketFilter.DECODED process(byte[] buf, int offset, int length, Peer peer, long now) {
        IncomingPacketFilter.DECODED decoded;
        if (logMINOR) {
            Logger.minor(this, "Packet length " + length + " from " + peer);
        }
        this.node.getRandom().acceptTimerEntropy(this.fnpTimingSource, 0.25);
        PeerNode opn = this.node.getPeers().getByPeer(peer, this.mangler);
        if (opn != null) {
            if (opn.handleReceivedPacket(buf, offset, length, now, peer)) {
                if (logMINOR) {
                    successfullyDecodedPackets.incrementAndGet();
                }
                return IncomingPacketFilter.DECODED.DECODED;
            }
        } else {
            Logger.normal(this, "Got packet from unknown address");
        }
        if ((decoded = this.mangler.process(buf, offset, length, peer, opn, now)) == IncomingPacketFilter.DECODED.DECODED) {
            if (logMINOR) {
                successfullyDecodedPackets.incrementAndGet();
            }
        } else if (decoded == IncomingPacketFilter.DECODED.NOT_DECODED) {
            for (PeerNode pn : this.crypto.getPeerNodes()) {
                if (pn == opn || !pn.handleReceivedPacket(buf, offset, length, now, peer)) continue;
                if (logMINOR) {
                    successfullyDecodedPackets.incrementAndGet();
                }
                return IncomingPacketFilter.DECODED.DECODED;
            }
            if (logMINOR) {
                failedDecodePackets.incrementAndGet();
            }
        }
        return decoded;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, IncomingPacketFilterImpl.class);
            }
        });
        successfullyDecodedPackets = new AtomicLong();
        failedDecodePackets = new AtomicLong();
    }
}

