/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressIdentifier;
import freenet.io.AddressMatcher;
import freenet.io.EverythingMatcher;
import freenet.io.Inet4AddressMatcher;
import freenet.io.Inet6AddressMatcher;
import freenet.io.NetworkInterface;
import freenet.support.Logger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AllowedHosts {
    protected final List<AddressMatcher> addressMatchers = new ArrayList<AddressMatcher>();

    public AllowedHosts(String allowedHosts) {
        this.setAllowedHosts(allowedHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedHosts(String allowedHosts) {
        if (allowedHosts == null || allowedHosts.isEmpty()) {
            allowedHosts = "127.0.0.1,0:0:0:0:0:0:0:1";
        }
        StringTokenizer allowedHostsTokens = new StringTokenizer(allowedHosts, ",");
        ArrayList<AddressMatcher> newAddressMatchers = new ArrayList<AddressMatcher>();
        while (allowedHostsTokens.hasMoreTokens()) {
            AddressIdentifier.AddressType addressType;
            String allowedHost;
            String hostname = allowedHost = allowedHostsTokens.nextToken().trim();
            if (allowedHost.indexOf(47) != -1) {
                hostname = allowedHost.substring(0, allowedHost.indexOf(47));
            }
            if ((addressType = AddressIdentifier.getAddressType(hostname)) == AddressIdentifier.AddressType.IPv4) {
                newAddressMatchers.add(new Inet4AddressMatcher(allowedHost));
                continue;
            }
            if (addressType == AddressIdentifier.AddressType.IPv6) {
                newAddressMatchers.add(new Inet6AddressMatcher(allowedHost));
                continue;
            }
            if (allowedHost.equals("*")) {
                newAddressMatchers.add(new EverythingMatcher());
                continue;
            }
            Logger.error(NetworkInterface.class, "Ignoring invalid allowedHost: " + allowedHost);
        }
        AllowedHosts allowedHosts2 = this;
        synchronized (allowedHosts2) {
            this.addressMatchers.clear();
            this.addressMatchers.addAll(newAddressMatchers);
        }
    }

    public boolean allowed(InetAddress clientAddress) {
        AddressIdentifier.AddressType clientAddressType = AddressIdentifier.getAddressType(clientAddress.getHostAddress());
        return this.allowed(clientAddressType, clientAddress);
    }

    public synchronized boolean allowed(AddressIdentifier.AddressType clientAddressType, InetAddress clientAddress) {
        for (AddressMatcher matcher : this.addressMatchers) {
            if (!matcher.matches(clientAddress)) continue;
            return true;
        }
        return false;
    }

    public synchronized String getAllowedHosts() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.addressMatchers.size(); ++i) {
            AddressMatcher matcher = this.addressMatchers.get(i);
            if (matcher instanceof EverythingMatcher) {
                return "*";
            }
            if (i != 0) {
                sb.append(',');
            }
            sb.append(matcher.getHumanRepresentation());
        }
        return sb.toString();
    }
}

