/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.utils;

import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import freenet.l10n.BaseL10n;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class L10nExtension
extends AbstractExtension {
    private final L10nFunction l10nFunction;

    public L10nExtension(BaseL10n l10n) {
        this.l10nFunction = new L10nFunction(l10n);
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("l10n", this.l10nFunction);
        return functions;
    }

    static class L10nFunction
    implements Function {
        private final BaseL10n l10n;

        public L10nFunction(BaseL10n l10n) {
            this.l10n = l10n;
        }

        public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
            Object key = args.get("0");
            if (key == null) {
                return "null";
            }
            return this.l10n.getString(context.getVariable("l10nPrefix") + key.toString());
        }

        public List<String> getArgumentNames() {
            return null;
        }
    }
}

