/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.ConnectionsToadlet;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.N2NTMToadlet;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.ConfigException;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.DarknetPeerNodeStatus;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.PeerNodeStatus;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleFieldSet;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;

public class DarknetConnectionsToadlet
extends ConnectionsToadlet {
    DarknetConnectionsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(n, core, client);
    }

    private static String l10n(String string) {
        return NodeL10n.getBase().getString("DarknetConnectionsToadlet." + string);
    }

    @Override
    protected Comparator<PeerNodeStatus> comparator(String sortBy, boolean reversed) {
        return new DarknetComparator(sortBy, reversed);
    }

    @Override
    protected boolean hasNameColumn() {
        return true;
    }

    @Override
    protected void drawNameColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus, boolean advanced) {
        HTMLNode cell = peerRow.addChild("td", "class", "peer-name");
        cell.addChild("a", "href", "/send_n2ntm/?peernode_hashcode=" + peerNodeStatus.hashCode(), ((DarknetPeerNodeStatus)peerNodeStatus).getName());
        if (advanced && peerNodeStatus.hasFullNoderef) {
            cell.addChild("#", " (");
            cell.addChild("a", "href", this.path() + "friend-" + peerNodeStatus.hashCode() + ".fref", DarknetConnectionsToadlet.l10n("noderefLink"));
            cell.addChild("#", ")");
        }
    }

    @Override
    protected boolean hasTrustColumn() {
        return true;
    }

    @Override
    protected void drawTrustColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus) {
        peerRow.addChild("td", "class", "peer-trust").addChild("#", ((DarknetPeerNodeStatus)peerNodeStatus).getTrustLevel().name());
    }

    @Override
    protected boolean hasVisibilityColumn() {
        return true;
    }

    @Override
    protected void drawVisibilityColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus, boolean advancedModeEnabled) {
        String content = ((DarknetPeerNodeStatus)peerNodeStatus).getOurVisibility().name();
        if (advancedModeEnabled) {
            content = content + " (" + ((DarknetPeerNodeStatus)peerNodeStatus).getTheirVisibility().name() + ")";
        }
        peerRow.addChild("td", "class", "peer-trust").addChild("#", content);
    }

    @Override
    protected boolean hasPrivateNoteColumn() {
        return true;
    }

    @Override
    protected void drawPrivateNoteColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus, boolean fProxyJavascriptEnabled) {
        DarknetPeerNodeStatus status = (DarknetPeerNodeStatus)peerNodeStatus;
        if (fProxyJavascriptEnabled) {
            peerRow.addChild("td", "class", "peer-private-darknet-comment-note").addChild("input", new String[]{"type", "name", "size", "maxlength", "onChange", "value"}, new String[]{"text", "peerPrivateNote_" + peerNodeStatus.hashCode(), "16", "250", "peerNoteChange();", status.getPrivateDarknetCommentNote()});
        } else {
            peerRow.addChild("td", "class", "peer-private-darknet-comment-note").addChild("input", new String[]{"type", "name", "size", "maxlength", "value"}, new String[]{"text", "peerPrivateNote_" + peerNodeStatus.hashCode(), "16", "250", status.getPrivateDarknetCommentNote()});
        }
    }

    @Override
    protected SimpleFieldSet getNoderef() {
        return this.node.exportDarknetPublicFieldSet();
    }

    @Override
    protected PeerNodeStatus[] getPeerNodeStatuses(boolean noHeavy) {
        return this.node.getPeers().getDarknetPeerNodeStatuses(noHeavy);
    }

    @Override
    protected String getPageTitle(String titleCountString) {
        return NodeL10n.getBase().getString("DarknetConnectionsToadlet.fullTitle", new String[]{"counts"}, new String[]{titleCountString});
    }

    @Override
    protected boolean shouldDrawNoderefBox(boolean advancedModeEnabled) {
        return advancedModeEnabled;
    }

    @Override
    protected boolean showPeerActionsBox() {
        return true;
    }

    @Override
    protected void drawPeerActionSelectBox(HTMLNode peerForm, boolean advancedModeEnabled) {
        peerForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "doSendMessageToPeers", DarknetConnectionsToadlet.l10n("sendConfidentialMessage")});
        peerForm.addChild("br");
        HTMLNode actionSelect = peerForm.addChild("select", new String[]{"id", "name"}, new String[]{"action", "action"});
        actionSelect.addChild("option", "value", "", DarknetConnectionsToadlet.l10n("selectAction"));
        actionSelect.addChild("option", "value", "update_notes", DarknetConnectionsToadlet.l10n("updateChangedPrivnotes"));
        if (advancedModeEnabled) {
            actionSelect.addChild("option", "value", "enable", DarknetConnectionsToadlet.l10n("peersEnable"));
            actionSelect.addChild("option", "value", "disable", DarknetConnectionsToadlet.l10n("peersDisable"));
            actionSelect.addChild("option", "value", "set_burst_only", DarknetConnectionsToadlet.l10n("peersSetBurstOnly"));
            actionSelect.addChild("option", "value", "clear_burst_only", DarknetConnectionsToadlet.l10n("peersClearBurstOnly"));
            actionSelect.addChild("option", "value", "set_listen_only", DarknetConnectionsToadlet.l10n("peersSetListenOnly"));
            actionSelect.addChild("option", "value", "clear_listen_only", DarknetConnectionsToadlet.l10n("peersClearListenOnly"));
            actionSelect.addChild("option", "value", "set_allow_local", DarknetConnectionsToadlet.l10n("peersSetAllowLocal"));
            actionSelect.addChild("option", "value", "clear_allow_local", DarknetConnectionsToadlet.l10n("peersClearAllowLocal"));
            actionSelect.addChild("option", "value", "set_ignore_source_port", DarknetConnectionsToadlet.l10n("peersSetIgnoreSourcePort"));
            actionSelect.addChild("option", "value", "clear_ignore_source_port", DarknetConnectionsToadlet.l10n("peersClearIgnoreSourcePort"));
            actionSelect.addChild("option", "value", "set_dont_route", DarknetConnectionsToadlet.l10n("peersSetDontRoute"));
            actionSelect.addChild("option", "value", "clear_dont_route", DarknetConnectionsToadlet.l10n("peersClearDontRoute"));
        }
        actionSelect.addChild("option", "value", "", DarknetConnectionsToadlet.l10n("separator"));
        actionSelect.addChild("option", "value", "remove", DarknetConnectionsToadlet.l10n("removePeers"));
        peerForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "doAction", DarknetConnectionsToadlet.l10n("go")});
        peerForm.addChild("br");
        peerForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "doChangeTrust", DarknetConnectionsToadlet.l10n("changeTrustButton")});
        HTMLNode changeTrustLevelSelect = peerForm.addChild("select", new String[]{"id", "name"}, new String[]{"changeTrust", "changeTrust"});
        for (DarknetPeerNode.FRIEND_TRUST trust : DarknetPeerNode.FRIEND_TRUST.valuesBackwards()) {
            changeTrustLevelSelect.addChild("option", "value", trust.name(), DarknetConnectionsToadlet.l10n("peerTrust." + trust.name()));
        }
        peerForm.addChild("br");
        peerForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "doChangeVisibility", DarknetConnectionsToadlet.l10n("changeVisibilityButton")});
        HTMLNode changeVisibilitySelect = peerForm.addChild("select", new String[]{"id", "name"}, new String[]{"changeVisibility", "changeVisibility"});
        for (DarknetPeerNode.FRIEND_VISIBILITY trust : DarknetPeerNode.FRIEND_VISIBILITY.values()) {
            changeVisibilitySelect.addChild("option", "value", trust.name(), DarknetConnectionsToadlet.l10n("peerVisibility." + trust.name()));
        }
    }

    @Override
    protected String getPeerListTitle() {
        return DarknetConnectionsToadlet.l10n("myFriends");
    }

    @Override
    protected boolean acceptRefPosts() {
        return true;
    }

    @Override
    protected String defaultRedirectLocation() {
        return "/friends/";
    }

    @Override
    protected void handleAltPost(URI uri, HTTPRequest request, ToadletContext ctx, boolean logMINOR) throws ToadletContextClosedException, IOException, RedirectException {
        if (request.isPartSet("doSendMessageToPeers")) {
            PageNode page = ctx.getPageMaker().getPageNode(DarknetConnectionsToadlet.l10n("sendMessageTitle"), ctx);
            HTMLNode contentNode = page.getContentNode();
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            HashMap<String, String> peers = new HashMap<String, String>();
            for (DarknetPeerNode pn : peerNodes) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                String peer_name = pn.getName();
                String peer_hash = String.valueOf(pn.hashCode());
                if (peers.containsKey(peer_hash)) continue;
                peers.put(peer_hash, peer_name);
            }
            N2NTMToadlet.createN2NTMSendForm(ctx.isAdvancedModeEnabled(), contentNode, ctx, peers);
            this.writeHTMLReply(ctx, 200, "OK", page.generate());
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("update_notes")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("peerPrivateNote_" + pn.hashCode()) || request.getPartAsStringFailsafe("peerPrivateNote_" + pn.hashCode(), 250).equals(pn.getPrivateDarknetCommentNote())) continue;
                pn.setPrivateDarknetCommentNote(request.getPartAsStringFailsafe("peerPrivateNote_" + pn.hashCode(), 250));
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("enable")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.enablePeer();
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("disable")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.disablePeer();
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("set_burst_only")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setBurstOnly(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("clear_burst_only")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setBurstOnly(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("set_ignore_source_port")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setIgnoreSourcePort(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("clear_ignore_source_port")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setIgnoreSourcePort(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("clear_dont_route")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setRoutingStatus(true, true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("set_dont_route")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setRoutingStatus(false, true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("set_listen_only")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setListenOnly(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("clear_listen_only")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setListenOnly(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("set_allow_local")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setAllowLocalAddresses(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("clear_allow_local")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setAllowLocalAddresses(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("changeTrust") && request.isPartSet("doChangeTrust")) {
            DarknetPeerNode[] peerNodes;
            DarknetPeerNode.FRIEND_TRUST trust = DarknetPeerNode.FRIEND_TRUST.valueOf(request.getPartAsStringFailsafe("changeTrust", 10));
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setTrustLevel(trust);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("changeVisibility") && request.isPartSet("doChangeVisibility")) {
            DarknetPeerNode[] peerNodes;
            DarknetPeerNode.FRIEND_VISIBILITY trust = DarknetPeerNode.FRIEND_VISIBILITY.valueOf(request.getPartAsStringFailsafe("changeVisibility", 10));
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                pn.setVisibility(trust);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("remove") || request.isPartSet("doAction") && request.getPartAsStringFailsafe("action", 25).equals("remove")) {
            DarknetPeerNode[] peerNodes;
            if (logMINOR) {
                Logger.minor(this, "Remove node");
            }
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (request.isPartSet("node_" + pn.hashCode())) {
                    if (pn.timeLastConnectionCompleted() < System.currentTimeMillis() - 604800000L || pn.peerNodeStatus == 6 || request.isPartSet("forceit")) {
                        this.node.removePeerConnection(pn);
                        if (!logMINOR) continue;
                        Logger.minor(this, "Removed node: node_" + pn.hashCode());
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Refusing to remove : node_" + pn.hashCode() + " (trying to prevent network churn) : let's display the warning message.");
                    }
                    PageNode page = ctx.getPageMaker().getPageNode(DarknetConnectionsToadlet.l10n("confirmRemoveNodeTitle"), ctx);
                    HTMLNode contentNode = page.getContentNode();
                    HTMLNode content = ctx.getPageMaker().getInfobox("infobox-warning", DarknetConnectionsToadlet.l10n("confirmRemoveNodeWarningTitle"), contentNode, "darknet-remove-node", true);
                    content.addChild("p").addChild("#", NodeL10n.getBase().getString("DarknetConnectionsToadlet.confirmRemoveNode", new String[]{"name"}, new String[]{pn.getName()}));
                    HTMLNode removeForm = ctx.addFormChild(content, "/friends/", "removeConfirmForm");
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "node_" + pn.hashCode(), "remove"});
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove", DarknetConnectionsToadlet.l10n("remove")});
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "forceit", DarknetConnectionsToadlet.l10n("forceRemove")});
                    this.writeHTMLReply(ctx, 200, "OK", page.generate());
                    return;
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Part not set: node_" + pn.hashCode());
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("acceptTransfer")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                long id = Long.parseLong(request.getPartAsStringFailsafe("id", 32));
                pn.acceptTransfer(id);
                break;
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("rejectTransfer")) {
            DarknetPeerNode[] peerNodes;
            for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                long id = Long.parseLong(request.getPartAsStringFailsafe("id", 32));
                pn.rejectTransfer(id);
                break;
            }
            this.redirectHere(ctx);
            return;
        }
        this.handleMethodGET(uri, new HTTPRequestImpl(uri, "GET"), ctx);
    }

    private void redirectHere(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = MultiValueTable.from("Location", "/friends/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    @Override
    protected boolean isOpennet() {
        return false;
    }

    @Override
    ConnectionsToadlet.SimpleColumn[] endColumnHeaders(boolean advancedMode) {
        return null;
    }

    @Override
    public String path() {
        return "/friends/";
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (this.tryHandlePeerNoderef(uri, request, ctx)) {
            return;
        }
        super.handleMethodGET(uri, request, ctx);
    }

    private boolean tryHandlePeerNoderef(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String path = uri.getPath();
        if (path.endsWith(".fref") && path.startsWith(this.path() + "friend-")) {
            int input_hashcode;
            String input_hashcode_string = path.substring((this.path() + "friend-").length());
            input_hashcode_string = input_hashcode_string.substring(0, input_hashcode_string.length() - ".fref".length());
            try {
                input_hashcode = Integer.parseInt(input_hashcode_string);
            }
            catch (NumberFormatException e) {
                return false;
            }
            String peernode_name = null;
            SimpleFieldSet fs = null;
            if (input_hashcode != -1) {
                DarknetPeerNode[] peerNodes;
                for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                    int peer_hashcode = pn.hashCode();
                    if (peer_hashcode != input_hashcode) continue;
                    peernode_name = pn.getName();
                    fs = pn.getFullNoderef();
                    break;
                }
            }
            if (fs == null) {
                return false;
            }
            String filename = FileUtil.sanitizeFileNameWithExtras(peernode_name + ".fref", "\" ");
            String content = fs.toString();
            MultiValueTable<String, String> extraHeaders = MultiValueTable.from("Content-Disposition", "attachment; filename=" + filename);
            this.writeReply(ctx, 200, "application/x-freenet-reference", "OK", extraHeaders, content);
            return true;
        }
        return false;
    }

    @Override
    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException, ConfigException {
        super.handleMethodPOST(uri, request, ctx);
    }

    protected class DarknetComparator
    extends ConnectionsToadlet.ComparatorByStatus {
        DarknetComparator(String sortBy, boolean reversed) {
            super(sortBy, reversed);
        }

        @Override
        protected int customCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode, String sortBy) {
            switch (sortBy) {
                case "name": {
                    return ((DarknetPeerNodeStatus)firstNode).getName().compareToIgnoreCase(((DarknetPeerNodeStatus)secondNode).getName());
                }
                case "privnote": {
                    return ((DarknetPeerNodeStatus)firstNode).getPrivateDarknetCommentNote().compareToIgnoreCase(((DarknetPeerNodeStatus)secondNode).getPrivateDarknetCommentNote());
                }
                case "trust": {
                    return ((DarknetPeerNodeStatus)firstNode).getTrustLevel().compareTo(((DarknetPeerNodeStatus)secondNode).getTrustLevel());
                }
                case "visibility": {
                    int ret = ((DarknetPeerNodeStatus)firstNode).getOurVisibility().compareTo(((DarknetPeerNodeStatus)secondNode).getOurVisibility());
                    if (ret != 0) {
                        return ret;
                    }
                    return ((DarknetPeerNodeStatus)firstNode).getTheirVisibility().compareTo(((DarknetPeerNodeStatus)secondNode).getTheirVisibility());
                }
            }
            return super.customCompare(firstNode, secondNode, sortBy);
        }

        @Override
        protected int lastResortCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            return ((DarknetPeerNodeStatus)firstNode).getName().compareToIgnoreCase(((DarknetPeerNodeStatus)secondNode).getName());
        }
    }
}

