/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNode;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.Searcher;

public class BTreeNodeSearchResult {
    private final Transaction _transaction;
    private final BTree _btree;
    private final BTreePointer _pointer;
    private final boolean _foundMatch;

    BTreeNodeSearchResult(Transaction transaction, BTree btree, BTreePointer pointer, boolean foundMatch) {
        if (null == transaction || null == btree) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._btree = btree;
        this._pointer = pointer;
        this._foundMatch = foundMatch;
    }

    BTreeNodeSearchResult(Transaction trans, ByteArrayBuffer nodeReader, BTree btree, BTreeNode node, int cursor, boolean foundMatch) {
        this(trans, btree, BTreeNodeSearchResult.pointerOrNull(trans, nodeReader, node, cursor), foundMatch);
    }

    BTreeNodeSearchResult(Transaction trans, ByteArrayBuffer nodeReader, BTree btree, Searcher searcher, BTreeNode node) {
        this(trans, btree, BTreeNodeSearchResult.nextPointerIf(BTreeNodeSearchResult.pointerOrNull(trans, nodeReader, node, searcher.cursor()), searcher.isGreater()), searcher.foundMatch());
    }

    private static BTreePointer nextPointerIf(BTreePointer pointer, boolean condition) {
        if (null == pointer) {
            return null;
        }
        if (condition) {
            return pointer.next();
        }
        return pointer;
    }

    private static BTreePointer pointerOrNull(Transaction trans, ByteArrayBuffer nodeReader, BTreeNode node, int cursor) {
        return node == null ? null : new BTreePointer(trans, nodeReader, node, cursor);
    }

    public BTreeRange createIncludingRange(BTreeNodeSearchResult end) {
        BTreePointer firstPointer = this.firstValidPointer();
        BTreePointer endPointer = end._foundMatch ? end._pointer.next() : end.firstValidPointer();
        return new BTreeRangeSingle(this._transaction, this._btree, firstPointer, endPointer);
    }

    public BTreePointer firstValidPointer() {
        if (null == this._pointer) {
            return null;
        }
        if (this._pointer.isValid()) {
            return this._pointer;
        }
        return this._pointer.next();
    }
}

