/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.clients.http.wizardsteps.BandwidthLimit;
import freenet.config.InvalidConfigValueException;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.useralerts.UpgradeConnectionSpeedUserAlert;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.support.Logger;
import java.util.concurrent.TimeUnit;

public class BandwidthManager {
    private static final long DELAY_HOURS = 24L;
    private int lastOfferedInputBandwidth;
    private int lastOfferedOutputBandwidth;
    private final Node node;

    BandwidthManager(Node node) {
        this.node = node;
    }

    public void start() {
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                try {
                    FredPluginBandwidthIndicator bandwidthIndicator = BandwidthManager.this.node.getIpDetector().getBandwidthIndicator();
                    if (!BandwidthManager.this.node.getConfig().get("node").getBoolean("connectionSpeedDetection") || bandwidthIndicator == null) {
                        return;
                    }
                    int detectedInputBandwidth = bandwidthIndicator.getDownstreamMaxBitRate() / 8;
                    int detectedOutputBandwidth = bandwidthIndicator.getUpstramMaxBitRate() / 8;
                    int currentInputBandwidth = BandwidthManager.this.node.getConfig().get("node").getInt("inputBandwidthLimit");
                    int currentOutputBandwidth = BandwidthManager.this.node.getConfig().get("node").getInt("outputBandwidthLimit");
                    if (detectedInputBandwidth > currentInputBandwidth * 3 && detectedInputBandwidth > BandwidthManager.this.lastOfferedInputBandwidth * 3 || detectedOutputBandwidth > currentOutputBandwidth * 3 && detectedOutputBandwidth > BandwidthManager.this.lastOfferedOutputBandwidth * 3) {
                        BandwidthManager.this.lastOfferedInputBandwidth = Math.max(detectedInputBandwidth / 2, currentInputBandwidth);
                        BandwidthManager.this.lastOfferedOutputBandwidth = Math.max(detectedOutputBandwidth / 2, currentOutputBandwidth);
                        UpgradeConnectionSpeedUserAlert.createAlert(BandwidthManager.this.node, new BandwidthLimit(BandwidthManager.this.lastOfferedInputBandwidth, BandwidthManager.this.lastOfferedOutputBandwidth, null, false));
                    }
                }
                catch (Exception e) {
                    Logger.minor(this, e.getMessage());
                    throw e;
                }
                finally {
                    BandwidthManager.this.node.getTicker().queueTimedJob(this, TimeUnit.HOURS.toMillis(24L));
                }
            }
        }, TimeUnit.HOURS.toMillis(24L));
    }

    public static void checkOutputBandwidthLimit(int obwLimit) throws InvalidConfigValueException {
        if (obwLimit <= 0) {
            throw new InvalidConfigValueException(NodeL10n.getBase().getString("Node.bwlimitMustBePositive"));
        }
        if (obwLimit < Node.getMinimumBandwidth()) {
            throw BandwidthManager.lowBandwidthLimit(obwLimit);
        }
        if ((long)obwLimit > TimeUnit.SECONDS.toNanos(1L)) {
            throw new InvalidConfigValueException(NodeL10n.getBase().getString("Node.outputBwlimitMustBeLessThan", "max", Long.toString(TimeUnit.SECONDS.toNanos(1L))));
        }
    }

    public static void checkInputBandwidthLimit(int ibwLimit) throws InvalidConfigValueException {
        if (ibwLimit == -1) {
            return;
        }
        if (ibwLimit <= 1) {
            throw new InvalidConfigValueException(NodeL10n.getBase().getString("Node.bandwidthLimitMustBePositiveOrMinusOne"));
        }
        if (ibwLimit < Node.getMinimumBandwidth()) {
            throw BandwidthManager.lowBandwidthLimit(ibwLimit);
        }
    }

    private static InvalidConfigValueException lowBandwidthLimit(int limit) {
        return new InvalidConfigValueException(NodeL10n.getBase().getString("Node.bandwidthMinimum", new String[]{"limit", "minimum"}, new String[]{Integer.toString(limit), Integer.toString(Node.getMinimumBandwidth())}));
    }
}

