/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.RetrievalException;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.node.PeerNode;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.support.BitArray;
import freenet.support.Buffer;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;
import freenet.support.math.RunningAverage;
import freenet.support.math.TrivialRunningAverage;
import java.util.concurrent.TimeUnit;

public class BlockReceiver
implements AsyncMessageFilterCallback {
    private static volatile boolean logMINOR;
    public final long RECEIPT_TIMEOUT;
    public static final long RECEIPT_TIMEOUT_REALTIME;
    public static final long RECEIPT_TIMEOUT_BULK;
    public final long MAX_ROUND_TRIP_TIME;
    public static final int MAX_CONSECUTIVE_MISSING_PACKET_REPORTS = 4;
    public static final int MAX_SEND_INTERVAL = 500;
    public static final long CLEANUP_TIMEOUT;
    public static final long TOO_LONG_TIMEOUT;
    public static final long ACK_TRANSFER_FAILED_TIMEOUT;
    PartiallyReceivedBlock _prb;
    PeerContext _sender;
    long _uid;
    MessageCore _usm;
    ByteCounter _ctr;
    Ticker _ticker;
    boolean sentAborted;
    private MessageFilter discardFilter;
    private long discardEndTime;
    private boolean senderAborted;
    private final boolean _realTime;
    private final BlockReceiverTimeoutHandler _timeoutHandler;
    private final boolean completeAfterAckedAllReceived;
    private BlockReceiverCompletion callback;
    private long startTime;
    static final boolean CHECK_DUPES = true;
    private boolean gotAllSent;
    private AsyncMessageFilterCallback notificationWaiter = new SlowAsyncMessageFilterCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onMatched(Message m1) {
            block37: {
                if (BlockReceiver.access$000()) {
                    Logger.minor(this, "Received " + m1);
                }
                if (m1 != null && m1.getSpec().equals(DMT.sendAborted)) {
                    desc = m1.getString("description");
                    if (!desc.contains("Upstream")) {
                        desc = "Upstream transmit error: " + desc;
                    }
                    BlockReceiver.this._prb.abort(m1.getInt("reason"), desc, false);
                    var3_4 = BlockReceiver.this;
                    synchronized (var3_4) {
                        BlockReceiver.access$102(BlockReceiver.this, true);
                    }
                    BlockReceiver.access$200(BlockReceiver.this, m1.getInt("reason"), desc);
                    return;
                }
                truncateTimeout = false;
                if (m1 != null && m1.getSpec().equals(DMT.packetTransmit)) {
                    packetNo = m1.getInt("packetNo");
                    sent = (BitArray)m1.getObject("sent");
                    data = (Buffer)m1.getObject("data");
                    missing = 0;
                    try {
                        var7_18 = BlockReceiver.this;
                        synchronized (var7_18) {
                            if (BlockReceiver.access$300(BlockReceiver.this)) {
                                return;
                            }
                        }
                        if (BlockReceiver.this._prb.isReceived(packetNo)) {
                            Logger.error(this, "Already received the packet - DoS??? on " + this + " uid " + BlockReceiver.this._uid + " from " + BlockReceiver.this._sender);
                            truncateTimeout = true;
                        }
                        BlockReceiver.this._prb.addPacket(packetNo, data);
                        if (BlockReceiver.access$000()) {
                            var7_18 = BlockReceiver.this;
                            synchronized (var7_18) {
                                interval = System.currentTimeMillis() - BlockReceiver.access$400(BlockReceiver.this);
                                Logger.minor(this, "Packet interval: " + interval + " = " + TimeUtil.formatTime(interval, 2, true) + " from " + BlockReceiver.this._sender);
                            }
                        }
                        for (x = 0; x < sent.getSize(); ++x) {
                            if (!sent.bitAt(x) || BlockReceiver.this._prb.isReceived(x)) continue;
                            ++missing;
                        }
                        if (!BlockReceiver.access$000() || missing == 0) ** GOTO lbl72
                        Logger.minor(this, "Packets which the sender says it has sent but we have not received: " + missing);
                    }
                    catch (AbortedException e) {
                        Logger.error(this, "Caught in receive - probably a bug as receive sets it: " + e, (Throwable)e);
                        BlockReceiver.access$200(BlockReceiver.this, 0, "Aborted?");
                        return;
                    }
                } else if (m1 != null && m1.getSpec().equals(DMT.allSent)) {
                    packetNo = BlockReceiver.this;
                    synchronized (packetNo) {
                        if (BlockReceiver.access$300(BlockReceiver.this)) {
                            return;
                        }
                        if (BlockReceiver.access$500(BlockReceiver.this)) {
                            truncateTimeout = true;
                        }
                        BlockReceiver.access$502(BlockReceiver.this, true);
                    }
                }
lbl72:
                // 6 sources

                try {
                    block38: {
                        if (!BlockReceiver.this._prb.allReceived()) break block37;
                        try {
                            m = DMT.createAllReceived(BlockReceiver.this._uid);
                            if (BlockReceiver.access$600(BlockReceiver.this)) {
                                try {
                                    ((PeerNode)BlockReceiver.this._sender).sendSync(m, BlockReceiver.this._ctr, BlockReceiver.access$700(BlockReceiver.this));
                                }
                                catch (SyncSendWaitedTooLongException var4_14) {}
                            } else {
                                BlockReceiver.this._usm.send(BlockReceiver.this._sender, m, BlockReceiver.this._ctr);
                            }
                            BlockReceiver.access$802(BlockReceiver.this, System.currentTimeMillis() + BlockReceiver.CLEANUP_TIMEOUT);
                            BlockReceiver.access$902(BlockReceiver.this, BlockReceiver.access$1000(BlockReceiver.this, BlockReceiver.CLEANUP_TIMEOUT));
                            BlockReceiver.access$1100(BlockReceiver.this);
                        }
                        catch (NotConnectedException e1) {
                            if (!BlockReceiver.access$000()) break block38;
                            Logger.minor(this, "Got data but can't send allReceived to " + BlockReceiver.this._sender + " as is disconnected");
                        }
                    }
                    endTime = System.currentTimeMillis();
                    transferTime = endTime - BlockReceiver.access$1200(BlockReceiver.this);
                    if (BlockReceiver.access$000()) {
                        BlockReceiver.access$1300().report(transferTime);
                        Logger.minor(this, "Block transfer took " + transferTime + "ms - average is " + BlockReceiver.access$1300().currentValue());
                    }
                    BlockReceiver.access$1400(BlockReceiver.this, BlockReceiver.this._prb.getBlock());
                    return;
                }
                catch (AbortedException e1) {
                    Logger.error(this, "Caught in receive - probably a bug as receive sets it: " + e1, (Throwable)e1);
                    BlockReceiver.access$200(BlockReceiver.this, 0, "Aborted?");
                    return;
                }
            }
            try {
                BlockReceiver.access$1500(BlockReceiver.this, truncateTimeout);
            }
            catch (DisconnectedException e) {
                this.onDisconnect(null);
                return;
            }
        }

        @Override
        public boolean shouldTimeout() {
            return BlockReceiver.this.completed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            3 var1_1 = this;
            synchronized (var1_1) {
                if (BlockReceiver.this.completed) {
                    return;
                }
            }
            try {
                if (BlockReceiver.this._prb.allReceived()) {
                    return;
                }
                BlockReceiver.this._prb.abort(5, "Sender unresponsive to resend requests", false);
                BlockReceiver.this.complete(5, "Sender unresponsive to resend requests");
                BlockReceiver.this._timeoutHandler.onFirstTimeout();
                MessageFilter mfSendAborted = MessageFilter.create().setTimeout(ACK_TRANSFER_FAILED_TIMEOUT).setType(DMT.sendAborted).setField("uid", BlockReceiver.this._uid).setSource(BlockReceiver.this._sender);
                try {
                    BlockReceiver.this._usm.addAsyncFilter(mfSendAborted, new SlowAsyncMessageFilterCallback(){

                        @Override
                        public void onMatched(Message m) {
                            if (logMINOR) {
                                Logger.minor(this, "Transfer cancel acknowledged");
                            }
                        }

                        @Override
                        public boolean shouldTimeout() {
                            return false;
                        }

                        @Override
                        public void onTimeout() {
                            Logger.error(this, "Other side did not acknowlege transfer failure on " + BlockReceiver.this);
                            BlockReceiver.this._timeoutHandler.onFatalTimeout(BlockReceiver.this._sender);
                        }

                        @Override
                        public void onDisconnect(PeerContext ctx) {
                        }

                        @Override
                        public void onRestarted(PeerContext ctx) {
                        }

                        @Override
                        public int getPriority() {
                            return NativeThread.NORM_PRIORITY;
                        }
                    }, BlockReceiver.this._ctr);
                }
                catch (DisconnectedException disconnectedException) {
                    // empty catch block
                }
                return;
            }
            catch (AbortedException e) {
                Logger.error(this, "Caught in receive - probably a bug as receive sets it: " + e, (Throwable)e);
                BlockReceiver.this.complete(0, "Aborted?");
                return;
            }
        }

        @Override
        public void onDisconnect(PeerContext ctx) {
            BlockReceiver.this.complete(7, RetrievalException.getErrString(7));
        }

        @Override
        public void onRestarted(PeerContext ctx) {
            BlockReceiver.this.complete(7, RetrievalException.getErrString(7));
        }

        @Override
        public int getPriority() {
            return NativeThread.NORM_PRIORITY;
        }
    };
    private boolean completed;
    private long timeStartedWaiting = -1L;
    PartiallyReceivedBlock.PacketReceivedListener myListener;
    private static final RunningAverage avgTimeTaken;
    static int runningBlockReceives;

    public BlockReceiver(MessageCore usm, PeerContext sender, long uid, PartiallyReceivedBlock prb, ByteCounter ctr, Ticker ticker, boolean doTooLong, boolean realTime, BlockReceiverTimeoutHandler timeoutHandler, boolean completeAfterAckedAllReceived) {
        BlockReceiverTimeoutHandler nullTimeoutHandler = new BlockReceiverTimeoutHandler(){

            @Override
            public void onFirstTimeout() {
            }

            @Override
            public void onFatalTimeout(PeerContext source) {
            }
        };
        this._timeoutHandler = timeoutHandler == null ? nullTimeoutHandler : timeoutHandler;
        this._sender = sender;
        this._prb = prb;
        this._uid = uid;
        this._usm = usm;
        this._ctr = ctr;
        this._ticker = ticker;
        this._realTime = realTime;
        this.completeAfterAckedAllReceived = completeAfterAckedAllReceived;
        this.MAX_ROUND_TRIP_TIME = this.RECEIPT_TIMEOUT = this._realTime ? RECEIPT_TIMEOUT_REALTIME : RECEIPT_TIMEOUT_BULK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAborted(int reason, String desc) throws NotConnectedException {
        BlockReceiver blockReceiver = this;
        synchronized (blockReceiver) {
            if (this.sentAborted) {
                return;
            }
            this.sentAborted = true;
        }
        this._usm.send(this._sender, DMT.createSendAborted(this._uid, reason, desc), this._ctr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(int reason, String description) {
        BlockReceiver blockReceiver = this;
        synchronized (blockReceiver) {
            if (this.completed) {
                if (logMINOR) {
                    Logger.minor(this, "Already completed");
                }
                return;
            }
            this.completed = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Transfer failed: (" + (this._realTime ? "realtime" : "bulk") + ") " + reason + " : " + description + " on " + this._uid + " from " + this._sender);
        }
        this._prb.removeListener(this.myListener);
        byte[] block = this._prb.abort(reason, description, false);
        if (block == null) {
            try {
                this.sendAborted(this._prb._abortReason, this._prb._abortDescription);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
            this.callback.blockReceiveFailed(new RetrievalException(reason, description));
        } else {
            Logger.error(this, "Succeeded in complete(" + reason + "," + description + ") on " + this, (Throwable)new Exception("error"));
            this.callback.blockReceived(block);
        }
        this.decRunningBlockReceives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(byte[] ret) {
        BlockReceiver blockReceiver = this;
        synchronized (blockReceiver) {
            if (this.completed) {
                if (logMINOR) {
                    Logger.minor(this, "Already completed");
                }
                return;
            }
            this.completed = true;
        }
        this._prb.removeListener(this.myListener);
        this.callback.blockReceived(ret);
        this.decRunningBlockReceives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitNotification(boolean truncateTimeout) throws DisconnectedException {
        long timeout;
        long now = System.currentTimeMillis();
        BlockReceiver blockReceiver = this;
        synchronized (blockReceiver) {
            if (truncateTimeout) {
                timeout = (int)Math.min(this.timeStartedWaiting + this.RECEIPT_TIMEOUT - now, this.RECEIPT_TIMEOUT);
            } else {
                this.timeStartedWaiting = now;
                timeout = this.RECEIPT_TIMEOUT;
            }
        }
        this._usm.addAsyncFilter(this.relevantMessages(timeout), this.notificationWaiter, this._ctr);
    }

    private MessageFilter relevantMessages(long timeout) {
        MessageFilter mfPacketTransmit = MessageFilter.create().setTimeout(timeout).setType(DMT.packetTransmit).setField("uid", this._uid).setSource(this._sender);
        MessageFilter mfAllSent = MessageFilter.create().setTimeout(timeout).setType(DMT.allSent).setField("uid", this._uid).setSource(this._sender);
        MessageFilter mfSendAborted = MessageFilter.create().setTimeout(timeout).setType(DMT.sendAborted).setField("uid", this._uid).setSource(this._sender);
        return mfSendAborted.or(mfAllSent.or(mfPacketTransmit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(BlockReceiverCompletion callback) {
        this.startTime = System.currentTimeMillis();
        this.callback = callback;
        PartiallyReceivedBlock partiallyReceivedBlock = this._prb;
        synchronized (partiallyReceivedBlock) {
            try {
                this.myListener = new PartiallyReceivedBlock.PacketReceivedListener(){

                    @Override
                    public void packetReceived(int packetNo) {
                    }

                    @Override
                    public void receiveAborted(int reason, String description) {
                        BlockReceiver.this.complete(reason, description);
                    }
                };
                this._prb.addListener(this.myListener);
            }
            catch (AbortedException e) {
                try {
                    callback.blockReceived(this._prb.getBlock());
                    return;
                }
                catch (AbortedException e1) {
                    e = e1;
                    callback.blockReceiveFailed(new RetrievalException(this._prb._abortReason, this._prb._abortDescription));
                    return;
                }
            }
        }
        this.incRunningBlockReceives();
        try {
            this.waitNotification(false);
        }
        catch (DisconnectedException e) {
            RetrievalException retrievalException = new RetrievalException(7);
            this._prb.abort(retrievalException.getReason(), retrievalException.toString(), true);
            callback.blockReceiveFailed(retrievalException);
            this.decRunningBlockReceives();
        }
        catch (RuntimeException e) {
            this.decRunningBlockReceives();
            throw e;
        }
        catch (Error e) {
            this.decRunningBlockReceives();
            throw e;
        }
    }

    private void maybeResetDiscardFilter() {
        long timeleft = this.discardEndTime - System.currentTimeMillis();
        if (timeleft > 0L) {
            try {
                this.discardFilter.setTimeout((int)timeleft);
                this._usm.addAsyncFilter(this.discardFilter, this, this._ctr);
            }
            catch (DisconnectedException disconnectedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onMatched(Message m) {
        if (logMINOR) {
            Logger.minor(this, "discarding message post-receive: " + m);
        }
        this.maybeResetDiscardFilter();
    }

    @Override
    public boolean shouldTimeout() {
        return false;
    }

    @Override
    public void onTimeout() {
    }

    @Override
    public void onDisconnect(PeerContext ctx) {
    }

    @Override
    public void onRestarted(PeerContext ctx) {
    }

    public synchronized boolean senderAborted() {
        return this.senderAborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incRunningBlockReceives() {
        if (logMINOR) {
            Logger.minor(this, "Starting block receive " + this._uid);
        }
        Class<BlockReceiver> clazz = BlockReceiver.class;
        synchronized (BlockReceiver.class) {
            ++runningBlockReceives;
            if (logMINOR) {
                Logger.minor(BlockTransmitter.class, "Started a block receive, running: " + runningBlockReceives);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decRunningBlockReceives() {
        if (logMINOR) {
            Logger.minor(this, "Stopping block receive " + this._uid);
        }
        Class<BlockReceiver> clazz = BlockReceiver.class;
        synchronized (BlockReceiver.class) {
            --runningBlockReceives;
            if (logMINOR) {
                Logger.minor(BlockTransmitter.class, "Finished a block receive, running: " + runningBlockReceives);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized int getRunningReceives() {
        return runningBlockReceives;
    }

    public String toString() {
        return super.toString() + ":" + this._uid + ":" + this._sender.shortToString();
    }

    static /* synthetic */ boolean access$102(BlockReceiver x0, boolean x1) {
        x0.senderAborted = x1;
        return x0.senderAborted;
    }

    static /* synthetic */ long access$400(BlockReceiver x0) {
        return x0.timeStartedWaiting;
    }

    static /* synthetic */ boolean access$500(BlockReceiver x0) {
        return x0.gotAllSent;
    }

    static /* synthetic */ boolean access$502(BlockReceiver x0, boolean x1) {
        x0.gotAllSent = x1;
        return x0.gotAllSent;
    }

    static /* synthetic */ boolean access$600(BlockReceiver x0) {
        return x0.completeAfterAckedAllReceived;
    }

    static /* synthetic */ boolean access$700(BlockReceiver x0) {
        return x0._realTime;
    }

    static /* synthetic */ long access$802(BlockReceiver x0, long x1) {
        x0.discardEndTime = x1;
        return x0.discardEndTime;
    }

    static /* synthetic */ MessageFilter access$902(BlockReceiver x0, MessageFilter x1) {
        x0.discardFilter = x1;
        return x0.discardFilter;
    }

    static /* synthetic */ MessageFilter access$1000(BlockReceiver x0, long x1) {
        return x0.relevantMessages(x1);
    }

    static /* synthetic */ void access$1100(BlockReceiver x0) {
        x0.maybeResetDiscardFilter();
    }

    static /* synthetic */ long access$1200(BlockReceiver x0) {
        return x0.startTime;
    }

    static /* synthetic */ RunningAverage access$1300() {
        return avgTimeTaken;
    }

    static /* synthetic */ void access$1400(BlockReceiver x0, byte[] x1) {
        x0.complete(x1);
    }

    static /* synthetic */ void access$1500(BlockReceiver x0, boolean x1) throws DisconnectedException {
        x0.waitNotification(x1);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        RECEIPT_TIMEOUT_REALTIME = TimeUnit.SECONDS.toMillis(10L);
        RECEIPT_TIMEOUT_BULK = TimeUnit.SECONDS.toMillis(30L);
        CLEANUP_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
        TOO_LONG_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
        ACK_TRANSFER_FAILED_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
        avgTimeTaken = new TrivialRunningAverage();
        runningBlockReceives = 0;
    }

    public static interface BlockReceiverCompletion {
        public void blockReceived(byte[] var1);

        public void blockReceiveFailed(RetrievalException var1);
    }

    public static interface BlockReceiverTimeoutHandler {
        public void onFirstTimeout();

        public void onFatalTimeout(PeerContext var1);
    }
}

