/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.RIFFFilter;
import freenet.l10n.NodeL10n;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class WAVFilter
extends RIFFFilter {
    private final int WAVE_FORMAT_UNKNOWN = 0;
    private final int WAVE_FORMAT_PCM = 1;
    private final int WAVE_FORMAT_IEEE_FLOAT = 3;
    private final int WAVE_FORMAT_ALAW = 6;
    private final int WAVE_FORMAT_MULAW = 7;
    private final int FMT_SIZE_BASIC = 16;
    private final int FMT_SIZE_cbSize = 18;
    private final int FMT_SIZE_cbSize_extension = 40;

    @Override
    protected byte[] getChunkMagicNumber() {
        return new byte[]{87, 65, 86, 69};
    }

    @Override
    protected Object createContext() {
        return new WAVFilterContext();
    }

    @Override
    protected void readFilterChunk(byte[] ID, int size, Object context, DataInputStream input, DataOutputStream output, String charset, Map<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        WAVFilterContext ctx = (WAVFilterContext)context;
        if (ID[0] == 102 && ID[1] == 109 && ID[2] == 116 && ID[3] == 32) {
            if (ctx.hasfmt) {
                throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "Unexpected fmt chunk was encountered");
            }
            if (size != 16 && size != 18 && size != 40) {
                throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "fmt chunk size is invalid");
            }
            ctx.format = Short.reverseBytes(input.readShort());
            if (ctx.format != 1 && ctx.format != 3 && ctx.format != 6 && ctx.format != 7) {
                throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "WAV file uses a not yet supported format");
            }
            ctx.nChannels = Short.reverseBytes(input.readShort());
            output.write(ID);
            WAVFilter.writeLittleEndianInt(output, size);
            output.writeInt(Short.reverseBytes((short)ctx.format) << 16 | Short.reverseBytes((short)ctx.nChannels));
            ctx.nSamplesPerSec = WAVFilter.readLittleEndianInt(input);
            WAVFilter.writeLittleEndianInt(output, ctx.nSamplesPerSec);
            int nAvgBytesPerSec = WAVFilter.readLittleEndianInt(input);
            WAVFilter.writeLittleEndianInt(output, nAvgBytesPerSec);
            ctx.nBlockAlign = Short.reverseBytes(input.readShort());
            ctx.wBitsPerSample = Short.reverseBytes(input.readShort());
            output.writeInt(Short.reverseBytes((short)ctx.nBlockAlign) << 16 | Short.reverseBytes((short)ctx.wBitsPerSample));
            ctx.hasfmt = true;
            if (size > 16) {
                short cbSize = Short.reverseBytes(input.readShort());
                if (cbSize + 18 != size) {
                    throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "fmt chunk size is invalid");
                }
                output.writeShort(Short.reverseBytes(cbSize));
            }
            if (size > 18) {
                this.passthroughBytes(input, output, 22);
            }
            if ((ctx.format == 6 || ctx.format == 7) && ctx.wBitsPerSample != 8) {
                throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "Unexpected bits per sample value");
            }
            return;
        }
        if (!ctx.hasfmt) {
            throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "Unexpected header chunk was encountered, instead of fmt chunk");
        }
        if (ID[0] == 100 && ID[1] == 97 && ID[2] == 116 && ID[3] == 97) {
            output.write(ID);
            WAVFilter.writeLittleEndianInt(output, size);
            this.passthroughBytes(input, output, size);
            if ((size & 1) != 0) {
                output.writeByte(input.readByte());
            }
            ctx.hasdata = true;
        } else if (ID[0] == 102 && ID[1] == 97 && ID[2] == 99 && ID[3] == 116) {
            if (size != 4) {
                this.writeJunkChunk(input, output, size);
            } else {
                output.write(ID);
                WAVFilter.writeLittleEndianInt(output, size);
                this.passthroughBytes(input, output, size);
            }
        } else {
            this.writeJunkChunk(input, output, size);
        }
    }

    @Override
    protected void EOFCheck(Object context) throws DataFilterException {
        WAVFilterContext ctx = (WAVFilterContext)context;
        if (!ctx.hasfmt || !ctx.hasdata) {
            throw new DataFilterException(WAVFilter.l10n("invalidTitle"), WAVFilter.l10n("invalidTitle"), "WAV file is missing fmt chunk or data chunk");
        }
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("WAVFilter." + key);
    }

    private static final class WAVFilterContext {
        boolean hasfmt = false;
        boolean hasdata = false;
        int nSamplesPerSec = 0;
        int nChannels = 0;
        int nBlockAlign = 0;
        int wBitsPerSample = 0;
        int format = 0;

        private WAVFilterContext() {
        }
    }
}

