/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.node.Location;
import freenet.node.NodeStarter;
import java.util.function.Supplier;

public class HealingDecisionSupplier {
    private final Supplier<Double> currentNodeLocation;
    private final Supplier<Boolean> isOpennetEnabled;
    private final Supplier<Double> randomNumberSupplier;

    public HealingDecisionSupplier(Supplier<Double> currentNodeLocation, Supplier<Boolean> isOpennetEnabled) {
        this.currentNodeLocation = currentNodeLocation;
        this.isOpennetEnabled = isOpennetEnabled;
        this.randomNumberSupplier = NodeStarter.getGlobalSecureRandom()::nextDouble;
    }

    HealingDecisionSupplier(Supplier<Double> currentNodeLocation, Supplier<Boolean> isOpennetEnabled, Supplier<Double> randomNumberSupplier) {
        this.currentNodeLocation = currentNodeLocation;
        this.isOpennetEnabled = isOpennetEnabled;
        this.randomNumberSupplier = randomNumberSupplier;
    }

    public boolean shouldHeal(double keyLocation) {
        if (!this.isOpennetEnabled.get().booleanValue()) {
            return true;
        }
        double randomBetweenZeroAndOne = this.randomNumberSupplier.get();
        return HealingDecisionSupplier.shouldHealBlock(this.currentNodeLocation.get(), keyLocation, randomBetweenZeroAndOne);
    }

    private static boolean shouldHealBlock(double nodeLocation, double keyLocation, double randomBetweenZeroAndOne) {
        double distanceToNodeLocation = Location.distance(nodeLocation, keyLocation);
        if (distanceToNodeLocation < 0.1) {
            double randomToPower4 = Math.pow(randomBetweenZeroAndOne, 4.0);
            return distanceToNodeLocation < randomToPower4;
        }
        return randomBetweenZeroAndOne > 0.9;
    }
}

