/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.math.RunningAverage;
import java.util.concurrent.atomic.AtomicReference;

public final class TrivialRunningAverage
implements RunningAverage,
Cloneable {
    private final AtomicReference<Data> data = new AtomicReference();

    public TrivialRunningAverage(TrivialRunningAverage other) {
        this.data.set(other.data.get());
    }

    public TrivialRunningAverage() {
        this.data.set(new Data(0L, 0.0));
    }

    @Override
    public long countReports() {
        return this.data.get().reports;
    }

    public double totalValue() {
        return this.data.get().total;
    }

    @Override
    public double currentValue() {
        return this.data.get().getRunningAverage();
    }

    @Override
    public void report(double d) {
        this.data.updateAndGet(data -> data.updated(d));
    }

    @Override
    public void report(long d) {
        this.report((double)d);
    }

    @Override
    public double valueIfReported(double r) {
        return this.data.get().updated(r).getRunningAverage();
    }

    @Override
    public TrivialRunningAverage clone() {
        return new TrivialRunningAverage(this);
    }

    private static class Data {
        private final long reports;
        private final double total;

        Data(long reports, double total) {
            this.reports = reports;
            this.total = total;
        }

        Data updated(double d) {
            return new Data(this.reports + 1L, d + this.total);
        }

        double getRunningAverage() {
            return this.total / (double)this.reports;
        }
    }
}

