/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.Bzip2Compressor;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.CompressionRatioException;
import freenet.support.compress.GzipCompressor;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.compress.NewLZMACompressor;
import freenet.support.compress.OldLZMACompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public interface Compressor {
    public static final String DEFAULT_COMPRESSORDESCRIPTOR = null;

    public Bucket compress(Bucket var1, BucketFactory var2, long var3, long var5) throws IOException, CompressionOutputSizeException;

    public long compress(InputStream var1, OutputStream var2, long var3, long var5) throws IOException, CompressionOutputSizeException;

    public long compress(InputStream var1, OutputStream var2, long var3, long var5, long var7, int var9) throws IOException, CompressionRatioException;

    public long decompress(InputStream var1, OutputStream var2, long var3, long var5) throws IOException, CompressionOutputSizeException;

    public int decompress(byte[] var1, int var2, int var3, byte[] var4) throws CompressionOutputSizeException;

    public static enum COMPRESSOR_TYPE implements Compressor
    {
        GZIP("GZIP", new GzipCompressor(), 0),
        BZIP2("BZIP2", new Bzip2Compressor(), 1),
        LZMA("LZMA", new OldLZMACompressor(), 2),
        LZMA_NEW("LZMA_NEW", new NewLZMACompressor(), 3);

        public final String name;
        public final Compressor compressor;
        public final short metadataID;
        private static final COMPRESSOR_TYPE[] values;

        private COMPRESSOR_TYPE(String name, Compressor c, short metadataID) {
            this.name = name;
            this.compressor = c;
            this.metadataID = metadataID;
        }

        public static COMPRESSOR_TYPE getCompressorByMetadataID(short id) {
            for (COMPRESSOR_TYPE current : values) {
                if (current.metadataID != id) continue;
                return current;
            }
            return null;
        }

        public static COMPRESSOR_TYPE getCompressorByName(String name) {
            for (COMPRESSOR_TYPE current : values) {
                if (!current.name.equals(name)) continue;
                return current;
            }
            return null;
        }

        public static String getHelloCompressorDescriptor() {
            StringBuilder sb = new StringBuilder();
            sb.append(values.length);
            sb.append(" - ");
            COMPRESSOR_TYPE.getCompressorDescriptor(sb);
            return sb.toString();
        }

        public static String getCompressorDescriptor() {
            StringBuilder sb = new StringBuilder();
            COMPRESSOR_TYPE.getCompressorDescriptor(sb);
            return sb.toString();
        }

        public static void getCompressorDescriptor(StringBuilder sb) {
            boolean isfirst = true;
            for (COMPRESSOR_TYPE current : values) {
                if (isfirst) {
                    isfirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(current.name);
                sb.append('(');
                sb.append(current.metadataID);
                sb.append(')');
            }
        }

        public static COMPRESSOR_TYPE[] getCompressorsArray(String compressordescriptor) throws InvalidCompressionCodecException {
            COMPRESSOR_TYPE[] result = COMPRESSOR_TYPE.getCompressorsArrayNoDefault(compressordescriptor);
            if (result == null) {
                COMPRESSOR_TYPE[] ret = new COMPRESSOR_TYPE[values.length - 1];
                int x = 0;
                for (COMPRESSOR_TYPE v : values) {
                    if (v == LZMA) {
                        COMPRESSOR_TYPE.logLzmaOldRemovedWarning();
                        continue;
                    }
                    ret[x++] = v;
                }
                result = ret;
            }
            return result;
        }

        public static COMPRESSOR_TYPE[] getCompressorsArrayNoDefault(String compressordescriptor) throws InvalidCompressionCodecException {
            if (compressordescriptor == null) {
                return null;
            }
            if (compressordescriptor.trim().isEmpty()) {
                return null;
            }
            String[] codecs = compressordescriptor.split(",");
            ArrayList<COMPRESSOR_TYPE> result = new ArrayList<COMPRESSOR_TYPE>(codecs.length);
            for (String codec : codecs) {
                COMPRESSOR_TYPE ct = COMPRESSOR_TYPE.getCompressorByName(codec = codec.trim());
                if (ct == null) {
                    try {
                        ct = COMPRESSOR_TYPE.getCompressorByMetadataID(Short.parseShort(codec));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (ct == null) {
                    throw new InvalidCompressionCodecException("Unknown compression codec identifier: '" + codec + "'");
                }
                if (result.contains(ct)) {
                    throw new InvalidCompressionCodecException("Duplicate compression codec identifier: '" + codec + "'");
                }
                result.add(ct);
                if (!result.contains(LZMA)) continue;
                Logger.warning(Compressor.class, "OldLZMA compression is buggy and no longer supported. It only exists to allow reinserting old keys.");
                if (result.size() <= 1) continue;
                COMPRESSOR_TYPE.logLzmaOldRemovedWarning();
                result.remove(LZMA);
            }
            return result.toArray(new COMPRESSOR_TYPE[0]);
        }

        private static void logLzmaOldRemovedWarning() {
            Logger.warning(Compressor.class, "Codecs to choose contained ''LZMA'' along others. It was ignored. Please replace it with LZMA_NEW.");
        }

        @Override
        public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
            return this.compressor.compress(data, bf, maxReadLength, maxWriteLength);
        }

        @Override
        public long compress(InputStream is, OutputStream os, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
            return this.compressor.compress(is, os, maxReadLength, maxWriteLength);
        }

        @Override
        public long compress(InputStream is, OutputStream os, long maxReadLength, long maxWriteLength, long amountOfDataToCheckCompressionRatio, int minimumCompressionPercentage) throws IOException, CompressionRatioException {
            return this.compressor.compress(is, os, maxReadLength, maxWriteLength, amountOfDataToCheckCompressionRatio, minimumCompressionPercentage);
        }

        @Override
        public long decompress(InputStream input, OutputStream output, long maxLength, long maxEstimateSizeLength) throws IOException, CompressionOutputSizeException {
            return this.compressor.decompress(input, output, maxLength, maxEstimateSizeLength);
        }

        @Override
        public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
            return this.compressor.decompress(dbuf, i, j, output);
        }

        public static int countCompressors() {
            return values.length;
        }

        static {
            values = COMPRESSOR_TYPE.values();
        }
    }
}

