/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.RandomSource;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.PeerNode;
import freenet.node.PeerTooOldException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class RealNodeTest {
    static final int EXIT_BASE = 1024;
    static final int EXIT_CANNOT_DELETE_OLD_DATA = 1027;
    static final int EXIT_PING_TARGET_NOT_REACHED = 1028;
    static final int EXIT_INSERT_FAILED = 1029;
    static final int EXIT_REQUEST_FAILED = 1030;
    static final int EXIT_BAD_DATA = 1031;
    static final DarknetPeerNode.FRIEND_TRUST trust = DarknetPeerNode.FRIEND_TRUST.LOW;
    static final DarknetPeerNode.FRIEND_VISIBILITY visibility = DarknetPeerNode.FRIEND_VISIBILITY.NO;
    private static volatile boolean logMINOR;

    static void makeKleinbergNetwork(Node[] nodes, boolean idealLocations, int degree, boolean forceNeighbourConnections, RandomSource random) {
        if (idealLocations) {
            double div = 1.0 / (double)nodes.length;
            double loc = 0.0;
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i].setLocation(loc);
                loc += div;
            }
        }
        if (forceNeighbourConnections) {
            for (int i = 0; i < nodes.length; ++i) {
                int next = (i + 1) % nodes.length;
                RealNodeTest.connect(nodes[i], nodes[next]);
            }
        }
        for (int i = 0; i < nodes.length; ++i) {
            Node b;
            Node a = nodes[i];
            double norm = 0.0;
            for (int j = 0; j < nodes.length; ++j) {
                b = nodes[j];
                if (a.getLocation() == b.getLocation()) continue;
                norm += 1.0 / RealNodeTest.distance(a, b);
            }
            block4: for (int k = 0; k < nodes.length; ++k) {
                b = nodes[k];
                if (a.getLocation() == b.getLocation()) continue;
                double p = 1.0 / RealNodeTest.distance(a, b) / norm;
                for (int n = 0; n < degree / 2; ++n) {
                    if (!((double)random.nextFloat() < p)) continue;
                    RealNodeTest.connect(a, b);
                    continue block4;
                }
            }
        }
    }

    static void connect(Node a, Node b) {
        try {
            a.connect(b, trust, visibility);
            b.connect(a, trust, visibility);
        }
        catch (FSParseException e) {
            Logger.error(RealNodeTest.class, "cannot connect!!!!", (Throwable)e);
        }
        catch (PeerParseException e) {
            Logger.error(RealNodeTest.class, "cannot connect #2!!!!", (Throwable)e);
        }
        catch (ReferenceSignatureVerificationException e) {
            Logger.error(RealNodeTest.class, "cannot connect #3!!!!", (Throwable)e);
        }
        catch (PeerTooOldException e) {
            Logger.error(RealNodeTest.class, "cannot connect #4!!!!", (Throwable)e);
        }
    }

    static double distance(Node a, Node b) {
        double aL = a.getLocation();
        double bL = b.getLocation();
        return Location.distance(aL, bL);
    }

    static String getPortNumber(PeerNode p) {
        if (p == null || p.getPeer() == null) {
            return "null";
        }
        return Integer.toString(p.getPeer().getPort());
    }

    static String getPortNumber(Node n) {
        if (n == null) {
            return "null";
        }
        return Integer.toString(n.getDarknetPortNumber());
    }

    static void waitForAllConnected(Node[] nodes) throws InterruptedException {
        long tStart = System.currentTimeMillis();
        while (true) {
            int countFullyConnected = 0;
            int countReallyConnected = 0;
            int totalPeers = 0;
            int totalConnections = 0;
            int totalPartialConnections = 0;
            int totalCompatibleConnections = 0;
            int totalBackedOff = 0;
            double totalPingTime = 0.0;
            double maxPingTime = 0.0;
            double minPingTime = Double.MAX_VALUE;
            for (int i = 0; i < nodes.length; ++i) {
                int countConnected = nodes[i].getPeers().countConnectedDarknetPeers();
                int countAlmostConnected = nodes[i].getPeers().countAlmostConnectedDarknetPeers();
                int countTotal = nodes[i].getPeers().countValidPeers();
                int countBackedOff = nodes[i].getPeers().countBackedOffPeers(false);
                int countCompatible = nodes[i].getPeers().countCompatibleDarknetPeers();
                totalPeers += countTotal;
                totalConnections += countConnected;
                totalPartialConnections += countAlmostConnected;
                totalCompatibleConnections += countCompatible;
                totalBackedOff += countBackedOff;
                double pingTime = nodes[i].getNodeStats().getNodeAveragePingTime();
                totalPingTime += pingTime;
                if (pingTime > maxPingTime) {
                    maxPingTime = pingTime;
                }
                if (pingTime < minPingTime) {
                    minPingTime = pingTime;
                }
                if (countConnected == countTotal) {
                    ++countFullyConnected;
                    if (countBackedOff == 0) {
                        ++countReallyConnected;
                    }
                } else if (logMINOR) {
                    Logger.minor(RealNodeTest.class, "Connection count for " + nodes[i] + " : " + countConnected + " partial " + countAlmostConnected);
                }
                if (countBackedOff <= 0 || !logMINOR) continue;
                Logger.minor(RealNodeTest.class, "Backed off: " + nodes[i] + " : " + countBackedOff);
            }
            double avgPingTime = totalPingTime / (double)nodes.length;
            if (countFullyConnected == nodes.length && countReallyConnected == nodes.length && totalBackedOff == 0 && minPingTime < (double)NodeStats.DEFAULT_SUB_MAX_PING_TIME && maxPingTime < (double)NodeStats.DEFAULT_SUB_MAX_PING_TIME && avgPingTime < (double)NodeStats.DEFAULT_SUB_MAX_PING_TIME) {
                System.err.println("All nodes fully connected");
                Logger.normal(RealNodeTest.class, "All nodes fully connected");
                System.err.println();
                return;
            }
            long tDelta = (System.currentTimeMillis() - tStart) / 1000L;
            System.err.println("Waiting for nodes to be fully connected: " + countFullyConnected + " / " + nodes.length + " (" + totalConnections + " / " + totalPeers + " connections total partial " + totalPartialConnections + " compatible " + totalCompatibleConnections + ") - backed off " + totalBackedOff + " ping min/avg/max " + (int)minPingTime + "/" + (int)avgPingTime + "/" + (int)maxPingTime + " at " + tDelta + 's');
            Logger.normal(RealNodeTest.class, "Waiting for nodes to be fully connected: " + countFullyConnected + " / " + nodes.length + " (" + totalConnections + " / " + totalPeers + " connections total partial " + totalPartialConnections + " compatible " + totalCompatibleConnections + ") - backed off " + totalBackedOff + " ping min/avg/max " + (int)minPingTime + "/" + (int)avgPingTime + "/" + (int)maxPingTime + " at " + tDelta + 's');
            Thread.sleep(1000L);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

