/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.node.Version;
import freenet.node.simulator.LongTermTest;
import freenet.node.simulator.TestUtil;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class LongTermManySingleBlocksTest
extends LongTermTest {
    private static final int TEST_SIZE = 32768;
    private static final int DARKNET_PORT1 = 9010;
    private static final int OPENNET_PORT1 = 9011;
    private static final int MAX_N = 8;
    private static final int INSERTED_BLOCKS = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        long t1;
        File file;
        FileInputStream fis;
        Node node2;
        Node node;
        int exitCode;
        ArrayList<String> csvLine;
        block56: {
            if (args.length < 1 || args.length > 2) {
                System.err.println("Usage: java freenet.node.simulator.LongTermPushPullTest <unique identifier>");
                System.exit(1);
            }
            String uid = args[0];
            csvLine = new ArrayList<String>();
            System.out.println("DATE:" + dateFormat.format(today.getTime()));
            csvLine.add(dateFormat.format(today.getTime()));
            System.out.println("Version:" + Version.buildNumber());
            csvLine.add(String.valueOf(Version.buildNumber()));
            exitCode = 0;
            node = null;
            node2 = null;
            fis = null;
            file = new File("many-single-blocks-test-" + uid + ".csv");
            File dir = new File("longterm-mhk-test-" + uid);
            FileUtil.removeAll(dir);
            RandomSource random = NodeStarter.globalTestInit(dir.getPath(), false, Logger.LogLevel.ERROR, "", false);
            File seednodes = new File("seednodes.fref");
            if (!seednodes.exists() || seednodes.length() == 0L || !seednodes.canRead()) {
                System.err.println("Unable to read seednodes.fref, it doesn't exist, or is empty");
                System.exit(257);
            }
            File innerDir = new File(dir, Integer.toString(9010));
            innerDir.mkdir();
            fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir, "seednodes.fref"));
            fis.close();
            node = NodeStarter.createTestNode(9010, 9011, dir.getPath(), false, (short)18, 0, random, new PooledExecutor(), 1000, 0x400000L, true, true, true, true, true, true, true, 12288, true, true, false, false, null);
            Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
            node.start(true);
            t1 = System.currentTimeMillis();
            if (TestUtil.waitForNodes(node)) break block56;
            exitCode = 258;
            try {
                if (node != null) {
                    node.park();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (node2 != null) {
                    node2.park();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Closer.close(fis);
            LongTermManySingleBlocksTest.writeToStatusLog(file, csvLine);
            System.out.println("Exiting with status " + exitCode);
            System.exit(exitCode);
            return;
        }
        try {
            long t2 = System.currentTimeMillis();
            System.out.println("SEED-TIME:" + (t2 - t1));
            csvLine.add(String.valueOf(t2 - t1));
            HighLevelSimpleClient client = node.getClientCore().makeClient((short)0, false, false);
            int successes = 0;
            long startInsertsTime = System.currentTimeMillis();
            InsertBatch batch = new InsertBatch(client);
            for (int i = 0; i < 32; ++i) {
                System.err.println("Inserting block " + i);
                RandomAccessBucket single = LongTermManySingleBlocksTest.randomData(node);
                InsertBlock block = new InsertBlock(single, new ClientMetadata(), FreenetURI.EMPTY_CHK_URI);
                batch.startInsert(block);
            }
            batch.waitUntilFinished();
            FreenetURI[] uris = batch.getURIs();
            long[] times = batch.getTimes();
            InsertException[] errors = batch.getErrors();
            for (int i = 0; i < 32; ++i) {
                if (uris[i] != null) {
                    csvLine.add(String.valueOf(times[i]));
                    csvLine.add(uris[i].toASCIIString());
                    System.out.println("Pushed block " + i + " : " + uris[i] + " in " + times[i]);
                    ++successes;
                    continue;
                }
                csvLine.add(InsertException.getShortMessage(errors[i].getMode()));
                csvLine.add("N/A");
                System.out.println("Failed to push block " + i + " : " + errors[i]);
            }
            long endInsertsTime = System.currentTimeMillis();
            System.err.println("Succeeded inserts: " + successes + " of " + 32 + " in " + (endInsertsTime - startInsertsTime) + "ms");
            FetchContext fctx = client.getFetchContext();
            fctx.maxNonSplitfileRetries = 0;
            fctx.maxSplitfileBlockRetries = 0;
            RequestClient requestContext = new RequestClientBuilder().build();
            FreenetURI[] mhkURIs = new FreenetURI[3];
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, ENCODING));
            String line = null;
            GregorianCalendar target = (GregorianCalendar)today.clone();
            target.set(11, 0);
            target.set(12, 0);
            target.set(14, 0);
            target.set(13, 0);
            GregorianCalendar[] targets = new GregorianCalendar[9];
            for (int i = 0; i < targets.length; ++i) {
                targets[i] = (GregorianCalendar)target.clone();
                targets[i].add(5, -((1 << i) - 1));
                targets[i].getTime();
            }
            int[] totalFetchesByDelta = new int[9];
            int[] totalSuccessfulFetchesByDelta = new int[9];
            long[] totalFetchTimeByDelta = new long[9];
            block35: while (true) {
                int i;
                int token;
                int[] insertTimes;
                FreenetURI[] insertedURIs;
                GregorianCalendar calendar;
                Date date;
                String[] split;
                if ((line = br.readLine()) != null) {
                    for (int i2 = 0; i2 < mhkURIs.length; ++i2) {
                        mhkURIs[i2] = null;
                    }
                    split = line.split("!");
                    date = dateFormat.parse(split[0]);
                    calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    calendar.setTime(date);
                    System.out.println("Date: " + dateFormat.format(calendar.getTime()));
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.getTime();
                    insertedURIs = new FreenetURI[32];
                    insertTimes = new int[32];
                    if (split.length < 3) continue;
                    int seedTime = Integer.parseInt(split[2]);
                    System.out.println("Seed time: " + seedTime);
                    if (split.length < 4 || split.length < (token = 3) + 64) continue;
                } else {
                    System.out.println();
                    System.out.println();
                    for (int i2 = 0; i2 < 9; ++i2) {
                        System.out.println("DELTA: " + i2 + " days: Total fetches: " + totalFetchesByDelta[i2] + " total successes " + totalSuccessfulFetchesByDelta[i2] + " = " + (double)totalSuccessfulFetchesByDelta[i2] * 100.0 / (double)totalFetchesByDelta[i2] + "% in " + (double)totalFetchTimeByDelta[i2] * 1.0 / (double)totalSuccessfulFetchesByDelta[i2] + "ms");
                    }
                    fis.close();
                    fis = null;
                    try {
                        if (node != null) {
                            node.park();
                        }
                    }
                    catch (Throwable dir) {
                        // empty catch block
                    }
                    try {
                        if (node2 != null) {
                            node2.park();
                        }
                    }
                    catch (Throwable dir) {
                        // empty catch block
                    }
                    Closer.close(fis);
                    LongTermManySingleBlocksTest.writeToStatusLog(file, csvLine);
                    System.out.println("Exiting with status " + exitCode);
                    System.exit(exitCode);
                    return;
                }
                for (i = 0; i < 32; ++token, ++i) {
                    try {
                        insertTimes[i] = Integer.parseInt(split[token]);
                    }
                    catch (NumberFormatException e) {
                        insertTimes[i] = -1;
                    }
                    ++token;
                    try {
                        insertedURIs[i] = new FreenetURI(split[token]);
                    }
                    catch (MalformedURLException e) {
                        insertedURIs[i] = null;
                    }
                    System.out.println("Key insert " + i + " : " + insertedURIs[i] + " in " + insertTimes[i]);
                }
                for (i = 0; i < targets.length; ++i) {
                    if (Math.abs(targets[i].getTimeInMillis() - calendar.getTimeInMillis()) >= TimeUnit.HOURS.toMillis(12L)) continue;
                    System.out.println("Found row for target date " + ((1 << i) - 1) + " days ago.");
                    System.out.println("Version: " + split[1]);
                    csvLine.add(Integer.toString(i));
                    int pulled = 0;
                    int inserted = 0;
                    for (int j = 0; j < 32; ++j) {
                        if (insertedURIs[j] == null) {
                            csvLine.add("INSERT FAILED");
                            continue;
                        }
                        ++inserted;
                        try {
                            t1 = System.currentTimeMillis();
                            FetchWaiter fw = new FetchWaiter(requestContext);
                            client.fetch(insertedURIs[j], 32768L, fw, fctx);
                            fw.waitForCompletion();
                            t2 = System.currentTimeMillis();
                            System.out.println("PULL-TIME FOR BLOCK " + j + ": " + (t2 - t1));
                            csvLine.add(String.valueOf(t2 - t1));
                            ++pulled;
                            continue;
                        }
                        catch (FetchException e) {
                            if (e.getMode() != FetchException.FetchExceptionMode.ALL_DATA_NOT_FOUND && e.getMode() != FetchException.FetchExceptionMode.DATA_NOT_FOUND) {
                                e.printStackTrace();
                            }
                            csvLine.add(FetchException.getShortMessage(e.getMode()));
                            System.err.println("FAILED PULL FOR BLOCK " + j + ": " + e);
                        }
                    }
                    System.out.println("Pulled " + pulled + " blocks of " + inserted + " from " + ((1 << i) - 1) + " days ago.");
                }
                while (true) {
                    int delta;
                    if (split.length <= token + 32) continue block35;
                    try {
                        delta = Integer.parseInt(split[token]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Unable to parse token " + token + " = \"" + token + "\"");
                        System.err.println("This is supposed to be a delta");
                        System.err.println("Skipping the rest of the line for date " + dateFormat.format(calendar.getTime()));
                        continue block35;
                    }
                    System.out.println("Delta: " + ((1 << delta) - 1) + " days");
                    ++token;
                    int totalFetchTime = 0;
                    int totalSuccesses = 0;
                    int totalFetches = 0;
                    for (int i3 = 0; i3 < 32; ++i3) {
                        if (split[token].isEmpty()) continue;
                        int mhkFetchTime = -1;
                        ++totalFetches;
                        try {
                            mhkFetchTime = Integer.parseInt(split[token]);
                            System.out.println("Fetched block #" + i3 + " on " + date + " in " + mhkFetchTime + "ms");
                            ++totalSuccesses;
                            totalFetchTime += mhkFetchTime;
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Failed block #" + i3 + " on " + date + " : " + split[token]);
                        }
                        ++token;
                    }
                    int n = delta;
                    totalFetchesByDelta[n] = totalFetchesByDelta[n] + totalFetches;
                    int n2 = delta;
                    totalSuccessfulFetchesByDelta[n2] = totalSuccessfulFetchesByDelta[n2] + totalSuccesses;
                    int n3 = delta;
                    totalFetchTimeByDelta[n3] = totalFetchTimeByDelta[n3] + (long)totalFetchTime;
                    System.err.println("Succeeded: " + totalSuccesses + " of " + totalFetches + " average " + (double)totalFetchTime / (double)totalSuccesses + "ms for delta " + delta + " on " + dateFormat.format(date));
                }
                break;
            }
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                exitCode = 261;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (node != null) {
                        node.park();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (node2 != null) {
                        node2.park();
                    }
                }
                catch (Throwable throwable) {}
                Closer.close(fis);
                LongTermManySingleBlocksTest.writeToStatusLog(file, csvLine);
                System.out.println("Exiting with status " + exitCode);
                System.exit(exitCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RandomAccessBucket randomData(Node node) throws IOException {
        RandomAccessBucket data = node.getClientCore().getTempBucketFactory().makeBucket(32768L);
        try (OutputStream os = data.getOutputStream();){
            int toWrite;
            byte[] buf = new byte[4096];
            for (long written = 0L; written < 32768L; written += (long)toWrite) {
                node.getFastWeakRandom().nextBytes(buf);
                toWrite = (int)Math.min(32768L - written, (long)buf.length);
                os.write(buf, 0, toWrite);
            }
        }
        return data;
    }

    public static class InsertBatch {
        private final HighLevelSimpleClient client;
        private int runningInserts;
        private ArrayList<BatchInsert> inserts = new ArrayList();

        public InsertBatch(HighLevelSimpleClient client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startInsert(InsertBlock block) {
            BatchInsert bi = new BatchInsert(block);
            InsertBatch insertBatch = this;
            synchronized (insertBatch) {
                this.inserts.add(bi);
            }
            bi.start();
        }

        public synchronized void waitUntilFinished() {
            while (this.runningInserts != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }

        public synchronized FreenetURI[] getURIs() {
            FreenetURI[] uris = new FreenetURI[this.inserts.size()];
            for (int i = 0; i < uris.length; ++i) {
                uris[i] = this.inserts.get(i).uri;
            }
            return uris;
        }

        public synchronized long[] getTimes() {
            long[] times = new long[this.inserts.size()];
            for (int i = 0; i < times.length; ++i) {
                times[i] = this.inserts.get(i).insertTime;
            }
            return times;
        }

        public InsertException[] getErrors() {
            InsertException[] errors = new InsertException[this.inserts.size()];
            for (int i = 0; i < errors.length; ++i) {
                errors[i] = this.inserts.get(i).failed;
            }
            return errors;
        }

        class BatchInsert
        implements Runnable {
            private final InsertBlock block;
            private long insertTime;
            private InsertException failed;
            private FreenetURI uri;

            public BatchInsert(InsertBlock block) {
                this.block = block;
            }

            public void start() {
                Thread t = new Thread(this);
                t.setDaemon(true);
                t.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InsertBatch insertBatch = InsertBatch.this;
                synchronized (insertBatch) {
                    InsertBatch.this.runningInserts++;
                    System.out.println("Starting insert: running " + InsertBatch.this.runningInserts);
                }
                long t1 = 0L;
                long t2 = 0L;
                FreenetURI thisURI = null;
                InsertException f = null;
                try {
                    t1 = System.currentTimeMillis();
                    thisURI = InsertBatch.this.client.insert(this.block, false, null);
                    t2 = System.currentTimeMillis();
                }
                catch (InsertException e) {
                    f = e;
                }
                finally {
                    InsertBatch insertBatch2 = InsertBatch.this;
                    synchronized (insertBatch2) {
                        InsertBatch.this.runningInserts--;
                        System.out.println("Completed insert: running " + InsertBatch.this.runningInserts);
                        if (thisURI != null) {
                            this.uri = thisURI;
                            this.insertTime = t2 - t1;
                        } else if (f != null) {
                            this.failed = f;
                        } else {
                            f = new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR);
                        }
                        InsertBatch.this.notifyAll();
                    }
                }
            }
        }
    }
}

