/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressIdentifier;
import freenet.io.AddressMatcher;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;

public class Inet6AddressMatcher
implements AddressMatcher {
    private static final byte[] FULL_MASK = new byte[16];
    private byte[] address;
    private byte[] netmask;

    public AddressIdentifier.AddressType getAddressType() {
        return AddressIdentifier.AddressType.IPv6;
    }

    public Inet6AddressMatcher(String pattern) throws IllegalArgumentException {
        if (pattern.indexOf(47) != -1) {
            this.address = this.convertToBytes(pattern.substring(0, pattern.indexOf(47)));
            String netmaskString = pattern.substring(pattern.indexOf(47) + 1).trim();
            if (netmaskString.indexOf(58) != -1) {
                this.netmask = this.convertToBytes(netmaskString);
            } else {
                this.netmask = new byte[16];
                int bits = Integer.parseInt(netmaskString);
                if (bits > 128 || bits < 0) {
                    throw new IllegalArgumentException("Mask bits out of range: " + bits + " (" + netmaskString + ")");
                }
                for (int index = 0; index < 16; ++index) {
                    this.netmask[index] = (byte)(255 << 8 - Math.min(bits, 8));
                    bits = Math.max(bits - 8, 0);
                }
            }
            if (Arrays.equals(this.netmask, FULL_MASK)) {
                this.netmask = FULL_MASK;
            }
        } else {
            this.address = this.convertToBytes(pattern);
            this.netmask = FULL_MASK;
        }
        if (this.address.length != 16) {
            throw new IllegalArgumentException("address is not IPv6");
        }
    }

    private byte[] convertToBytes(String address) throws IllegalArgumentException {
        String[] addressTokens = address.split(":", -1);
        int tokenPosition = 0;
        byte[] addressBytes = new byte[16];
        byte[] addressBytesEnd = new byte[16];
        int count = 0;
        int endCount = -1;
        if (address.startsWith(":")) {
            if (address.startsWith("::")) {
                if (address == "::") {
                    return addressBytes;
                }
                tokenPosition = 2;
                endCount = 0;
            } else {
                throw new IllegalArgumentException(address + " is not an IPv6 address.");
            }
        }
        while (tokenPosition < addressTokens.length) {
            String token = addressTokens[tokenPosition];
            ++tokenPosition;
            if (!token.isEmpty()) {
                int addressWord;
                try {
                    addressWord = Integer.parseInt(token, 16);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(address + " is not an IPv6 address.");
                }
                if (addressWord < 0 || addressWord > 65535) {
                    throw new IllegalArgumentException(address + " is not an IPv6 address.");
                }
                if (endCount == -1) {
                    if (count >= 8) {
                        throw new IllegalArgumentException(address + " is not an IPv6 address.");
                    }
                    addressBytes[count * 2] = (byte)(addressWord >> 8 & 0xFF);
                    addressBytes[count * 2 + 1] = (byte)(addressWord & 0xFF);
                    ++count;
                    continue;
                }
                if (count + endCount >= 7) {
                    throw new IllegalArgumentException(address + " is not an IPv6 address.");
                }
                addressBytesEnd[endCount * 2] = (byte)(addressWord >> 8 & 0xFF);
                addressBytesEnd[endCount * 2 + 1] = (byte)(addressWord & 0xFF);
                ++endCount;
                continue;
            }
            if (endCount == -1) {
                if (count >= 8 || tokenPosition == addressTokens.length) {
                    throw new IllegalArgumentException(address + " is not an IPv6 address.");
                }
                endCount = 0;
                continue;
            }
            if (endCount <= 0 && tokenPosition == addressTokens.length) continue;
            throw new IllegalArgumentException(address + " is not an IPv6 address.");
        }
        if (endCount != -1) {
            int index;
            for (index = count; index < 8 - endCount; ++index) {
                addressBytes[index * 2] = 0;
                addressBytes[index * 2 + 1] = 0;
            }
            for (index = 0; index < endCount; ++index) {
                addressBytes[(8 - endCount + index) * 2] = addressBytesEnd[index * 2];
                addressBytes[(8 - endCount + index) * 2 + 1] = addressBytesEnd[index * 2 + 1];
            }
        }
        return addressBytes;
    }

    @Override
    public boolean matches(InetAddress address) {
        if (!(address instanceof Inet6Address)) {
            return false;
        }
        byte[] addressBytes = address.getAddress();
        for (int index = 0; index < 16; ++index) {
            if ((addressBytes[index] & this.netmask[index]) == (this.address[index] & this.netmask[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(String pattern, InetAddress address) throws IllegalArgumentException {
        return new Inet6AddressMatcher(pattern).matches(address);
    }

    @Override
    public String getHumanRepresentation() {
        if (this.netmask == FULL_MASK) {
            return this.convertToString(this.address);
        }
        return this.convertToString(this.address) + '/' + this.convertToString(this.netmask);
    }

    private String convertToString(byte[] addr) {
        StringBuilder sb = new StringBuilder(39);
        for (int i = 0; i < 8; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            int token = ((addr[i * 2] & 0xFF) << 8) + (addr[i * 2 + 1] & 0xFF);
            sb.append(Integer.toHexString(token));
        }
        return sb.toString();
    }

    static {
        Arrays.fill(FULL_MASK, (byte)-1);
    }
}

