/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.LocalFileN2NMToadlet;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPRequest;
import freenet.support.api.HTTPUploadedFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public class N2NTMToadlet
extends Toadlet {
    private Node node;
    private LocalFileN2NMToadlet browser;

    protected N2NTMToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(client);
        this.browser = new LocalFileN2NMToadlet(core, client);
        this.node = n;
    }

    public Toadlet getBrowser() {
        return this.browser;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        if (request.isParameterSet("peernode_hashcode")) {
            PageNode page = ctx.getPageMaker().getPageNode(N2NTMToadlet.l10n("sendMessage"), ctx);
            HTMLNode contentNode = page.getContentNode();
            String peernode_name = null;
            String input_hashcode_string = request.getParam("peernode_hashcode");
            int input_hashcode = -1;
            try {
                input_hashcode = Integer.parseInt(input_hashcode_string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (input_hashcode != -1) {
                DarknetPeerNode[] peerNodes;
                for (DarknetPeerNode pn : peerNodes = this.node.getDarknetConnections()) {
                    int peer_hashcode = pn.hashCode();
                    if (peer_hashcode != input_hashcode) continue;
                    peernode_name = pn.getName();
                    break;
                }
            }
            if (peernode_name == null) {
                contentNode.addChild(N2NTMToadlet.createPeerInfobox("infobox-error", N2NTMToadlet.l10n("peerNotFoundTitle"), this.l10n("peerNotFoundWithHash", "hash", input_hashcode_string)));
                this.writeHTMLReply(ctx, 200, "OK", page.generate());
                return;
            }
            HashMap<String, String> peers = new HashMap<String, String>();
            peers.put(input_hashcode_string, peernode_name);
            N2NTMToadlet.createN2NTMSendForm(ctx.isAdvancedModeEnabled(), contentNode, ctx, peers);
            this.writeHTMLReply(ctx, 200, "OK", page.generate());
            return;
        }
        MultiValueTable<String, String> headers = MultiValueTable.from("Location", "/friends/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("N2NTMToadlet." + key, pattern, value);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("N2NTMToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("N2NTMToadlet." + key);
    }

    private static long maxSize() {
        long memory = NodeStarter.getMemoryLimitBytes();
        if (memory == Long.MAX_VALUE || memory <= 0L) {
            return 0x100000L;
        }
        long maxMem = Math.round(0.05 * (double)memory);
        long limit = Math.max(maxMem, 0x100000L);
        return limit;
    }

    private static HTMLNode createPeerInfobox(String infoboxType, String header, String message) {
        HTMLNode infobox = new HTMLNode("div", "class", "infobox " + infoboxType);
        infobox.addChild("div", "class", "infobox-header", header);
        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
        infoboxContent.addChild("#", message);
        HTMLNode list = infoboxContent.addChild("ul");
        Toadlet.addHomepageLink(list);
        list.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/friends/", N2NTMToadlet.l10n("returnToFriends")}, N2NTMToadlet.l10n("friends"));
        return infobox;
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        if (request.isPartSet("n2nm-browse")) {
            try {
                throw new RedirectException("/n2nm-browse/");
            }
            catch (URISyntaxException uRISyntaxException) {
                return;
            }
        }
        if (request.isPartSet("n2nm-upload") || request.isPartSet("select-file") || request.isPartSet("send")) {
            String fnam;
            File filename = null;
            String message = request.getPartAsStringFailsafe("message", 0x100000);
            message = message.trim();
            String messageHead = message.substring(0, Math.min(message.length(), 1024));
            if (message.length() > 131072) {
                this.writeTextReply(ctx, 400, "Bad request", N2NTMToadlet.l10n("tooLong"));
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(N2NTMToadlet.l10n("processingSend"), ctx);
            HTMLNode contentNode = page.getContentNode();
            HTMLNode peerTableInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            if (!(!request.isPartSet("select-file") || (fnam = request.getPartAsStringFailsafe("filename", 1024)) == null || fnam.isEmpty() || (filename = new File(fnam)).exists() && filename.canRead())) {
                peerTableInfobox.addChild("#", N2NTMToadlet.l10n("noSuchFileOrCannotRead"));
                Toadlet.addHomepageLink(peerTableInfobox);
                this.writeHTMLReply(ctx, 400, "OK", page.generate());
                return;
            }
            HTMLNode peerTable = peerTableInfobox.addChild("table", "class", "n2ntm-send-statuses");
            HTMLNode peerTableHeaderRow = peerTable.addChild("tr");
            peerTableHeaderRow.addChild("th", N2NTMToadlet.l10n("peerName"));
            peerTableHeaderRow.addChild("th", N2NTMToadlet.l10n("sendStatus"));
            for (DarknetPeerNode pn : peerNodes) {
                String sendStatusClass;
                String sendStatusLong;
                String sendStatusShort;
                int status;
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                if (filename != null) {
                    try {
                        status = pn.sendFileOffer(filename, messageHead);
                    }
                    catch (IOException e) {
                        peerTableInfobox.addChild("#", N2NTMToadlet.l10n("noSuchFileOrCannotRead"));
                        Toadlet.addHomepageLink(peerTableInfobox);
                        N2NTMToadlet.addUnsentMessageTextInfo(peerTableInfobox, message);
                        this.writeHTMLReply(ctx, 200, "OK", page.generate());
                        return;
                    }
                }
                if (request.isPartSet("n2nm-upload")) {
                    try {
                        long size;
                        HTTPUploadedFile file = request.getUploadedFile("n2nm-upload");
                        if (!file.getFilename().isEmpty() && (size = request.getUploadedFile("n2nm-upload").getData().size()) > 0L) {
                            long limit = N2NTMToadlet.maxSize();
                            if (size > limit) {
                                peerTableInfobox.addChild("#", this.l10n("tooLarge", new String[]{"attempt", "limit"}, new String[]{SizeUtil.formatSize(size, true), SizeUtil.formatSize(limit, true)}));
                                HTMLNode list = peerTableInfobox.addChild("ul");
                                Toadlet.addHomepageLink(list);
                                list.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/friends/", N2NTMToadlet.l10n("returnToFriends")}, N2NTMToadlet.l10n("friends"));
                                N2NTMToadlet.addUnsentMessageTextInfo(peerTableInfobox, message);
                                this.writeHTMLReply(ctx, 200, "OK", page.generate());
                                return;
                            }
                            status = pn.sendFileOffer(request.getUploadedFile("n2nm-upload"), messageHead);
                        }
                    }
                    catch (IOException e) {
                        peerTableInfobox.addChild("#", N2NTMToadlet.l10n("uploadFailed"));
                        Toadlet.addHomepageLink(peerTableInfobox);
                        N2NTMToadlet.addUnsentMessageTextInfo(peerTableInfobox, message);
                        this.writeHTMLReply(ctx, 200, "OK", page.generate());
                        return;
                    }
                }
                status = pn.sendTextFeed(message);
                if (status == 2) {
                    sendStatusShort = N2NTMToadlet.l10n("delayedTitle");
                    sendStatusLong = N2NTMToadlet.l10n("delayed");
                    sendStatusClass = "n2ntm-send-delayed";
                    Logger.normal(this, "Sent N2NTM to '" + pn.getName() + "': " + message);
                } else if (status == 1) {
                    sendStatusShort = N2NTMToadlet.l10n("sentTitle");
                    sendStatusLong = N2NTMToadlet.l10n("sent");
                    sendStatusClass = "n2ntm-send-sent";
                    Logger.normal(this, "Sent N2NTM to '" + pn.getName() + "': " + message);
                } else {
                    sendStatusShort = N2NTMToadlet.l10n("queuedTitle");
                    sendStatusLong = N2NTMToadlet.l10n("queued");
                    sendStatusClass = "n2ntm-send-queued";
                    Logger.normal(this, "Queued N2NTM to '" + pn.getName() + "': " + message);
                }
                HTMLNode peerRow = peerTable.addChild("tr");
                peerRow.addChild("td", "class", "peer-name").addChild("#", pn.getName());
                peerRow.addChild("td", "class", sendStatusClass).addChild("span", new String[]{"title", "style"}, new String[]{sendStatusLong, "border-bottom: 1px dotted; cursor: help;"}, sendStatusShort);
            }
            HTMLNode infoboxContent = peerTableInfobox.addChild("div", "class", "n2ntm-message-text");
            infoboxContent.addChild("#", message);
            HTMLNode list = peerTableInfobox.addChild("ul");
            Toadlet.addHomepageLink(list);
            list.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/friends/", N2NTMToadlet.l10n("returnToFriends")}, N2NTMToadlet.l10n("friends"));
            this.writeHTMLReply(ctx, 200, "OK", page.generate());
            return;
        }
        MultiValueTable<String, String> headers = MultiValueTable.from("Location", "/friends/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    public static void addUnsentMessageTextInfo(HTMLNode node, String message) {
        node.addChild("p", N2NTMToadlet.l10n("unsentMessageText"));
        node.addChild("p", message);
    }

    public static void createN2NTMSendForm(boolean advancedMode, HTMLNode contentNode, ToadletContext ctx, HashMap<String, String> peers) throws ToadletContextClosedException, IOException {
        HTMLNode infobox = contentNode.addChild("div", new String[]{"class", "id"}, new String[]{"infobox", "n2nbox"});
        infobox.addChild("div", "class", "infobox-header", N2NTMToadlet.l10n("sendMessage"));
        HTMLNode messageTargets = infobox.addChild("div", "class", "infobox-content");
        messageTargets.addChild("p", N2NTMToadlet.l10n("composingMessageLabel"));
        HTMLNode messageTargetList = messageTargets.addChild("ul");
        for (String peer_name : peers.values()) {
            messageTargetList.addChild("li", peer_name);
        }
        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
        HTMLNode messageForm = ctx.addFormChild(infoboxContent, "/send_n2ntm/", "sendN2NTMForm");
        for (String peerNodeHash : peers.keySet()) {
            messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "node_" + peerNodeHash, "1"});
        }
        messageForm.addChild("textarea", new String[]{"id", "name", "rows", "cols"}, new String[]{"n2ntmtext", "message", "8", "74"});
        if (advancedMode) {
            messageForm.addChild("br");
            messageForm.addChild("#", NodeL10n.getBase().getString("N2NTMToadlet.mayAttachFile"));
            if (ctx.isAllowedFullAccess()) {
                messageForm.addChild("br");
                messageForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.insertFileBrowseLabel") + ": ");
                messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "n2nm-browse", NodeL10n.getBase().getString("QueueToadlet.insertFileBrowseButton") + "..."});
                messageForm.addChild("br");
            }
            messageForm.addChild("#", NodeL10n.getBase().getString("N2NTMToadlet.sizeWarning", "limit", SizeUtil.formatSize(N2NTMToadlet.maxSize(), true)));
            messageForm.addChild("br");
            messageForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.insertFileLabel") + ": ");
            messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"file", "n2nm-upload", ""});
            messageForm.addChild("br");
        }
        messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "send", N2NTMToadlet.l10n("sendMessageShort")});
    }

    @Override
    public String path() {
        return "/send_n2ntm/";
    }
}

