/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.events.SplitfileProgressEvent;
import freenet.clients.fcp.ClientRequest;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import java.util.Date;

public abstract class RequestStatus
implements Cloneable {
    private final String identifier;
    private boolean hasStarted;
    private boolean hasFinished;
    private boolean hasSucceeded;
    private short priority;
    private int totalBlocks;
    private int minBlocks;
    private int fetchedBlocks;
    private Date latestSuccess;
    private int fatallyFailedBlocks;
    private int failedBlocks;
    private Date latestFailure;
    private boolean isTotalFinalized;
    private final ClientRequest.Persistence persistence;

    synchronized void setFinished(boolean success) {
        this.latestSuccess = new Date();
        this.hasFinished = true;
        this.hasSucceeded = success;
        this.hasStarted = true;
        this.isTotalFinalized = true;
    }

    synchronized void restart(boolean started) {
        this.latestSuccess = new Date();
        this.hasFinished = false;
        this.hasSucceeded = false;
        this.hasStarted = started;
        this.isTotalFinalized = false;
    }

    RequestStatus(String identifier, ClientRequest.Persistence persistence, boolean started, boolean finished, boolean success, int total, int min, int fetched, Date latestSuccess, int fatal, int failed, Date latestFailure, boolean totalFinalized, short prio) {
        this.identifier = identifier;
        this.hasStarted = started;
        this.hasFinished = finished;
        this.hasSucceeded = success;
        this.priority = prio;
        this.totalBlocks = total;
        this.minBlocks = min;
        this.fetchedBlocks = fetched;
        this.latestSuccess = latestSuccess != null ? (Date)latestSuccess.clone() : null;
        this.fatallyFailedBlocks = fatal;
        this.failedBlocks = failed;
        this.latestFailure = latestFailure != null ? (Date)latestFailure.clone() : null;
        this.isTotalFinalized = totalFinalized;
        this.persistence = persistence;
    }

    public boolean hasSucceeded() {
        return this.hasSucceeded;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    public short getPriority() {
        return this.priority;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public boolean isTotalFinalized() {
        return this.isTotalFinalized;
    }

    public int getMinBlocks() {
        return this.minBlocks;
    }

    public int getFetchedBlocks() {
        return this.fetchedBlocks;
    }

    @Deprecated
    public long getLastActivity() {
        return this.latestSuccess != null ? this.latestSuccess.getTime() : 0L;
    }

    public Date getLastSuccess() {
        return this.latestSuccess != null ? (Date)this.latestSuccess.clone() : null;
    }

    public Date getLastFailure() {
        return this.latestFailure != null ? (Date)this.latestFailure.clone() : null;
    }

    public abstract FreenetURI getURI();

    public abstract long getDataSize();

    public boolean isPersistentForever() {
        return this.persistence == ClientRequest.Persistence.FOREVER;
    }

    public boolean isPersistent() {
        return this.persistence != ClientRequest.Persistence.CONNECTION;
    }

    public int getFatalyFailedBlocks() {
        return this.fatallyFailedBlocks;
    }

    public int getFailedBlocks() {
        return this.failedBlocks;
    }

    public boolean isStarted() {
        return this.hasStarted;
    }

    public abstract String getFailureReason(boolean var1);

    public synchronized void updateStatus(SplitfileProgressEvent event) {
        this.failedBlocks = event.failedBlocks;
        this.fatallyFailedBlocks = event.fatallyFailedBlocks;
        this.latestFailure = event.latestFailure != null ? (Date)event.latestFailure.clone() : null;
        this.fetchedBlocks = event.succeedBlocks;
        this.latestSuccess = event.latestSuccess != null ? (Date)event.latestSuccess.clone() : null;
        this.isTotalFinalized = event.finalizedTotal;
        this.minBlocks = event.minSuccessfulBlocks;
        this.totalBlocks = event.totalBlocks;
    }

    public synchronized void setPriority(short newPriority) {
        this.priority = newPriority;
    }

    public synchronized void setStarted(boolean started) {
        this.hasStarted = started;
    }

    public abstract String getPreferredFilename();

    public String getPreferredFilenameSafe() {
        String ret = this.getPreferredFilename();
        if (ret == null) {
            return NodeL10n.getBase().getString("RequestStatus.unknownFilename");
        }
        return ret;
    }

    public RequestStatus clone() {
        try {
            return (RequestStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

