/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.BaseDataCarryingMessage;
import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.MessageInvalidException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class ClientGetMessage
extends BaseDataCarryingMessage {
    public static final String NAME = "ClientGet";
    final boolean ignoreDS;
    final boolean dsOnly;
    final FreenetURI uri;
    final String identifier;
    final int verbosity;
    final ClientGet.ReturnType returnType;
    final ClientRequest.Persistence persistence;
    final long maxSize;
    final long maxTempSize;
    final int maxRetries;
    final short priorityClass;
    final File diskFile;
    final String clientToken;
    final boolean global;
    final boolean binaryBlob;
    final String[] allowedMIMETypes;
    public boolean writeToClientCache;
    final String charset;
    final boolean filterData;
    final boolean realTimeFlag;
    final boolean ignoreUSKDatehints;
    private Bucket initialMetadata;
    private final long initialMetadataLength;
    private static volatile boolean logMINOR;

    public ClientGetMessage(SimpleFieldSet fs) throws MessageInvalidException {
        String priorityString;
        int defaultPriority;
        this.clientToken = fs.get("ClientToken");
        this.global = fs.getBoolean("Global", false);
        this.ignoreDS = fs.getBoolean("IgnoreDS", false);
        this.dsOnly = fs.getBoolean("DSOnly", false);
        this.identifier = fs.get("Identifier");
        this.allowedMIMETypes = fs.getAll("AllowedMIMETypes");
        this.filterData = fs.getBoolean("FilterData", false);
        this.charset = fs.get("Charset");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            this.uri = new FreenetURI(fs.get("URI"));
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String returnTypeString = fs.get("ReturnType");
        this.returnType = this.parseReturnTypeFCP(returnTypeString);
        if (this.returnType == ClientGet.ReturnType.DIRECT) {
            this.diskFile = null;
            defaultPriority = 2;
        } else if (this.returnType == ClientGet.ReturnType.NONE) {
            this.diskFile = null;
            defaultPriority = 5;
        } else if (this.returnType == ClientGet.ReturnType.DISK) {
            defaultPriority = 4;
            String filename = fs.get("Filename");
            if (filename == null) {
                throw new MessageInvalidException(5, "Missing Filename", this.identifier, this.global);
            }
            this.diskFile = new File(filename);
            if (this.diskFile.exists()) {
                throw new MessageInvalidException(10, null, this.identifier, this.global);
            }
            try {
                File temp = FileUtil.createTempFile(this.diskFile.getName(), ".freenet-tmp", this.diskFile.getParentFile());
                temp.delete();
            }
            catch (IOException e) {
                throw new MessageInvalidException(12, e.getMessage(), this.identifier, this.global);
            }
        } else {
            throw new MessageInvalidException(3, "Unknown return-type", this.identifier, this.global);
        }
        String maxSizeString = fs.get("MaxSize");
        if (maxSizeString == null) {
            this.maxSize = Long.MAX_VALUE;
        } else {
            try {
                this.maxSize = Long.parseLong(maxSizeString, 10);
                if (this.maxSize < 0L) {
                    throw new MessageInvalidException(8, "Maximum size must be positive", this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxTempSizeString = fs.get("MaxTempSize");
        if (maxTempSizeString == null) {
            this.maxTempSize = Long.MAX_VALUE;
        } else {
            try {
                this.maxTempSize = Long.parseLong(maxTempSizeString, 10);
                if (this.maxTempSize < 0L) {
                    throw new MessageInvalidException(8, "Maximum temp size must be positive", this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
                if (this.maxRetries < -1) {
                    throw new MessageInvalidException(8, "Max retries must be -1 or larger", this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "max retries=" + this.maxRetries);
        }
        if ((priorityString = fs.get("PriorityClass")) == null) {
            this.priorityClass = (short)defaultPriority;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString);
                if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                    throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String persistenceString = fs.get("Persistence");
        this.persistence = ClientRequest.Persistence.parseOrThrow(persistenceString, this.identifier, this.global);
        if (this.global && this.persistence == ClientRequest.Persistence.CONNECTION) {
            throw new MessageInvalidException(16, "Global requests must be persistent", this.identifier, this.global);
        }
        this.writeToClientCache = fs.getBoolean("WriteToClientCache", this.persistence == ClientRequest.Persistence.CONNECTION);
        this.binaryBlob = fs.getBoolean("BinaryBlob", false);
        this.realTimeFlag = fs.getBoolean("RealTimeFlag", false);
        this.initialMetadataLength = fs.getLong("InitialMetadata.DataLength", 0L);
        if (this.initialMetadataLength < 0L) {
            throw new MessageInvalidException(8, "Invalid data length for initial metadata", this.identifier, this.global);
        }
        this.ignoreUSKDatehints = fs.getBoolean("IgnoreUSKDatehints", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("IgnoreDS", this.ignoreDS);
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.put("FilterData", this.filterData);
        fs.putSingle("Charset", this.charset);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Verbosity", this.verbosity);
        fs.putSingle("ReturnType", this.getReturnTypeString());
        fs.put("MaxSize", this.maxSize);
        fs.put("MaxTempSize", this.maxTempSize);
        fs.put("MaxRetries", this.maxRetries);
        fs.put("BinaryBlob", this.binaryBlob);
        return fs;
    }

    private String getReturnTypeString() {
        return this.returnType.toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) {
        handler.startClientGet(this);
    }

    ClientGet.ReturnType parseReturnTypeFCP(String string) throws MessageInvalidException {
        try {
            if (string == null) {
                return ClientGet.ReturnType.DIRECT;
            }
            return ClientGet.ReturnType.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, "Unable to parse ReturnType " + string + " : " + e, this.identifier, this.global);
        }
    }

    @Override
    long dataLength() {
        return this.initialMetadataLength;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
        if (this.initialMetadataLength == 0L) {
            return;
        }
        RandomAccessBucket data = bf.makeBucket(this.initialMetadataLength);
        BucketTools.copyFrom(data, is, this.initialMetadataLength);
        this.initialMetadata = data;
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Bucket getInitialMetadata() {
        return this.initialMetadata;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

