/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.SimpleFieldSet;
import freenet.support.math.RunningAverage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;

public final class BootstrappingDecayingRunningAverage
implements RunningAverage,
Cloneable {
    private final AtomicReference<Data> data = new AtomicReference();
    private final double min;
    private final double max;

    public BootstrappingDecayingRunningAverage(double defaultValue, double min, double max, int maxReports, SimpleFieldSet fs) {
        double d;
        this.min = min;
        this.max = max;
        long reports = 0L;
        double currentValue = defaultValue;
        if (fs != null && !this.isInvalid(d = fs.getDouble("CurrentValue", currentValue))) {
            reports = Math.max(0L, fs.getLong("Reports", reports));
            currentValue = d;
        }
        this.data.set(new Data(maxReports, reports, currentValue));
    }

    private BootstrappingDecayingRunningAverage(BootstrappingDecayingRunningAverage other) {
        this.min = other.min;
        this.max = other.max;
        this.data.set(new Data(other.data.get()));
    }

    @Override
    public double currentValue() {
        return this.data.get().currentValue;
    }

    @Override
    public void report(double d) {
        this.data.updateAndGet(data -> data.updated(d));
    }

    @Override
    public void report(long d) {
        this.report((double)d);
    }

    @Override
    public double valueIfReported(double d) {
        return this.data.get().updated(d).currentValue;
    }

    @Override
    public long countReports() {
        return this.data.get().reports;
    }

    @Override
    public BootstrappingDecayingRunningAverage clone() {
        return new BootstrappingDecayingRunningAverage(this);
    }

    public void changeMaxReports(int maxReports) {
        this.data.updateAndGet(data -> data.withMaxReports(maxReports));
    }

    void report(UnaryOperator<Data> updateFunction) {
        this.data.updateAndGet(updateFunction);
    }

    double valueIfReported(UnaryOperator<Data> updateFunction) {
        return ((Data)updateFunction.apply(this.data.get())).currentValue;
    }

    public SimpleFieldSet exportFieldSet(boolean shortLived) {
        Data data = this.data.get();
        SimpleFieldSet fs = new SimpleFieldSet(shortLived);
        fs.putSingle("Type", "BootstrappingDecayingRunningAverage");
        fs.put("CurrentValue", data.currentValue);
        fs.put("Reports", data.reports);
        return fs;
    }

    private boolean isInvalid(double d) {
        return d < this.min || d > this.max || Double.isInfinite(d) || Double.isNaN(d);
    }

    class Data {
        private final long maxReports;
        private final long reports;
        private final double currentValue;

        private Data(long maxReports, long reports, double currentValue) {
            this.maxReports = maxReports;
            this.reports = reports;
            this.currentValue = currentValue;
        }

        private Data(Data other) {
            this.maxReports = other.maxReports;
            this.reports = other.reports;
            this.currentValue = other.currentValue;
        }

        double currentValue() {
            return this.currentValue;
        }

        Data updated(double d) {
            if (BootstrappingDecayingRunningAverage.this.isInvalid(d)) {
                return this;
            }
            double decayFactor = 1.0 / (double)Math.min(this.reports + 1L, this.maxReports);
            double newValue = d * decayFactor + this.currentValue * (1.0 - decayFactor);
            return new Data(this.maxReports, this.reports + 1L, newValue);
        }

        Data withCurrentValue(double currentValue) {
            if (BootstrappingDecayingRunningAverage.this.isInvalid(currentValue)) {
                return this;
            }
            return new Data(this.maxReports, this.reports, currentValue);
        }

        Data withMaxReports(long maxReports) {
            return new Data(maxReports, this.reports, this.currentValue);
        }
    }
}

