/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class MultiValueTable<K, V> {
    private final Map<K, List<V>> table;

    public MultiValueTable() {
        this.table = new ConcurrentHashMap<K, List<V>>();
    }

    public MultiValueTable(int initialSize) {
        this.table = new ConcurrentHashMap<K, List<V>>(initialSize);
    }

    @Deprecated
    public MultiValueTable(int initialSize, int unused) {
        this(initialSize);
    }

    public static <K, V> MultiValueTable<K, V> from(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException(String.format("keys and values must contain the same number of values, but there are %d keys and %d values", keys.length, values.length));
        }
        MultiValueTable<K, V> table = new MultiValueTable<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            table.put(keys[i], values[i]);
        }
        return table;
    }

    @SafeVarargs
    public static <K, V> MultiValueTable<K, V> from(K key, V ... values) {
        return MultiValueTable.from(key, Arrays.asList(values));
    }

    public static <K, V> MultiValueTable<K, V> from(K key, Collection<? extends V> values) {
        MultiValueTable<K, ? extends V> table = new MultiValueTable<K, V>(1);
        table.putAll(key, values);
        return table;
    }

    public void put(K key, V value) {
        this.table.compute(key, (k, previousList) -> {
            ArrayList<Object> result;
            if (previousList == null) {
                result = new ArrayList<Object>(1);
            } else {
                result = new ArrayList(previousList.size() + 1);
                result.addAll((Collection<Object>)previousList);
            }
            result.add(value);
            return Collections.unmodifiableList(result);
        });
    }

    public void putAll(K key, Collection<? extends V> elements) {
        this.table.compute(key, (k, previousList) -> {
            ArrayList result;
            if (previousList == null) {
                result = new ArrayList(elements.size());
            } else {
                result = new ArrayList(previousList.size() + elements.size());
                result.addAll(previousList);
            }
            result.addAll(elements);
            return Collections.unmodifiableList(result);
        });
    }

    @Deprecated
    public V get(K key) {
        return this.getFirst(key);
    }

    public V getFirst(K key) {
        List<V> list = this.table.get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public boolean containsKey(K key) {
        return this.table.containsKey(key);
    }

    public boolean containsElement(K key, V value) {
        List<V> list = this.table.get(key);
        if (list == null || list.isEmpty()) {
            return false;
        }
        return list.contains(value);
    }

    @Deprecated
    public Enumeration<V> getAll(K key) {
        return Collections.enumeration(this.getAllAsList(key));
    }

    public List<V> getAllAsList(K key) {
        return this.table.getOrDefault(key, Collections.emptyList());
    }

    public Iterable<V> iterateAll(K key) {
        return this.getAllAsList(key);
    }

    public int countAll(K key) {
        return this.getAllAsList(key).size();
    }

    @Deprecated
    public Object getSync(K key) {
        List<V> l = this.table.get(key);
        if (l == null) {
            return null;
        }
        return new Vector<V>(l);
    }

    @Deprecated
    public Object[] getArray(K key) {
        List<V> l = this.table.get(key);
        if (l == null) {
            return null;
        }
        return l.toArray();
    }

    public void remove(K key) {
        this.table.remove(key);
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        return this.table.size();
    }

    public void clear() {
        this.table.clear();
    }

    public boolean removeElement(K key, V value) {
        boolean[] removed = new boolean[1];
        this.table.computeIfPresent(key, (k, previousList) -> {
            if (!previousList.contains(value)) {
                return previousList;
            }
            ArrayList result = new ArrayList(previousList.size() - 1);
            for (Object v : previousList) {
                if (Objects.equals(v, value) && !removed[0]) {
                    removed[0] = true;
                    continue;
                }
                result.add(v);
            }
            if (result.isEmpty()) {
                return null;
            }
            return Collections.unmodifiableList(result);
        });
        return removed[0];
    }

    @Deprecated
    public Enumeration<K> keys() {
        return Collections.enumeration(this.keySet());
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(new HashSet<K>(this.table.keySet()));
    }

    @Deprecated
    public Enumeration<V> elements() {
        return Collections.enumeration(this.values());
    }

    public Collection<V> values() {
        ArrayList<V> allValues = new ArrayList<V>();
        for (List<V> entryValues : this.table.values()) {
            allValues.addAll(entryValues);
        }
        return Collections.unmodifiableList(allValues);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return Collections.unmodifiableSet(new HashSet<Map.Entry<K, List<V>>>(Collections.unmodifiableMap(this.table).entrySet()));
    }

    public String toString() {
        return "[MultiValueTable table=" + this.table + "]";
    }
}

