/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.RequestTracker;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public abstract class UIDTag {
    private static volatile boolean logMINOR;
    final long createdTime = System.currentTimeMillis();
    final boolean wasLocal;
    private final WeakReference<PeerNode> sourceRef;
    final boolean realTimeFlag;
    protected final RequestTracker tracker;
    protected boolean accepted;
    protected boolean sourceRestarted;
    private HashSet<PeerNode> routedTo = null;
    private HashSet<PeerNode> currentlyRoutingTo = null;
    private HashSet<PeerNode> fetchingOfferedKeyFrom = null;
    private HashSet<PeerNode> handlingTimeouts = null;
    protected boolean notRoutedOnwards;
    final long uid;
    protected boolean unlockedHandler;
    protected boolean noRecordUnlock;
    private boolean hasUnlocked;
    private boolean waitingForSlot;
    private boolean reassigned;
    private long loggedStillPresent;
    private static final long LOGGED_STILL_PRESENT_INTERVAL;
    private boolean timedOutButContinued;

    UIDTag(PeerNode source, boolean realTimeFlag, long uid, Node node) {
        this.sourceRef = source == null ? null : source.myRef;
        this.wasLocal = source == null;
        this.realTimeFlag = realTimeFlag;
        this.tracker = node.getTracker();
        this.uid = uid;
        if (logMINOR) {
            Logger.minor(this, "Created " + this);
        }
        if (this.wasLocal) {
            this.accepted = true;
        }
    }

    public abstract void logStillPresent(Long var1);

    long age() {
        return System.currentTimeMillis() - this.createdTime;
    }

    public synchronized boolean addRoutedTo(PeerNode peer, boolean offeredKey) {
        if (logMINOR) {
            Logger.minor(this, "Routing to " + peer + " on " + this + (offeredKey ? " (offered)" : ""), (Throwable)new Exception("debug"));
        }
        if (this.routedTo == null) {
            this.routedTo = new HashSet();
        }
        this.routedTo.add(peer);
        if (offeredKey) {
            if (this.fetchingOfferedKeyFrom == null) {
                this.fetchingOfferedKeyFrom = new HashSet();
            }
            return this.fetchingOfferedKeyFrom.add(peer);
        }
        if (this.currentlyRoutingTo == null) {
            this.currentlyRoutingTo = new HashSet();
        }
        return this.currentlyRoutingTo.add(peer);
    }

    public synchronized boolean hasRoutedTo(PeerNode peer) {
        if (this.routedTo == null) {
            return false;
        }
        return this.routedTo.contains(peer);
    }

    public synchronized boolean currentlyRoutingTo(PeerNode peer) {
        if (this.currentlyRoutingTo == null) {
            return false;
        }
        return this.currentlyRoutingTo.contains(peer);
    }

    public synchronized boolean currentlyFetchingOfferedKeyFrom(PeerNode peer) {
        if (this.fetchingOfferedKeyFrom == null) {
            return false;
        }
        return this.fetchingOfferedKeyFrom.contains(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFetchingOfferedKeyFrom(PeerNode next) {
        boolean noRecordUnlock;
        UIDTag uIDTag = this;
        synchronized (uIDTag) {
            if (this.fetchingOfferedKeyFrom == null) {
                return;
            }
            this.fetchingOfferedKeyFrom.remove(next);
            if (this.handlingTimeouts != null) {
                this.handlingTimeouts.remove(next);
            }
            if (!this.mustUnlock()) {
                return;
            }
            noRecordUnlock = this.noRecordUnlock;
        }
        if (logMINOR) {
            Logger.minor(this, "Unlocking " + this);
        }
        this.innerUnlock(noRecordUnlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoutingTo(PeerNode next) {
        boolean noRecordUnlock;
        if (logMINOR) {
            Logger.minor(this, "No longer routing to " + next + " on " + this, (Throwable)new Exception("debug"));
        }
        UIDTag uIDTag = this;
        synchronized (uIDTag) {
            if (this.currentlyRoutingTo == null) {
                return;
            }
            if (!this.currentlyRoutingTo.remove(next) && logMINOR) {
                Logger.minor(this, "Removing wrong node or removing twice? on " + this + " : " + next, (Throwable)new Exception("debug"));
            }
            if (this.handlingTimeouts != null) {
                this.handlingTimeouts.remove(next);
            }
            if (!this.mustUnlock()) {
                return;
            }
            noRecordUnlock = this.noRecordUnlock;
        }
        if (logMINOR) {
            Logger.minor(this, "Unlocking " + this);
        }
        this.innerUnlock(noRecordUnlock);
    }

    protected void innerUnlock(boolean noRecordUnlock) {
        this.tracker.unlockUID(this, false, noRecordUnlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUnlock() {
        PeerNode[] peerNodeArray = this;
        synchronized (this) {
            PeerNode[] peers = this.routedTo != null ? this.routedTo.toArray(new PeerNode[this.routedTo.size()]) : null;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (peers != null) {
                for (PeerNode p : peers) {
                    p.postUnlock((UIDTag)this);
                }
            }
            return;
        }
    }

    public abstract int expectedTransfersIn(boolean var1, int var2, boolean var3);

    public abstract int expectedTransfersOut(boolean var1, int var2, boolean var3);

    public synchronized void setNotRoutedOnwards() {
        this.notRoutedOnwards = true;
    }

    public synchronized PeerNode getSource() {
        if (this.reassigned) {
            return null;
        }
        if (this.wasLocal) {
            return null;
        }
        return (PeerNode)this.sourceRef.get();
    }

    public synchronized void reassignToSelf() {
        if (this.wasLocal) {
            return;
        }
        this.reassigned = true;
    }

    public boolean wasLocal() {
        return this.wasLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal() {
        if (this.wasLocal) {
            return true;
        }
        UIDTag uIDTag = this;
        synchronized (uIDTag) {
            return this.reassigned;
        }
    }

    public abstract boolean isSSK();

    public abstract boolean isInsert();

    public abstract boolean isOfferReply();

    protected synchronized boolean mustUnlock() {
        if (this.hasUnlocked) {
            return false;
        }
        if (!this.unlockedHandler) {
            return false;
        }
        if (this.currentlyRoutingTo != null && !this.currentlyRoutingTo.isEmpty()) {
            if (!(this.reassigned || this.wasLocal || this.sourceRestarted || this.timedOutButContinued)) {
                boolean expected = false;
                if (this.handlingTimeouts != null) {
                    expected = true;
                    for (PeerNode pn : this.currentlyRoutingTo) {
                        if (this.handlingTimeouts.contains(pn)) {
                            if (!logMINOR) break;
                            Logger.debug(this, "Still waiting for " + pn.shortToString() + " but expected because handling timeout in unlockHandler - will reassign to self to resolve timeouts");
                            break;
                        }
                        expected = false;
                    }
                }
                if (!expected) {
                    if (this.handlingTimeouts != null) {
                        Logger.normal(this, "Unlocked handler but still routing to " + this.currentlyRoutingTo + " - expected because have timed out so a fork might have succeeded and we might be waiting for the original");
                    } else {
                        Logger.error(this, "Unlocked handler but still routing to " + this.currentlyRoutingTo + " yet not reassigned on " + this, (Throwable)new Exception("debug"));
                    }
                } else {
                    this.reassignToSelf();
                }
            }
            return false;
        }
        if (this.fetchingOfferedKeyFrom != null && !this.fetchingOfferedKeyFrom.isEmpty()) {
            if (!this.reassigned && !this.wasLocal) {
                boolean expected = false;
                if (this.handlingTimeouts != null) {
                    expected = true;
                    for (PeerNode pn : this.fetchingOfferedKeyFrom) {
                        if (this.handlingTimeouts.contains(pn)) {
                            if (!logMINOR) break;
                            Logger.debug(this, "Still waiting for " + pn.shortToString() + " but expected because handling timeout in unlockHandler - will reassign to self to resolve timeouts");
                            break;
                        }
                        expected = false;
                    }
                }
                if (!expected) {
                    Logger.error(this, "Unlocked handler but still fetching offered keys from " + this.fetchingOfferedKeyFrom + " yet not reassigned on " + this, (Throwable)new Exception("debug"));
                } else {
                    this.reassignToSelf();
                }
            }
            return false;
        }
        this.hasUnlocked = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockHandler(boolean noRecord) {
        boolean canUnlock;
        UIDTag uIDTag = this;
        synchronized (uIDTag) {
            if (this.unlockedHandler) {
                return;
            }
            this.noRecordUnlock = noRecord;
            this.unlockedHandler = true;
            canUnlock = this.mustUnlock();
        }
        if (canUnlock) {
            this.innerUnlock(this.noRecordUnlock);
        } else {
            Logger.normal(this, "Cannot unlock yet in unlockHandler, still sending requests");
        }
    }

    public void unlockHandler() {
        this.unlockHandler(false);
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(":");
        sb.append(this.uid);
        if (this.unlockedHandler) {
            sb.append(" (unlocked handler)");
        }
        if (this.hasUnlocked) {
            sb.append(" (unlocked)");
        }
        if (this.noRecordUnlock) {
            sb.append(" (don't record unlock)");
        }
        if (this.currentlyRoutingTo != null && !this.currentlyRoutingTo.isEmpty()) {
            sb.append(" (routing to ");
            for (PeerNode pn : this.currentlyRoutingTo) {
                sb.append(pn.shortToString());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(")");
        }
        if (this.fetchingOfferedKeyFrom != null) {
            sb.append(" (fetch offered keys from ").append(this.fetchingOfferedKeyFrom.size()).append(")");
        }
        if (this.sourceRestarted) {
            sb.append(" (source restarted)");
        }
        if (this.timedOutButContinued) {
            sb.append(" (timed out but continued)");
        }
        return sb.toString();
    }

    public synchronized void handlingTimeout(PeerNode next) {
        if (this.handlingTimeouts == null) {
            this.handlingTimeouts = new HashSet();
        }
        this.handlingTimeouts.add(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeLogStillPresent(long now, Long uid) {
        if (now - this.createdTime > RequestTracker.TIMEOUT) {
            UIDTag uIDTag = this;
            synchronized (uIDTag) {
                if (now - this.loggedStillPresent < LOGGED_STILL_PRESENT_INTERVAL) {
                    return;
                }
                this.loggedStillPresent = now;
            }
            this.logStillPresent(uid);
        }
    }

    public synchronized void setAccepted() {
        this.accepted = true;
    }

    public synchronized void timedOutToHandlerButContinued() {
        this.timedOutButContinued = true;
    }

    public synchronized void onRestartOrDisconnectSource() {
        this.sourceRestarted = true;
    }

    public synchronized boolean countAsSourceRestarted() {
        return this.sourceRestarted || this.timedOutButContinued;
    }

    public synchronized boolean hasSourceReallyRestarted() {
        return this.sourceRestarted;
    }

    public synchronized boolean shouldStop() {
        return this.sourceRestarted || this.timedOutButContinued;
    }

    public synchronized boolean isSource(PeerNode pn) {
        if (this.reassigned) {
            return false;
        }
        if (this.wasLocal) {
            return false;
        }
        if (this.sourceRef == null) {
            return false;
        }
        return this.sourceRef == pn.myRef;
    }

    public synchronized void setWaitingForSlot() {
        if (this.waitingForSlot) {
            return;
        }
        this.waitingForSlot = true;
    }

    public synchronized void clearWaitingForSlot() {
        if (!this.waitingForSlot) {
            return;
        }
        this.waitingForSlot = false;
    }

    public synchronized boolean isWaitingForSlot() {
        return this.waitingForSlot;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        LOGGED_STILL_PRESENT_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
    }
}

