/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.PeerNode;
import freenet.node.UIDTag;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class UIDRoutingContextTracker {
    private final HashMap<Long, UIDRoutingContext> routingContexts = new HashMap();

    public class UIDRoutingContext {
        public final Long uid;
        public final boolean insert;
        private final ArrayList<UIDTag> tags;
        private final Set<WeakReference<PeerNode>> routedTo;
        private boolean finished;

        UIDRoutingContext(long uid, boolean insert) {
            this.uid = uid;
            this.insert = insert;
            this.tags = new ArrayList();
            this.routedTo = new HashSet<WeakReference<PeerNode>>();
            this.finished = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(UIDTag tag) {
            UIDRoutingContextTracker uIDRoutingContextTracker = UIDRoutingContextTracker.this;
            synchronized (uIDRoutingContextTracker) {
                if (this.finished) {
                    throw new IllegalStateException();
                }
                if (!this.tags.contains(tag)) {
                    this.tags.add(tag);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(UIDTag tag) {
            UIDRoutingContextTracker uIDRoutingContextTracker = UIDRoutingContextTracker.this;
            synchronized (uIDRoutingContextTracker) {
                this.tags.remove(tag);
                if (this.tags.isEmpty()) {
                    this.removeMe();
                }
            }
        }

        private void removeMe() {
            this.finished = true;
            UIDRoutingContextTracker.this.routingContexts.remove(this.uid);
        }
    }
}

