/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerGroup;
import freenet.client.async.ClientRequester;
import freenet.node.KeysFetchingLocally;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.RandomGrabArrayItem;
import java.io.Serializable;

public abstract class SendableRequest
implements RandomGrabArrayItem,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int hashCode;
    protected final boolean realTimeFlag;
    private static volatile boolean logMINOR;
    protected transient RandomGrabArray parentGrabArray;
    protected final boolean persistent;

    SendableRequest(boolean persistent, boolean realTimeFlag) {
        this.persistent = persistent;
        this.realTimeFlag = realTimeFlag;
        int oid = super.hashCode();
        if (oid == 0) {
            oid = 1;
        }
        this.hashCode = oid;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public abstract short getPriorityClass();

    public abstract SendableRequestItem chooseKey(KeysFetchingLocally var1, ClientContext var2);

    public abstract long countAllKeys(ClientContext var1);

    public abstract long countSendableKeys(ClientContext var1);

    public abstract SendableRequestSender getSender(ClientContext var1);

    public abstract boolean isCancelled();

    public abstract RequestClient getClient();

    public final boolean persistent() {
        return this.persistent;
    }

    public abstract ClientRequester getClientRequest();

    @Override
    public synchronized RandomGrabArray getParentGrabArray() {
        return this.parentGrabArray;
    }

    private synchronized RandomGrabArray grabParentGrabArray() {
        RandomGrabArray ret = this.parentGrabArray;
        this.parentGrabArray = null;
        return ret;
    }

    @Override
    public boolean knowsParentGrabArray() {
        return true;
    }

    @Override
    public synchronized void setParentGrabArray(RandomGrabArray parent) {
        this.parentGrabArray = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ClientContext context, short oldPrio) {
        RandomGrabArray arr = this.grabParentGrabArray();
        if (arr != null) {
            ClientRequestScheduler clientRequestScheduler = this.getScheduler(context);
            synchronized (clientRequestScheduler) {
                arr.remove(this, context);
            }
        } else if (logMINOR) {
            Logger.minor(this, "Cannot unregister " + this + " : not registered", (Throwable)new Exception("debug"));
        }
    }

    public abstract ClientRequestScheduler getScheduler(ClientContext var1);

    public abstract boolean isSSK();

    public abstract boolean isInsert();

    public abstract void internalError(Throwable var1, RequestScheduler var2, ClientContext var3, boolean var4);

    public boolean realTimeFlag() {
        return this.realTimeFlag;
    }

    protected final String objectToString() {
        return super.toString();
    }

    @Override
    public boolean reduceWakeupTime(long wakeupTime, ClientContext context) {
        RandomGrabArray parent = this.getParentGrabArray();
        if (parent == null) {
            return false;
        }
        return parent.reduceWakeupTime(wakeupTime, context);
    }

    @Override
    public void clearWakeupTime(ClientContext context) {
        RandomGrabArray parent = this.getParentGrabArray();
        if (parent == null) {
            return;
        }
        parent.clearWakeupTime(context);
    }

    public ClientRequestSchedulerGroup getSchedulerGroup() {
        return this.getClientRequest().getSchedulerGroup();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

