/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.InvalidConfigValueException;
import freenet.config.Option;
import freenet.config.OptionFormatException;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.support.api.BooleanCallback;

public class BooleanOption
extends Option<Boolean> {
    public BooleanOption(SubConfig conf, String optionName, boolean defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, BooleanCallback cb) {
        super(conf, optionName, cb, sortOrder, expert, forceWrite, shortDesc, longDesc, Option.DataType.BOOLEAN);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
    }

    @Override
    public Boolean parseString(String val) throws InvalidConfigValueException {
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes")) {
            return true;
        }
        if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no")) {
            return false;
        }
        throw new OptionFormatException(NodeL10n.getBase().getString("BooleanOption.parseError", "val", val));
    }

    @Override
    protected String toString(Boolean val) {
        return val.toString();
    }
}

